/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang;

import com.whaleal.icefrog.core.bean.BeanUtil;
import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.getter.BasicTypeGetter;
import com.whaleal.icefrog.core.lang.Pair;
import com.whaleal.icefrog.core.lang.Precondition;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class Dict
extends LinkedHashMap<String, Object>
implements BasicTypeGetter<String> {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final long serialVersionUID = 6135423866861206530L;
    private boolean caseInsensitive;

    public Dict() {
        this(false);
    }

    public Dict(boolean caseInsensitive) {
        this(16, caseInsensitive);
    }

    public Dict(int initialCapacity) {
        this(initialCapacity, false);
    }

    public Dict(int initialCapacity, boolean caseInsensitive) {
        this(initialCapacity, 0.75f, caseInsensitive);
    }

    public Dict(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public Dict(int initialCapacity, float loadFactor, boolean caseInsensitive) {
        super(initialCapacity, loadFactor);
        this.caseInsensitive = caseInsensitive;
    }

    public Dict(Map<String, Object> m) {
        super(null == m ? new HashMap() : m);
    }

    public static Dict create() {
        return new Dict();
    }

    public static <T> Dict parse(T bean) {
        return Dict.create().parseBean(bean);
    }

    @SafeVarargs
    public static Dict of(Pair<String, Object> ... pairs) {
        Dict dict = Dict.create();
        for (Pair<String, Object> pair : pairs) {
            dict.put(pair.getKey(), pair.getValue());
        }
        return dict;
    }

    public static Dict of(Object ... keysAndValues) {
        Dict dict = Dict.create();
        String key = null;
        for (int i = 0; i < keysAndValues.length; ++i) {
            if (i % 2 == 0) {
                key = Convert.toStr(keysAndValues[i]);
                continue;
            }
            dict.put(key, keysAndValues[i]);
        }
        return dict;
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBeanIgnoreCase(T bean) {
        BeanUtil.fillBeanWithMapIgnoreCase(this, bean, false);
        return bean;
    }

    public <T> T toBean(T bean, boolean isToCamelCase) {
        BeanUtil.fillBeanWithMap(this, bean, isToCamelCase, false);
        return bean;
    }

    public <T> T toBeanWithCamelCase(T bean) {
        BeanUtil.fillBeanWithMap(this, bean, true, false);
        return bean;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtil.toBean(this, clazz);
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanUtil.toBeanIgnoreCase(this, clazz, false);
    }

    public <T> Dict parseBean(T bean) {
        Precondition.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll((Map<? extends String, ?>)BeanUtil.beanToMap(bean));
        return this;
    }

    public <T> Dict parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        Precondition.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll((Map<? extends String, ?>)BeanUtil.beanToMap(bean, isToUnderlineCase, ignoreNullValue));
        return this;
    }

    public <T extends Dict> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = CollUtil.newHashSet(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || null == (value = this.get(entry.getKey())) || !value.equals(entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dict filter(String ... keys) {
        Dict result = new Dict(keys.length, 1.0f);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public Dict set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dict setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    @Override
    public Object getObj(String key) {
        return super.get(key);
    }

    public <T> T getBean(String attr) {
        return this.get(attr, null);
    }

    public <T> T get(String attr, T defaultValue) {
        Object result = this.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    @Override
    public String getStr(String attr) {
        return Convert.toStr(this.get(attr), null);
    }

    @Override
    public Integer getInt(String attr) {
        return Convert.toInt(this.get(attr), null);
    }

    @Override
    public Long getLong(String attr) {
        return Convert.toLong(this.get(attr), null);
    }

    @Override
    public Float getFloat(String attr) {
        return Convert.toFloat(this.get(attr), null);
    }

    @Override
    public Short getShort(String attr) {
        return Convert.toShort(this.get(attr), null);
    }

    @Override
    public Character getChar(String attr) {
        return Convert.toChar(this.get(attr), null);
    }

    @Override
    public Double getDouble(String attr) {
        return Convert.toDouble(this.get(attr), null);
    }

    @Override
    public Byte getByte(String attr) {
        return Convert.toByte(this.get(attr), null);
    }

    @Override
    public Boolean getBool(String attr) {
        return Convert.toBool(this.get(attr), null);
    }

    @Override
    public BigDecimal getBigDecimal(String attr) {
        return Convert.toBigDecimal(this.get(attr));
    }

    @Override
    public BigInteger getBigInteger(String attr) {
        return Convert.toBigInteger(this.get(attr));
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return Convert.toEnum(clazz, this.get(key));
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Object get(Object key) {
        return super.get(this.customKey((String)key));
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(this.customKey(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public Dict clone() {
        return (Dict)super.clone();
    }

    private String customKey(String key) {
        if (this.caseInsensitive && null != key) {
            key = key.toLowerCase();
        }
        return key;
    }
}

