/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang.tree;

import com.whaleal.icefrog.core.builder.Builder;
import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.lang.tree.Tree;
import com.whaleal.icefrog.core.lang.tree.TreeNodeConfig;
import com.whaleal.icefrog.core.lang.tree.parser.NodeParser;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreeBuilder<E>
implements Builder<Tree<E>> {
    private static final long serialVersionUID = 1L;
    private final Tree<E> root;
    private final Map<E, Tree<E>> idTreeMap;
    private boolean isBuild;

    public TreeBuilder(E rootId, TreeNodeConfig config) {
        this.root = new Tree(config);
        this.root.setId((Object)rootId);
        this.idTreeMap = new HashMap<E, Tree<E>>();
    }

    public static <T> TreeBuilder<T> of(T rootId) {
        return TreeBuilder.of(rootId, null);
    }

    public static <T> TreeBuilder<T> of(T rootId, TreeNodeConfig config) {
        return new TreeBuilder<T>(rootId, config);
    }

    public TreeBuilder<E> append(Map<E, Tree<E>> map) {
        this.checkBuilt();
        Precondition.isFalse(this.isBuild, "Current tree has been built.", new Object[0]);
        this.idTreeMap.putAll(map);
        return this;
    }

    public TreeBuilder<E> append(Iterable<Tree<E>> trees) {
        this.checkBuilt();
        for (Tree<E> tree : trees) {
            this.idTreeMap.put(tree.getId(), tree);
        }
        return this;
    }

    public <T> TreeBuilder<E> append(List<T> list, NodeParser<T, E> nodeParser) {
        this.checkBuilt();
        TreeNodeConfig config = this.root.getConfig();
        LinkedHashMap map = new LinkedHashMap(list.size(), 1.0f);
        for (T t : list) {
            Tree node = new Tree(config);
            nodeParser.parse(t, node);
            map.put(node.getId(), node);
        }
        return this.append(map);
    }

    public TreeBuilder<E> reset() {
        this.idTreeMap.clear();
        this.root.setChildren(null);
        this.isBuild = false;
        return this;
    }

    @Override
    public Tree<E> build() {
        this.checkBuilt();
        this.buildFromMap();
        this.cutTree();
        this.isBuild = true;
        this.idTreeMap.clear();
        return this.root;
    }

    public List<Tree<E>> buildList() {
        if (this.isBuild) {
            return this.root.getChildren();
        }
        return ((Tree)this.build()).getChildren();
    }

    private void buildFromMap() {
        if (MapUtil.isEmpty(this.idTreeMap)) {
            return;
        }
        Map<E, Tree<E>> eTreeMap = MapUtil.sortByValue(this.idTreeMap, false);
        ArrayList<Tree> rootTreeList = CollUtil.newArrayList(new Tree[0]);
        for (Tree<E> node : eTreeMap.values()) {
            if (null == node) continue;
            E parentId = node.getParentId();
            if (ObjectUtil.equals(this.root.getId(), parentId)) {
                this.root.addChildren(node);
                rootTreeList.add(node);
                continue;
            }
            Tree<E> parentNode = eTreeMap.get(parentId);
            if (null == parentNode) continue;
            parentNode.addChildren(node);
        }
    }

    private void cutTree() {
        TreeNodeConfig config = this.root.getConfig();
        Integer deep = config.getDeep();
        if (null == deep || deep < 0) {
            return;
        }
        this.cutTree(this.root, 0, deep);
    }

    private void cutTree(Tree<E> tree, int currentDepp, int maxDeep) {
        if (null == tree) {
            return;
        }
        if (currentDepp == maxDeep) {
            tree.setChildren(null);
            return;
        }
        List<Tree<E>> children = tree.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            for (Tree<E> child : children) {
                this.cutTree(child, currentDepp + 1, maxDeep);
            }
        }
    }

    private void checkBuilt() {
        Precondition.isFalse(this.isBuild, "Current tree has been built.", new Object[0]);
    }
}

