/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.template.engine.enjoy;

import com.jfinal.template.Engine;
import com.jfinal.template.source.FileSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.util.IdUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.extra.template.Template;
import com.whaleal.icefrog.extra.template.TemplateConfig;
import com.whaleal.icefrog.extra.template.TemplateEngine;
import com.whaleal.icefrog.extra.template.engine.enjoy.EnjoyTemplate;
import java.io.File;

public class EnjoyEngine
implements TemplateEngine {
    private Engine engine;
    private TemplateConfig.ResourceMode resourceMode;

    public EnjoyEngine() {
    }

    public EnjoyEngine(TemplateConfig config) {
        this.init(config);
    }

    public EnjoyEngine(Engine engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.resourceMode = config.getResourceMode();
        this.init(EnjoyEngine.createEngine(config));
        return this;
    }

    private void init(Engine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        if (ObjectUtil.equal((Object)TemplateConfig.ResourceMode.STRING, (Object)this.resourceMode)) {
            return EnjoyTemplate.wrap(this.engine.getTemplateByString(resource));
        }
        return EnjoyTemplate.wrap(this.engine.getTemplate(resource));
    }

    private static Engine createEngine(TemplateConfig config) {
        Engine engine = Engine.create((String)("Hutool-Enjoy-Engine-" + IdUtil.fastSimpleUUID()));
        engine.setEncoding(config.getCharsetStr());
        switch (config.getResourceMode()) {
            case STRING: {
                break;
            }
            case CLASSPATH: {
                engine.setToClassPathSourceFactory();
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case FILE: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case WEB_ROOT: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                File root = FileUtil.file(FileUtil.getWebRoot(), config.getPath());
                engine.setBaseTemplatePath(FileUtil.getAbsolutePath(root));
                break;
            }
        }
        return engine;
    }
}

