/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.log.dialect.console;

import com.whaleal.icefrog.core.date.DateUtil;
import com.whaleal.icefrog.core.lang.Console;
import com.whaleal.icefrog.core.lang.Dict;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.log.AbstractLog;
import com.whaleal.icefrog.log.level.Level;

public class ConsoleLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String logFormat = "[{date}] [{level}] {name}: {msg}";
    private static Level currentLevel = Level.DEBUG;
    private final String name;

    public ConsoleLog(Class<?> clazz) {
        this.name = null == clazz ? "null" : clazz.getName();
    }

    public ConsoleLog(String name) {
        this.name = name;
    }

    public static void setLevel(Level customLevel) {
        Precondition.notNull(customLevel);
        currentLevel = customLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.WARN, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        Dict dict = Dict.create().set("date", DateUtil.now()).set("level", level.toString()).set("name", this.name).set("msg", StrUtil.format(format, arguments));
        String logMsg = StrUtil.format((CharSequence)logFormat, dict);
        if (level.ordinal() >= Level.WARN.ordinal()) {
            Console.error(t, logMsg, new Object[0]);
        } else {
            Console.log(t, logMsg, new Object[0]);
        }
    }

    @Override
    public boolean isEnabled(Level level) {
        return currentLevel.compareTo(level) <= 0;
    }
}

