/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.poi.excel.cell.setters;

import com.whaleal.icefrog.poi.excel.cell.CellSetter;
import com.whaleal.icefrog.poi.excel.cell.setters.BooleanCellSetter;
import com.whaleal.icefrog.poi.excel.cell.setters.CalendarCellSetter;
import com.whaleal.icefrog.poi.excel.cell.setters.CharSequenceCellSetter;
import com.whaleal.icefrog.poi.excel.cell.setters.DateCellSetter;
import com.whaleal.icefrog.poi.excel.cell.setters.NullCellSetter;
import com.whaleal.icefrog.poi.excel.cell.setters.NumberCellSetter;
import com.whaleal.icefrog.poi.excel.cell.setters.RichTextCellSetter;
import com.whaleal.icefrog.poi.excel.cell.setters.TemporalAccessorCellSetter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.RichTextString;

public class CellSetterFactory {
    public static CellSetter createCellSetter(Object value) {
        if (null == value) {
            return NullCellSetter.INSTANCE;
        }
        if (value instanceof CellSetter) {
            return (CellSetter)value;
        }
        if (value instanceof Date) {
            return new DateCellSetter((Date)value);
        }
        if (value instanceof TemporalAccessor) {
            return new TemporalAccessorCellSetter((TemporalAccessor)value);
        }
        if (value instanceof Calendar) {
            return new CalendarCellSetter((Calendar)value);
        }
        if (value instanceof Boolean) {
            return new BooleanCellSetter((Boolean)value);
        }
        if (value instanceof RichTextString) {
            return new RichTextCellSetter((RichTextString)value);
        }
        if (value instanceof Number) {
            return new NumberCellSetter((Number)value);
        }
        return new CharSequenceCellSetter(value.toString());
    }
}

