/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.bloomfilter;

import com.whaleal.icefrog.bloomfilter.BloomFilter;
import com.whaleal.icefrog.bloomfilter.filter.DefaultFilter;
import com.whaleal.icefrog.bloomfilter.filter.ELFFilter;
import com.whaleal.icefrog.bloomfilter.filter.JSFilter;
import com.whaleal.icefrog.bloomfilter.filter.PJWFilter;
import com.whaleal.icefrog.bloomfilter.filter.SDBMFilter;
import com.whaleal.icefrog.core.util.NumberUtil;

public class BitMapBloomFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    private BloomFilter[] filters;

    public BitMapBloomFilter(int m) {
        long mNum = NumberUtil.div(String.valueOf(m), String.valueOf(5)).longValue();
        long size = mNum * 1024L * 1024L * 8L;
        this.filters = new BloomFilter[]{new DefaultFilter(size), new ELFFilter(size), new JSFilter(size), new PJWFilter(size), new SDBMFilter(size)};
    }

    public BitMapBloomFilter(int m, BloomFilter ... filters) {
        this(m);
        this.filters = filters;
    }

    @Override
    public boolean add(String str) {
        boolean flag = false;
        for (BloomFilter filter : this.filters) {
            flag |= filter.add(str);
        }
        return flag;
    }

    @Override
    public boolean contains(String str) {
        for (BloomFilter filter : this.filters) {
            if (filter.contains(str)) continue;
            return false;
        }
        return true;
    }
}

