/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.cache.impl;

import com.whaleal.icefrog.cache.impl.AbstractCache;
import com.whaleal.icefrog.cache.impl.CacheObj;
import com.whaleal.icefrog.core.map.FixedLinkedHashMap;
import java.util.Iterator;

public class LRUCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;

    public LRUCache(int capacity) {
        this(capacity, 0L);
    }

    public LRUCache(int capacity, long timeout) {
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new FixedLinkedHashMap(capacity);
    }

    @Override
    protected int pruneCache() {
        if (!this.isPruneExpiredActive()) {
            return 0;
        }
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj co = (CacheObj)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }
}

