/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.codec;

import com.whaleal.icefrog.core.codec.Decoder;
import com.whaleal.icefrog.core.codec.Reader;
import com.whaleal.icefrog.core.lang.Precondition;

public final class DecoderContext {
    private static final DecoderContext DEFAULT_CONTEXT = DecoderContext.builder().build();
    private final boolean checkedDiscriminator;

    private DecoderContext(Builder builder) {
        this.checkedDiscriminator = builder.hasCheckedDiscriminator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasCheckedDiscriminator() {
        return this.checkedDiscriminator;
    }

    public <T> T decodeWithChildContext(Decoder<T> decoder, Reader reader) {
        Precondition.notNull(decoder);
        return decoder.decode(reader, DEFAULT_CONTEXT);
    }

    public static final class Builder
    implements com.whaleal.icefrog.core.builder.Builder<DecoderContext> {
        private boolean checkedDiscriminator;

        private Builder() {
        }

        public boolean hasCheckedDiscriminator() {
            return this.checkedDiscriminator;
        }

        public Builder checkedDiscriminator(boolean checkedDiscriminator) {
            this.checkedDiscriminator = checkedDiscriminator;
            return this;
        }

        @Override
        public DecoderContext build() {
            return new DecoderContext(this);
        }
    }
}

