/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.collection.IterUtil;
import com.whaleal.icefrog.core.comparator.CompareUtil;
import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.ClassUtil;
import com.whaleal.icefrog.core.util.NumberUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.SerializeUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;

public class ObjectUtil {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";

    private ObjectUtil() {
    }

    public static boolean equals(Object obj1, Object obj2) {
        return ObjectUtil.equal(obj1, obj2);
    }

    public static boolean equal(Object obj1, Object obj2) {
        if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
            return NumberUtil.equals((BigDecimal)obj1, (BigDecimal)obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static boolean notEqual(Object obj1, Object obj2) {
        return false == ObjectUtil.equal(obj1, obj2);
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).containsValue(element);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ObjectUtil.equal(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ObjectUtil.equal(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!ObjectUtil.equal(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        return null == obj || obj.equals(null);
    }

    public static boolean isNotNull(Object obj) {
        return false == ObjectUtil.isNull(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)obj);
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)obj);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.isEmpty(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return false == ObjectUtil.isEmpty(obj);
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return null != object ? object : defaultValue;
    }

    public static <T> T defaultIfNull(Object source, Supplier<? extends T> handle, T defaultValue) {
        if (Objects.nonNull(source)) {
            return handle.get();
        }
        return defaultValue;
    }

    public static <T> T defaultIfEmpty(String str, Supplier<? extends T> handle, T defaultValue) {
        if (StrUtil.isNotEmpty(str)) {
            return handle.get();
        }
        return defaultValue;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultValue) {
        return StrUtil.isEmpty(str) ? defaultValue : str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultValue) {
        return StrUtil.isBlank(str) ? defaultValue : str;
    }

    public static <T> T clone(T obj) {
        T result = ArrayUtil.clone(obj);
        if (null == result) {
            result = obj instanceof Cloneable ? ReflectUtil.invoke(obj, "clone", new Object[0]) : ObjectUtil.cloneByStream(obj);
        }
        return result;
    }

    public static <T> T cloneIfPossible(T obj) {
        Object clone = null;
        try {
            clone = ObjectUtil.clone(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)(clone == null ? obj : clone);
    }

    public static <T> T cloneByStream(T obj) {
        return SerializeUtil.clone(obj);
    }

    public static <T> byte[] serialize(T obj) {
        return SerializeUtil.serialize(obj);
    }

    public static <T> T deserialize(byte[] bytes) {
        return SerializeUtil.deserialize(bytes);
    }

    public static boolean isBasicType(Object object) {
        return ClassUtil.isBasicType(object.getClass());
    }

    public static boolean isValidIfNumber(Object obj) {
        if (obj instanceof Number) {
            return NumberUtil.isValidNumber((Number)obj);
        }
        return true;
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        return CompareUtil.compare(c1, c2);
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean nullGreater) {
        return CompareUtil.compare(c1, c2, nullGreater);
    }

    public static Class<?> getTypeArgument(Object obj) {
        return ObjectUtil.getTypeArgument(obj, 0);
    }

    public static Class<?> getTypeArgument(Object obj, int index) {
        return ClassUtil.getTypeArgument(obj.getClass(), index);
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return NULL_STRING;
        }
        if (obj instanceof Map) {
            return obj.toString();
        }
        return Convert.toStr(obj);
    }

    public static int emptyCount(Object ... objs) {
        return ArrayUtil.emptyCount(objs);
    }

    public static boolean hasNull(Object ... objs) {
        return ArrayUtil.hasNull(objs);
    }

    public static boolean hasEmpty(Object ... objs) {
        return ArrayUtil.hasEmpty(objs);
    }

    public static boolean isAllEmpty(Object ... objs) {
        return ArrayUtil.isAllEmpty(objs);
    }

    public static boolean isAllNotEmpty(Object ... objs) {
        return ArrayUtil.isAllNotEmpty(objs);
    }

    public static int hashCode(Object ... objects) {
        return Objects.hash(objects);
    }

    public static boolean isCheckedException(Throwable ex) {
        return !(ex instanceof RuntimeException) && !(ex instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex, Class<?> ... declaredExceptions) {
        if (!ObjectUtil.isCheckedException(ex)) {
            return true;
        }
        if (declaredExceptions != null) {
            for (Class<?> declaredException : declaredExceptions) {
                if (!declaredException.isInstance(ex)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(Object obj) {
        return ArrayUtil.isArray(obj);
    }

    public static <T> boolean isEmpty(T[] array) {
        return ArrayUtil.isEmpty(array);
    }

    public static Object unwrapOptional(Object obj) {
        if (obj instanceof Optional) {
            Optional optional = (Optional)obj;
            if (!optional.isPresent()) {
                return null;
            }
            Object result = optional.get();
            Precondition.isTrue(!(result instanceof Optional), "Multi-level Optional usage not supported");
            return result;
        }
        return obj;
    }

    public static boolean containsElement(Object[] array, Object element) {
        if (array == null) {
            return false;
        }
        for (Object arrayEle : array) {
            if (!ObjectUtil.nullSafeEquals(arrayEle, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant) {
        return ObjectUtil.containsConstant(enumValues, constant, false);
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant, boolean caseSensitive) {
        for (Enum<?> candidate : enumValues) {
            if (!(caseSensitive ? candidate.toString().equals(constant) : candidate.toString().equalsIgnoreCase(constant))) continue;
            return true;
        }
        return false;
    }

    public static <E extends Enum<?>> E caseInsensitiveValueOf(E[] enumValues, String constant) {
        for (E candidate : enumValues) {
            if (!((Enum)candidate).toString().equalsIgnoreCase(constant)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Constant [" + constant + "] does not exist in enum type " + enumValues.getClass().getComponentType().getName());
    }

    public static <A, O extends A> A[] addObjectToArray(A[] array, O obj) {
        Class compType = Object.class;
        if (array != null) {
            compType = array.getClass().getComponentType();
        } else if (obj != null) {
            compType = obj.getClass();
        }
        int newArrLength = array != null ? array.length + 1 : 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (array != null) {
            System.arraycopy(array, 0, newArr, 0, array.length);
        }
        newArr[newArr.length - 1] = obj;
        return newArr;
    }

    public static Object[] toArray(Object value) {
        return ArrayUtil.toArray(value);
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ObjectUtil.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    public static int nullSafeHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return ObjectUtil.nullSafeHashCode((Object[])obj);
            }
            if (obj instanceof boolean[]) {
                return ObjectUtil.nullSafeHashCode((boolean[])obj);
            }
            if (obj instanceof byte[]) {
                return ObjectUtil.nullSafeHashCode((byte[])obj);
            }
            if (obj instanceof char[]) {
                return ObjectUtil.nullSafeHashCode((char[])obj);
            }
            if (obj instanceof double[]) {
                return ObjectUtil.nullSafeHashCode((double[])obj);
            }
            if (obj instanceof float[]) {
                return ObjectUtil.nullSafeHashCode((float[])obj);
            }
            if (obj instanceof int[]) {
                return ObjectUtil.nullSafeHashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return ObjectUtil.nullSafeHashCode((long[])obj);
            }
            if (obj instanceof short[]) {
                return ObjectUtil.nullSafeHashCode((short[])obj);
            }
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (Object element : array) {
            hash = 31 * hash + ObjectUtil.nullSafeHashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (boolean element : array) {
            hash = 31 * hash + Boolean.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (byte element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (char element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (double element : array) {
            hash = 31 * hash + Double.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (float element : array) {
            hash = 31 * hash + Float.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (int element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (long element : array) {
            hash = 31 * hash + Long.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (short element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static String identityToString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return obj.getClass().getName() + "@" + ObjectUtil.getIdentityHexString(obj);
    }

    public static String getIdentityHexString(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static String getDisplayString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return ObjectUtil.nullSafeToString(obj);
    }

    public static String nullSafeClassName(Object obj) {
        return obj != null ? obj.getClass().getName() : NULL_STRING;
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return NULL_STRING;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return ObjectUtil.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ObjectUtil.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return ObjectUtil.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return ObjectUtil.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return ObjectUtil.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return ObjectUtil.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return ObjectUtil.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return ObjectUtil.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return ObjectUtil.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : EMPTY_STRING;
    }

    public static String nullSafeToString(Object[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (Object o : array) {
            stringJoiner.add(String.valueOf(o));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(boolean[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (boolean b : array) {
            stringJoiner.add(String.valueOf(b));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(byte[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (byte b : array) {
            stringJoiner.add(String.valueOf(b));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(char[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (char c : array) {
            stringJoiner.add('\'' + String.valueOf(c) + '\'');
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(double[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (double d : array) {
            stringJoiner.add(String.valueOf(d));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(float[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (float f : array) {
            stringJoiner.add(String.valueOf(f));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(int[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (int i : array) {
            stringJoiner.add(String.valueOf(i));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(long[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (long l : array) {
            stringJoiner.add(String.valueOf(l));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(short[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (short s : array) {
            stringJoiner.add(String.valueOf(s));
        }
        return stringJoiner.toString();
    }
}

