/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.ds.pooled;

import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.DbRuntimeException;
import com.whaleal.icefrog.db.dialect.DriverUtil;
import com.whaleal.icefrog.db.ds.DSFactory;
import com.whaleal.icefrog.db.ds.pooled.DbConfig;
import com.whaleal.icefrog.setting.Setting;

public class DbSetting {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private final Setting setting;

    public DbSetting() {
        this(null);
    }

    public DbSetting(Setting setting) {
        this.setting = null == setting ? new Setting(DEFAULT_DB_CONFIG_PATH) : setting;
    }

    public DbConfig getDbConfig(String group) {
        Setting config = this.setting.getSetting(group);
        if (MapUtil.isEmpty(config)) {
            throw new DbRuntimeException("No icefrog pool config for group: [{}]", group);
        }
        DbConfig dbConfig = new DbConfig();
        String url = config.getAndRemoveStr(DSFactory.KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        dbConfig.setUrl(url);
        String driver = config.getAndRemoveStr(DSFactory.KEY_ALIAS_DRIVER);
        dbConfig.setDriver(StrUtil.isNotBlank(driver) ? driver : DriverUtil.identifyDriver(url));
        dbConfig.setUser(config.getAndRemoveStr(DSFactory.KEY_ALIAS_USER));
        dbConfig.setPass(config.getAndRemoveStr(DSFactory.KEY_ALIAS_PASSWORD));
        dbConfig.setInitialSize(this.setting.getInt("initialSize", group, 0));
        dbConfig.setMinIdle(this.setting.getInt("minIdle", group, 0));
        dbConfig.setMaxActive(this.setting.getInt("maxActive", group, 8));
        dbConfig.setMaxWait(this.setting.getLong("maxWait", group, 6000L));
        for (String key : DSFactory.KEY_CONN_PROPS) {
            String connValue = config.get(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        return dbConfig;
    }
}

