/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.expression.engine;

import com.whaleal.icefrog.core.lang.Singleton;
import com.whaleal.icefrog.core.util.ServiceLoaderUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.extra.expression.ExpressionEngine;
import com.whaleal.icefrog.extra.expression.ExpressionException;
import com.whaleal.icefrog.log.StaticLog;

public class ExpressionFactory {
    public static ExpressionEngine get() {
        return Singleton.get(ExpressionEngine.class.getName(), ExpressionFactory::create);
    }

    public static ExpressionEngine create() {
        ExpressionEngine engine = ExpressionFactory.doCreate();
        StaticLog.debug("Use [{}] Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static ExpressionEngine doCreate() {
        ExpressionEngine engine = ServiceLoaderUtil.loadFirstAvailable(ExpressionEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new ExpressionException("No expression jar found ! Please add one of it to your project !");
    }
}

