/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.setting;

import com.whaleal.icefrog.core.io.file.FileNameUtil;
import com.whaleal.icefrog.core.io.resource.NoResourceException;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.setting.Setting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SettingUtil {
    private static final Map<String, Setting> SETTING_MAP = new ConcurrentHashMap<String, Setting>();

    public static Setting get(String name) {
        return SETTING_MAP.computeIfAbsent(name, filePath -> {
            String extName = FileNameUtil.extName(filePath);
            if (StrUtil.isEmpty(extName)) {
                filePath = filePath + "." + "setting";
            }
            return new Setting((String)filePath, true);
        });
    }

    public static Setting getFirstFound(String ... names) {
        for (String name : names) {
            try {
                return SettingUtil.get(name);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        return null;
    }
}

