/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.net;

import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.net.DefaultTrustManager;
import com.whaleal.icefrog.core.net.SSLProtocols;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLContextBuilder
implements SSLProtocols {
    private String protocol = "TLS";
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers = new TrustManager[]{DefaultTrustManager.INSTANCE};
    private SecureRandom secureRandom = new SecureRandom();

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder setProtocol(String protocol) {
        if (StrUtil.isNotBlank(protocol)) {
            this.protocol = protocol;
        }
        return this;
    }

    public SSLContextBuilder setTrustManagers(TrustManager ... trustManagers) {
        if (ArrayUtil.isNotEmpty(trustManagers)) {
            this.trustManagers = trustManagers;
        }
        return this;
    }

    public SSLContextBuilder setKeyManagers(KeyManager ... keyManagers) {
        if (ArrayUtil.isNotEmpty(keyManagers)) {
            this.keyManagers = keyManagers;
        }
        return this;
    }

    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        if (null != secureRandom) {
            this.secureRandom = secureRandom;
        }
        return this;
    }

    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance(this.protocol);
        sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        return sslContext;
    }

    public SSLContext buildQuietly() throws IORuntimeException {
        try {
            return this.build();
        }
        catch (GeneralSecurityException e) {
            throw new IORuntimeException(e);
        }
    }
}

