/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db;

import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.DbUtil;
import com.whaleal.icefrog.db.Entity;
import com.whaleal.icefrog.db.GlobalDbConfig;
import com.whaleal.icefrog.db.Page;
import com.whaleal.icefrog.db.StatementUtil;
import com.whaleal.icefrog.db.dialect.Dialect;
import com.whaleal.icefrog.db.dialect.DialectFactory;
import com.whaleal.icefrog.db.handler.NumberHandler;
import com.whaleal.icefrog.db.handler.RsHandler;
import com.whaleal.icefrog.db.sql.Query;
import com.whaleal.icefrog.db.sql.SqlBuilder;
import com.whaleal.icefrog.db.sql.SqlExecutor;
import com.whaleal.icefrog.db.sql.SqlUtil;
import com.whaleal.icefrog.db.sql.Wrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DialectRunner
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean caseInsensitive = GlobalDbConfig.caseInsensitive;
    private Dialect dialect;

    public DialectRunner(Dialect dialect) {
        this.dialect = dialect;
    }

    public DialectRunner(String driverClassName) {
        this(DialectFactory.newDialect(driverClassName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] insert(Connection conn, Entity ... records) throws SQLException {
        PreparedStatement ps;
        block4: {
            int[] nArray;
            this.checkConn(conn);
            if (ArrayUtil.isEmpty(records)) {
                return new int[]{0};
            }
            ps = null;
            try {
                if (1 != records.length) break block4;
                ps = this.dialect.psForInsert(conn, records[0]);
                nArray = new int[]{ps.executeUpdate()};
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
            return nArray;
        }
        ps = this.dialect.psForInsertBatch(conn, records);
        int[] nArray = ps.executeBatch();
        DbUtil.close(ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T insert(Connection conn, Entity record, RsHandler<T> generatedKeysHandler) throws SQLException {
        PreparedStatement ps;
        block4: {
            T t;
            this.checkConn(conn);
            if (MapUtil.isEmpty(record)) {
                throw new SQLException("Empty entity provided!");
            }
            ps = null;
            try {
                ps = this.dialect.psForInsert(conn, record);
                ps.executeUpdate();
                if (null != generatedKeysHandler) break block4;
                t = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
            return t;
        }
        T t = StatementUtil.getGeneratedKeys(ps, generatedKeysHandler);
        DbUtil.close(ps);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int del(Connection conn, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (MapUtil.isEmpty(where)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForDelete(conn, Query.of(where));
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection conn, Entity record, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (MapUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        if (MapUtil.isEmpty(where)) {
            throw new SQLException("Empty where provided!");
        }
        String tableName = record.getTableName();
        if (StrUtil.isBlank(tableName)) {
            tableName = where.getTableName();
            record.setTableName(tableName);
        }
        Query query = new Query(SqlUtil.buildConditions(where), tableName);
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdate(conn, record, query);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T find(Connection conn, Query query, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        Precondition.notNull(query, "[query] is null !", new Object[0]);
        return SqlExecutor.queryAndClosePs(this.dialect.psForFind(conn, query), rsh, new Object[0]);
    }

    public long count(Connection conn, Entity where) throws SQLException {
        this.checkConn(conn);
        return SqlExecutor.queryAndClosePs(this.dialect.psForCount(conn, Query.of(where)), new NumberHandler(), new Object[0]).longValue();
    }

    public long count(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        this.checkConn(conn);
        String selectSql = sqlBuilder.build();
        int orderByIndex = StrUtil.indexOfIgnoreCase(selectSql, " order by");
        if (orderByIndex > 0) {
            selectSql = StrUtil.subPre(selectSql, orderByIndex);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForCount(conn, SqlBuilder.of(selectSql).addParams(sqlBuilder.getParamValueArray())), new NumberHandler(), new Object[0]).longValue();
    }

    public <T> T page(Connection conn, Query query, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == query.getPage()) {
            return this.find(conn, query, rsh);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, query), rsh, new Object[0]);
    }

    public <T> T page(Connection conn, SqlBuilder sqlBuilder, Page page, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            return SqlExecutor.query(conn, sqlBuilder, rsh);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, sqlBuilder, page), rsh, new Object[0]);
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setWrapper(Character wrapperChar) {
        this.setWrapper(new Wrapper(wrapperChar));
    }

    public void setWrapper(Wrapper wrapper) {
        this.dialect.setWrapper(wrapper);
    }

    private void checkConn(Connection conn) {
        Precondition.notNull(conn, "Connection object must be not null!", new Object[0]);
    }
}

