/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.io.copy;

import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.StreamProgress;
import com.whaleal.icefrog.core.io.copy.IoCopier;
import com.whaleal.icefrog.core.lang.Precondition;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamCopier
extends IoCopier<InputStream, OutputStream> {
    public StreamCopier() {
        this(8192);
    }

    public StreamCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public StreamCopier(int bufferSize, long count) {
        this(bufferSize, count, null);
    }

    public StreamCopier(int bufferSize, long count, StreamProgress progress) {
        super(bufferSize, count, progress);
    }

    @Override
    public long copy(InputStream source, OutputStream target) {
        long size;
        Precondition.notNull(source, "InputStream must be not null!", new Object[0]);
        Precondition.notNull(target, "OutputStream must be not null!", new Object[0]);
        StreamProgress progress = this.progress;
        if (null != progress) {
            progress.start();
        }
        try {
            size = this.doCopy(source, target, new byte[this.bufferSize(this.count)], progress);
            target.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != progress) {
            progress.finish();
        }
        return size;
    }

    private long doCopy(InputStream source, OutputStream target, byte[] buffer, StreamProgress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer, 0, this.bufferSize(numToRead))) >= 0) {
            target.write(buffer, 0, read);
            numToRead -= (long)read;
            total += (long)read;
            if (null == progress) continue;
            progress.progress(total);
        }
        return total;
    }
}

