/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.http.useragent;

import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.http.useragent.Browser;
import com.whaleal.icefrog.http.useragent.Engine;
import com.whaleal.icefrog.http.useragent.OS;
import com.whaleal.icefrog.http.useragent.Platform;
import com.whaleal.icefrog.http.useragent.UserAgent;

public class UserAgentParser {
    public static UserAgent parse(String userAgentString) {
        if (StrUtil.isBlank(userAgentString)) {
            return null;
        }
        UserAgent userAgent = new UserAgent();
        Browser browser = UserAgentParser.parseBrowser(userAgentString);
        userAgent.setBrowser(browser);
        userAgent.setVersion(browser.getVersion(userAgentString));
        Engine engine = UserAgentParser.parseEngine(userAgentString);
        userAgent.setEngine(engine);
        userAgent.setEngineVersion(engine.getVersion(userAgentString));
        OS os = UserAgentParser.parseOS(userAgentString);
        userAgent.setOs(os);
        userAgent.setOsVersion(os.getVersion(userAgentString));
        Platform platform = UserAgentParser.parsePlatform(userAgentString);
        userAgent.setPlatform(platform);
        userAgent.setMobile(platform.isMobile() || browser.isMobile());
        return userAgent;
    }

    private static Browser parseBrowser(String userAgentString) {
        for (Browser browser : Browser.browers) {
            if (!browser.isMatch(userAgentString)) continue;
            return browser;
        }
        return Browser.Unknown;
    }

    private static Engine parseEngine(String userAgentString) {
        for (Engine engine : Engine.engines) {
            if (!engine.isMatch(userAgentString)) continue;
            return engine;
        }
        return Engine.Unknown;
    }

    private static OS parseOS(String userAgentString) {
        for (OS os : OS.oses) {
            if (!os.isMatch(userAgentString)) continue;
            return os;
        }
        return OS.Unknown;
    }

    private static Platform parsePlatform(String userAgentString) {
        for (Platform platform : Platform.platforms) {
            if (!platform.isMatch(userAgentString)) continue;
            return platform;
        }
        return Platform.Unknown;
    }
}

