/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.poi.excel;

import com.whaleal.icefrog.poi.excel.style.StyleUtil;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class StyleSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Workbook workbook;
    protected CellStyle headCellStyle;
    protected CellStyle cellStyle;
    protected CellStyle cellStyleForNumber;
    protected CellStyle cellStyleForDate;

    public StyleSet(Workbook workbook) {
        this.workbook = workbook;
        this.headCellStyle = StyleUtil.createHeadCellStyle(workbook);
        this.cellStyle = StyleUtil.createDefaultCellStyle(workbook);
        this.cellStyleForDate = StyleUtil.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForDate.setDataFormat((short)22);
        this.cellStyleForNumber = StyleUtil.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForNumber.setDataFormat((short)2);
    }

    public CellStyle getHeadCellStyle() {
        return this.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public CellStyle getCellStyleForNumber() {
        return this.cellStyleForNumber;
    }

    public CellStyle getCellStyleForDate() {
        return this.cellStyleForDate;
    }

    public StyleSet setBorder(BorderStyle borderSize, IndexedColors colorIndex) {
        StyleUtil.setBorder(this.headCellStyle, borderSize, colorIndex);
        StyleUtil.setBorder(this.cellStyle, borderSize, colorIndex);
        StyleUtil.setBorder(this.cellStyleForNumber, borderSize, colorIndex);
        StyleUtil.setBorder(this.cellStyleForDate, borderSize, colorIndex);
        return this;
    }

    public StyleSet setAlign(HorizontalAlignment halign, VerticalAlignment valign) {
        StyleUtil.setAlign(this.headCellStyle, halign, valign);
        StyleUtil.setAlign(this.cellStyle, halign, valign);
        StyleUtil.setAlign(this.cellStyleForNumber, halign, valign);
        StyleUtil.setAlign(this.cellStyleForDate, halign, valign);
        return this;
    }

    public StyleSet setBackgroundColor(IndexedColors backgroundColor, boolean withHeadCell) {
        if (withHeadCell) {
            StyleUtil.setColor(this.headCellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        }
        StyleUtil.setColor(this.cellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleUtil.setColor(this.cellStyleForNumber, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleUtil.setColor(this.cellStyleForDate, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        return this;
    }

    public StyleSet setFont(short color, short fontSize, String fontName, boolean ignoreHead) {
        Font font = StyleUtil.createFont(this.workbook, color, fontSize, fontName);
        return this.setFont(font, ignoreHead);
    }

    public StyleSet setFont(Font font, boolean ignoreHead) {
        if (!ignoreHead) {
            this.headCellStyle.setFont(font);
        }
        this.cellStyle.setFont(font);
        this.cellStyleForNumber.setFont(font);
        this.cellStyleForDate.setFont(font);
        return this;
    }

    public StyleSet setWrapText() {
        this.cellStyle.setWrapText(true);
        this.cellStyleForNumber.setWrapText(true);
        this.cellStyleForDate.setWrapText(true);
        return this;
    }
}

