/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.stream;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.lang.Pair;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.stream.CollectorUtil;
import com.whaleal.icefrog.core.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtil {
    @SafeVarargs
    public static <T> Stream<T> of(T ... array) {
        Precondition.notNull(array, "Array must be not null!", new Object[0]);
        return Stream.of(array);
    }

    public static <T> Stream<T> of(Collection<T> collection) {
        return collection.stream();
    }

    public static <T> Stream<T> of(Iterable<T> iterable) {
        return StreamUtil.of(iterable, false);
    }

    public static <T> Stream<T> of(Iterable<T> iterable, boolean parallel) {
        Precondition.notNull(iterable, "Iterable must be not null!", new Object[0]);
        return StreamSupport.stream(Spliterators.spliterator(CollUtil.toCollection(iterable), 0), parallel);
    }

    public static Stream<String> of(File file) {
        return StreamUtil.of(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static Stream<String> of(Path path) {
        return StreamUtil.of(path, CharsetUtil.CHARSET_UTF_8);
    }

    public static Stream<String> of(File file, Charset charset) {
        Precondition.notNull(file, "File must be not null!", new Object[0]);
        return StreamUtil.of(file.toPath(), charset);
    }

    public static Stream<String> of(Path path, Charset charset) {
        try {
            return Files.lines(path, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static <T> Stream<T> of(T seed, UnaryOperator<T> elementCreator, int limit) {
        return Stream.iterate(seed, elementCreator).limit(limit);
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter) {
        return stream.collect(CollectorUtil.joining(delimiter));
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        return stream.collect(CollectorUtil.joining(delimiter, toStringFunc));
    }

    public static <T> Stream<T> of(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    public static <A, B, R> Stream<R> zip(Stream<A> streamA, Stream<B> streamB, final BiFunction<? super A, ? super B, R> function) {
        Precondition.checkNotNull(streamA);
        Precondition.checkNotNull(streamB);
        Precondition.checkNotNull(function);
        boolean isParallel = streamA.isParallel() || streamB.isParallel();
        Spliterator splitrA = streamA.spliterator();
        Spliterator splitrB = streamB.spliterator();
        int characteristics = splitrA.characteristics() & splitrB.characteristics() & 0x50;
        final Iterator itrA = Spliterators.iterator(splitrA);
        final Iterator itrB = Spliterators.iterator(splitrB);
        return (Stream)((Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(Math.min(splitrA.estimateSize(), splitrB.estimateSize()), characteristics){

            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                if (itrA.hasNext() && itrB.hasNext()) {
                    action.accept(function.apply(itrA.next(), itrB.next()));
                    return true;
                }
                return false;
            }
        }, isParallel).onClose(streamA::close)).onClose(streamB::close);
    }

    public static <A, B> void forEachPair(Stream<A> streamA, Stream<B> streamB, BiConsumer<? super A, ? super B> consumer) {
        Precondition.checkNotNull(consumer);
        if (streamA.isParallel() || streamB.isParallel()) {
            StreamUtil.zip(streamA, streamB, Pair::new).forEach(pair -> consumer.accept(pair.left(), pair.right()));
        } else {
            Iterator iterA = streamA.iterator();
            Iterator iterB = streamB.iterator();
            while (iterA.hasNext() && iterB.hasNext()) {
                consumer.accept(iterA.next(), iterB.next());
            }
        }
    }
}

