/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.lang.ParameterizedTypeImpl;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.lang.reflect.ActualTypeMapperPool;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.ClassUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;

public class TypeUtil {
    public static Class<?> getClass(Type type) {
        if (null != type) {
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                return (Class)((TypeVariable)type).getBounds()[0];
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return TypeUtil.getClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        return field.getGenericType();
    }

    public static Type getFieldType(Class<?> clazz, String fieldName) {
        return TypeUtil.getType(ReflectUtil.getField(clazz, fieldName));
    }

    public static Class<?> getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Type getFirstParamType(Method method) {
        return TypeUtil.getParamType(method, 0);
    }

    public static Class<?> getFirstParamClass(Method method) {
        return TypeUtil.getParamClass(method, 0);
    }

    public static Type getParamType(Method method, int index) {
        Type[] types = TypeUtil.getParamTypes(method);
        if (null != types && types.length > index) {
            return types[index];
        }
        return null;
    }

    public static Class<?> getParamClass(Method method, int index) {
        Class<?>[] classes = TypeUtil.getParamClasses(method);
        if (null != classes && classes.length > index) {
            return classes[index];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Type type) {
        return TypeUtil.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = TypeUtil.getTypeArguments(type);
        if (null != typeArguments && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType parameterizedType = TypeUtil.toParameterizedType(type);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && ArrayUtil.isNotEmpty(genericInterfaces = clazz.getGenericInterfaces())) {
                genericSuper = genericInterfaces[0];
            }
            result = TypeUtil.toParameterizedType(genericSuper);
        }
        return result;
    }

    public static boolean isUnknown(Type type) {
        return null == type || type instanceof TypeVariable;
    }

    public static boolean hasTypeVariable(Type ... types) {
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }

    public static Map<Type, Type> getTypeMap(Class<?> clazz) {
        return ActualTypeMapperPool.get(clazz);
    }

    public static Type getActualType(Type type, Field field) {
        if (null == field) {
            return null;
        }
        return TypeUtil.getActualType((Type)ObjectUtil.defaultIfNull(type, field.getDeclaringClass()), field.getGenericType());
    }

    public static Type getActualType(Type type, Type typeVariable) {
        if (typeVariable instanceof ParameterizedType) {
            return TypeUtil.getActualType(type, (ParameterizedType)typeVariable);
        }
        if (typeVariable instanceof TypeVariable) {
            return ActualTypeMapperPool.getActualType(type, (TypeVariable)typeVariable);
        }
        return typeVariable;
    }

    public static Type getActualType(Type type, ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (TypeUtil.hasTypeVariable(actualTypeArguments) && ArrayUtil.isNotEmpty(actualTypeArguments = TypeUtil.getActualTypes(type, parameterizedType.getActualTypeArguments()))) {
            parameterizedType = new ParameterizedTypeImpl(actualTypeArguments, parameterizedType.getOwnerType(), parameterizedType.getRawType());
        }
        return parameterizedType;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        return ActualTypeMapperPool.getActualTypes(type, typeVariables);
    }

    public static boolean isAssignable(Type lhsType, Type rhsType) {
        Precondition.notNull(lhsType, "Left-hand side type must not be null", new Object[0]);
        Precondition.notNull(rhsType, "Right-hand side type must not be null", new Object[0]);
        if (lhsType.equals(rhsType) || Object.class == lhsType) {
            return true;
        }
        if (lhsType instanceof Class) {
            Class lhsClass = (Class)lhsType;
            if (rhsType instanceof Class) {
                return ClassUtil.isAssignable(lhsClass, (Class)rhsType);
            }
            if (rhsType instanceof ParameterizedType) {
                Type rhsRaw = ((ParameterizedType)rhsType).getRawType();
                if (rhsRaw instanceof Class) {
                    return ClassUtil.isAssignable(lhsClass, (Class)rhsRaw);
                }
            } else if (lhsClass.isArray() && rhsType instanceof GenericArrayType) {
                Type rhsComponent = ((GenericArrayType)rhsType).getGenericComponentType();
                return TypeUtil.isAssignable(lhsClass.getComponentType(), rhsComponent);
            }
        }
        if (lhsType instanceof ParameterizedType) {
            if (rhsType instanceof Class) {
                Type lhsRaw = ((ParameterizedType)lhsType).getRawType();
                if (lhsRaw instanceof Class) {
                    return ClassUtil.isAssignable((Class)lhsRaw, (Class)rhsType);
                }
            } else if (rhsType instanceof ParameterizedType) {
                return TypeUtil.isAssignable((ParameterizedType)lhsType, (ParameterizedType)rhsType);
            }
        }
        if (lhsType instanceof GenericArrayType) {
            Type lhsComponent = ((GenericArrayType)lhsType).getGenericComponentType();
            if (rhsType instanceof Class) {
                Class rhsClass = (Class)rhsType;
                if (rhsClass.isArray()) {
                    return TypeUtil.isAssignable(lhsComponent, rhsClass.getComponentType());
                }
            } else if (rhsType instanceof GenericArrayType) {
                Type rhsComponent = ((GenericArrayType)rhsType).getGenericComponentType();
                return TypeUtil.isAssignable(lhsComponent, rhsComponent);
            }
        }
        if (lhsType instanceof WildcardType) {
            return TypeUtil.isAssignable((WildcardType)lhsType, rhsType);
        }
        return false;
    }

    private static boolean isAssignable(ParameterizedType lhsType, ParameterizedType rhsType) {
        Type[] rhsTypeArguments;
        if (lhsType.equals(rhsType)) {
            return true;
        }
        Type[] lhsTypeArguments = lhsType.getActualTypeArguments();
        if (lhsTypeArguments.length != (rhsTypeArguments = rhsType.getActualTypeArguments()).length) {
            return false;
        }
        int size = lhsTypeArguments.length;
        for (int i = 0; i < size; ++i) {
            Type lhsArg = lhsTypeArguments[i];
            Type rhsArg = rhsTypeArguments[i];
            if (lhsArg.equals(rhsArg) || lhsArg instanceof WildcardType && TypeUtil.isAssignable((WildcardType)lhsArg, rhsArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType lhsType, Type rhsType) {
        Type[] lLowerBounds;
        Type[] lUpperBounds = lhsType.getUpperBounds();
        if (lUpperBounds.length == 0) {
            lUpperBounds = new Type[]{Object.class};
        }
        if ((lLowerBounds = lhsType.getLowerBounds()).length == 0) {
            lLowerBounds = new Type[]{null};
        }
        if (rhsType instanceof WildcardType) {
            Type[] rLowerBounds;
            WildcardType rhsWcType = (WildcardType)rhsType;
            Type[] rUpperBounds = rhsWcType.getUpperBounds();
            if (rUpperBounds.length == 0) {
                rUpperBounds = new Type[]{Object.class};
            }
            if ((rLowerBounds = rhsWcType.getLowerBounds()).length == 0) {
                rLowerBounds = new Type[]{null};
            }
            for (Type lBound : lUpperBounds) {
                for (Type rBound : rUpperBounds) {
                    if (TypeUtil.isAssignableBound(lBound, rBound)) continue;
                    return false;
                }
                for (Type rBound : rLowerBounds) {
                    if (TypeUtil.isAssignableBound(lBound, rBound)) continue;
                    return false;
                }
            }
            for (Type lBound : lLowerBounds) {
                for (Type rBound : rUpperBounds) {
                    if (TypeUtil.isAssignableBound(rBound, lBound)) continue;
                    return false;
                }
                for (Type rBound : rLowerBounds) {
                    if (TypeUtil.isAssignableBound(rBound, lBound)) continue;
                    return false;
                }
            }
        } else {
            for (Type lBound : lUpperBounds) {
                if (TypeUtil.isAssignableBound(lBound, rhsType)) continue;
                return false;
            }
            for (Type lBound : lLowerBounds) {
                if (TypeUtil.isAssignableBound(rhsType, lBound)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAssignableBound(Type lhsType, Type rhsType) {
        if (rhsType == null) {
            return true;
        }
        if (lhsType == null) {
            return false;
        }
        return TypeUtil.isAssignable(lhsType, rhsType);
    }
}

