/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.crypto.asymmetric;

import com.whaleal.icefrog.core.codec.BCD;
import com.whaleal.icefrog.core.codec.Base64;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.HexUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface AsymmetricEncryptor {
    public byte[] encrypt(byte[] var1, KeyType var2);

    default public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    default public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    default public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset), keyType);
    }

    default public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset), keyType);
    }

    default public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StrUtil.utf8Bytes(data), keyType);
    }

    default public String encryptHex(String data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    default public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, charset, keyType));
    }

    default public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    default public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode(this.encrypt(data, charset, keyType));
    }

    default public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes(data), keyType);
    }

    default public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    default public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    default public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public String encryptBcd(String data, KeyType keyType, Charset charset) {
        return BCD.bcdToStr(this.encrypt(data, charset, keyType));
    }
}

