/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.ds.dbcp;

import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.ds.AbstractDSFactory;
import com.whaleal.icefrog.setting.Setting;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

public class DbcpDSFactory
extends AbstractDSFactory {
    public static final String DS_NAME = "icefrogs-dbcp2";
    private static final long serialVersionUID = -9133501414334104548L;

    public DbcpDSFactory() {
        this((Setting)null);
    }

    public DbcpDSFactory(Setting setting) {
        super(DS_NAME, BasicDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(jdbcUrl);
        ds.setDriverClassName(driver);
        ds.setUsername(user);
        ds.setPassword(pass);
        for (String key : KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemoveStr(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            ds.addConnectionProperty(key, connValue);
        }
        poolSetting.toBean(ds);
        return ds;
    }
}

