/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.template.engine;

import com.whaleal.icefrog.core.lang.Singleton;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.ServiceLoaderUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.extra.template.TemplateConfig;
import com.whaleal.icefrog.extra.template.TemplateEngine;
import com.whaleal.icefrog.extra.template.TemplateException;
import com.whaleal.icefrog.log.StaticLog;

public class TemplateFactory {
    public static TemplateEngine get() {
        return Singleton.get(TemplateEngine.class.getName(), TemplateFactory::create);
    }

    public static TemplateEngine create() {
        return TemplateFactory.create(new TemplateConfig());
    }

    public static TemplateEngine create(TemplateConfig config) {
        TemplateEngine engine = TemplateFactory.doCreate(config);
        StaticLog.debug("Use [{}] Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static TemplateEngine doCreate(TemplateConfig config) {
        Class<? extends TemplateEngine> customEngineClass = config.getCustomEngine();
        TemplateEngine engine = null != customEngineClass ? ReflectUtil.newInstance(customEngineClass, new Object[0]) : ServiceLoaderUtil.loadFirstAvailable(TemplateEngine.class);
        if (null != engine) {
            return engine.init(config);
        }
        throw new TemplateException("No template found ! Please add one of template jar to your project !");
    }
}

