/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.collection;

import com.whaleal.icefrog.core.collection.TransListIter;
import com.whaleal.icefrog.core.lang.Precondition;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransSequentialList<F, T>
extends AbstractSequentialList<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    final List<F> fromList;
    final Function<? super F, ? extends T> function;

    TransSequentialList(List<F> fromList, Function<? super F, ? extends T> function) {
        this.fromList = Precondition.checkNotNull(fromList);
        this.function = Precondition.checkNotNull(function);
    }

    @Override
    public void clear() {
        this.fromList.clear();
    }

    @Override
    public int size() {
        return this.fromList.size();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new TransListIter<F, T>(this.fromList.listIterator(index), this.function);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        Precondition.checkNotNull(filter);
        return this.fromList.removeIf((? super E element) -> filter.test((T)this.function.apply(element)));
    }
}

