/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang;

import com.whaleal.icefrog.core.util.StrUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ByteString {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteString EMPTY = new ByteString(EMPTY_BYTE_ARRAY);
    private final byte[] bytes;
    private volatile int hash = 0;

    private ByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    static ByteString wrap(byte[] bytes) {
        return new ByteString(bytes);
    }

    public static void writeTo(OutputStream out, ByteString bs) throws IOException {
        out.write(bs.bytes);
    }

    public static void writeTo(DataOutput out, ByteString bs) throws IOException {
        out.write(bs.bytes);
    }

    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        byte[] copy = new byte[size];
        System.arraycopy(bytes, offset, copy, 0, size);
        return new ByteString(copy);
    }

    public static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, bytes.length);
    }

    public static ByteString copyFrom(String text, String charsetName) {
        try {
            return new ByteString(text.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(charsetName + " not supported?", e);
        }
    }

    public static ByteString copyFromUtf8(String text) {
        byte[] bytes = StrUtil.bytes((CharSequence)text, Charset.forName("UTF-8"));
        return new ByteString(bytes);
    }

    public static boolean equals(ByteString bs, ByteString other, boolean checkHash) {
        int size = bs.bytes.length;
        if (size != other.bytes.length) {
            return false;
        }
        if (checkHash) {
            int h1 = bs.hash;
            int h2 = other.hash;
            if (h1 != 0 && h2 != 0 && h1 != h2) {
                return false;
            }
        }
        byte[] thisBytes = bs.bytes;
        byte[] otherBytes = other.bytes;
        for (int i = 0; i < size; ++i) {
            if (thisBytes[i] == otherBytes[i]) continue;
            return false;
        }
        return true;
    }

    public static ByteString bytesDefaultValue(String bytes) {
        return new ByteString(ByteString.byteArrayDefaultValue(bytes));
    }

    public static byte[] byteArrayDefaultValue(String bytes) {
        try {
            return bytes.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support a standard character set.", e);
        }
    }

    byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    public byte byteAt(int index) {
        return this.bytes[index];
    }

    public int size() {
        return this.bytes.length;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public void copyTo(byte[] target, int offset) {
        System.arraycopy(this.bytes, 0, target, offset, this.bytes.length);
    }

    public void copyTo(byte[] target, int sourceOffset, int targetOffset, int size) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, size);
    }

    public byte[] toByteArray() {
        int size = this.bytes.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.bytes, 0, copy, 0, size);
        return copy;
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
        return byteBuffer.asReadOnlyBuffer();
    }

    public String toStringUtf8() {
        return StrUtil.utf8Str(this.bytes);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ByteString && ByteString.equals(this, (ByteString)o, false);
    }

    public boolean equals(byte[] data) {
        return this.equals(data, 0, data.length);
    }

    public boolean equals(byte[] data, int offset, int len) {
        byte[] bytes = this.bytes;
        if (len != bytes.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (bytes[i++] == data[offset++]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int size;
            byte[] thisBytes = this.bytes;
            h = size = this.bytes.length;
            for (int i = 0; i < size; ++i) {
                h = h * 31 + thisBytes[i];
            }
            if (h == 0) {
                h = 1;
            }
            this.hash = h;
        }
        return h;
    }
}

