/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.map;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.IterUtil;
import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.lang.Editor;
import com.whaleal.icefrog.core.lang.Pair;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.lang.Predicate;
import com.whaleal.icefrog.core.lang.TypeReference;
import com.whaleal.icefrog.core.map.CamelCaseLinkedMap;
import com.whaleal.icefrog.core.map.CamelCaseMap;
import com.whaleal.icefrog.core.map.EntryFunction;
import com.whaleal.icefrog.core.map.MapBuilder;
import com.whaleal.icefrog.core.map.MapProxy;
import com.whaleal.icefrog.core.map.MapWrapper;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.PredicateUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.CheckForNull;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static <K, V> Map<K, V> emptyIfNull(Map<K, V> set) {
        return null == set ? Collections.emptyMap() : set;
    }

    public static <T extends Map<K, V>, K, V> T defaultIfEmpty(T map, T defaultMap) {
        return MapUtil.isEmpty(map) ? defaultMap : map;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isOrder ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isOrder) {
        return MapUtil.newHashMap(16, isOrder);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int expectedSize) {
        return new LinkedHashMap((int)((float)expectedSize / 0.75f), 0.75f);
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (!MapUtil.isEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Class<K> type) {
        return new EnumMap(Precondition.checkNotNull(type));
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Map<K, ? extends V> map) {
        return new EnumMap<K, V>(map);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityMap() {
        return new IdentityHashMap();
    }

    public static <K, V> Map<K, V> newIdentityMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap(16);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int size) {
        int initCapacity = size <= 0 ? 16 : size;
        return new ConcurrentHashMap(initCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> map) {
        if (MapUtil.isEmpty(map)) {
            return new ConcurrentHashMap(16);
        }
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        return (Map)ReflectUtil.newInstance(mapType, new Object[0]);
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return MapUtil.of(key, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        HashMap<K, V> map = MapUtil.newHashMap(isOrder);
        map.put(key, value);
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> of(Pair<K, V> ... pairs) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.left(), pair.right());
        }
        return map;
    }

    public static HashMap<Object, Object> of(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object value;
            Object key;
            Iterator iter;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            if (object instanceof Iterator) {
                iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(StrUtil.format("Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, object));
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        HashMap<K, ArrayList<Object>> resultMap = new HashMap<K, ArrayList<Object>>();
        if (CollUtil.isEmpty(mapList)) {
            return resultMap;
        }
        for (Map<K, V> map : mapList) {
            Set<Map.Entry<K, V>> entrySet = map.entrySet();
            for (Map.Entry<K, V> entry : entrySet) {
                K key = entry.getKey();
                ArrayList<Object> valueList = (ArrayList<Object>)resultMap.get(key);
                if (null == valueList) {
                    valueList = CollUtil.newArrayList(entry.getValue());
                    resultMap.put(key, valueList);
                    continue;
                }
                valueList.add(entry.getValue());
            }
        }
        return resultMap;
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        boolean isEnd;
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        if (MapUtil.isEmpty(listMap)) {
            return resultList;
        }
        int index = 0;
        do {
            isEnd = true;
            HashMap map = new HashMap();
            for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
                ArrayList<V> vList = CollUtil.newArrayList(entry.getValue());
                int vListSize = vList.size();
                if (index >= vListSize) continue;
                map.put(entry.getKey(), vList.get(index));
                if (index == vListSize - 1) continue;
                isEnd = false;
            }
            if (!map.isEmpty()) {
                resultList.add(map);
            }
            ++index;
        } while (!isEnd);
        return resultList;
    }

    public static <K, V> Map<K, V> toCamelCaseMap(Map<K, V> map) {
        return map instanceof LinkedHashMap ? new CamelCaseLinkedMap<K, V>(map) : new CamelCaseMap<K, V>(map);
    }

    public static Object[][] toObjectArray(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Object[][] result = new Object[map.size()][2];
        if (map.isEmpty()) {
            return result;
        }
        int index = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result[index][0] = entry.getKey();
            result[index][1] = entry.getValue();
            ++index;
        }
        return result;
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        return MapUtil.join(map, separator, keyValueSeparator, false, otherParams);
    }

    public static String sortJoin(Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return MapUtil.join(MapUtil.sort(params), separator, keyValueSeparator, isIgnoreNull, otherParams);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        return MapUtil.join(map, separator, keyValueSeparator, true, otherParams);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        StringBuilder strBuilder = StrUtil.builder();
        boolean isFirst = true;
        if (MapUtil.isNotEmpty(map)) {
            for (Map.Entry entry : map.entrySet()) {
                if (isIgnoreNull && (entry.getKey() == null || entry.getValue() == null)) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    strBuilder.append(separator);
                }
                strBuilder.append(Convert.toStr(entry.getKey())).append(keyValueSeparator).append(Convert.toStr(entry.getValue()));
            }
        }
        if (ArrayUtil.isNotEmpty(otherParams)) {
            for (String otherParam : otherParams) {
                strBuilder.append(otherParam);
            }
        }
        return strBuilder.toString();
    }

    public static <K, V> Map<K, V> edit(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        if (null == map || null == editor) {
            return map;
        }
        Map<K, V> map2 = ObjectUtil.clone(map);
        if (null == map2) {
            map2 = new HashMap(map.size(), 1.0f);
        }
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        try {
            map2.clear();
        }
        catch (UnsupportedOperationException e) {
            map2 = new HashMap(map.size(), 1.0f);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry<K, V> modified = editor.edit(entry);
            if (null == modified) continue;
            map2.put(modified.getKey(), modified.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        if (null == map || null == predicate) {
            return map;
        }
        return MapUtil.edit(map, t -> predicate.apply((Map.Entry)t) ? t : null);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, K ... keys) {
        if (null == map || null == keys) {
            return map;
        }
        Map<K, V> map2 = ObjectUtil.clone(map);
        if (null == map2) {
            map2 = new HashMap(map.size(), 1.0f);
        }
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        try {
            map2.clear();
        }
        catch (UnsupportedOperationException e) {
            map2 = new HashMap();
        }
        for (K key : keys) {
            if (!map.containsKey(key)) continue;
            map2.put(key, map.get(key));
        }
        return map2;
    }

    public static <T> Map<T, T> reverse(Map<T, T> map) {
        return MapUtil.edit(map, t -> new Map.Entry<T, T>((Map.Entry)t){
            final /* synthetic */ Map.Entry val$t;
            {
                this.val$t = entry;
            }

            @Override
            public T getKey() {
                return this.val$t.getValue();
            }

            @Override
            public T getValue() {
                return this.val$t.getKey();
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException("Unsupported setValue method !");
            }
        });
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        Map result = MapUtil.createMap(map.getClass());
        map.forEach((key, value) -> result.put(value, key));
        return result;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map) {
        return MapUtil.sort(map, null);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        if (null == map) {
            return null;
        }
        if (map instanceof TreeMap) {
            TreeMap result = (TreeMap)map;
            if (null == comparator || comparator.equals(result.comparator())) {
                return result;
            }
        }
        return MapUtil.newTreeMap(map, comparator);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean isDesc) {
        LinkedHashMap result = new LinkedHashMap();
        Comparator entryComparator = Map.Entry.comparingByValue();
        if (isDesc) {
            entryComparator = entryComparator.reversed();
        }
        map.entrySet().stream().sorted(entryComparator).forEachOrdered(e -> {
            Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
        });
        return result;
    }

    public static MapProxy createProxy(Map<?, ?> map) {
        return MapProxy.create(map);
    }

    public static <K, V> MapWrapper<K, V> wrap(Map<K, V> map) {
        return new MapWrapper<K, V>(map);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapUtil.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        return MapUtil.builder(new HashMap()).put(k, v);
    }

    public static <K, V> Map<K, V> getAny(Map<K, V> map, K ... keys) {
        return MapUtil.filter(map, entry -> ArrayUtil.contains(keys, entry.getKey()));
    }

    public static <K, V> Map<K, V> removeAny(Map<K, V> map, K ... keys) {
        for (K key : keys) {
            map.remove(key);
        }
        return map;
    }

    public static String getStr(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, String.class);
    }

    public static String getStr(Map<?, ?> map, Object key, String defaultValue) {
        return MapUtil.get(map, key, String.class, defaultValue);
    }

    public static Integer getInt(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Integer.class);
    }

    public static Integer getInt(Map<?, ?> map, Object key, Integer defaultValue) {
        return MapUtil.get(map, key, Integer.class, defaultValue);
    }

    public static Double getDouble(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Double.class);
    }

    public static Double getDouble(Map<?, ?> map, Object key, Double defaultValue) {
        return MapUtil.get(map, key, Double.class, defaultValue);
    }

    public static Float getFloat(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Float.class);
    }

    public static Float getFloat(Map<?, ?> map, Object key, Float defaultValue) {
        return MapUtil.get(map, key, Float.class, defaultValue);
    }

    public static Short getShort(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Short.class);
    }

    public static Short getShort(Map<?, ?> map, Object key, Short defaultValue) {
        return MapUtil.get(map, key, Short.class, defaultValue);
    }

    public static Boolean getBool(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Boolean.class);
    }

    public static Boolean getBool(Map<?, ?> map, Object key, Boolean defaultValue) {
        return MapUtil.get(map, key, Boolean.class, defaultValue);
    }

    public static Character getChar(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Character.class);
    }

    public static Character getChar(Map<?, ?> map, Object key, Character defaultValue) {
        return MapUtil.get(map, key, Character.class, defaultValue);
    }

    public static Long getLong(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Long.class);
    }

    public static Long getLong(Map<?, ?> map, Object key, Long defaultValue) {
        return MapUtil.get(map, key, Long.class, defaultValue);
    }

    public static Date getDate(Map<?, ?> map, Object key) {
        return MapUtil.get(map, key, Date.class);
    }

    public static Date getDate(Map<?, ?> map, Object key, Date defaultValue) {
        return MapUtil.get(map, key, Date.class, defaultValue);
    }

    public static <T> T get(Map<?, ?> map, Object key, Class<T> type) {
        return MapUtil.get(map, key, type, null);
    }

    public static <T> T get(Map<?, ?> map, Object key, Class<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convert(type, map.get(key), defaultValue);
    }

    public static <T> T getQuietly(Map<?, ?> map, Object key, Class<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convertQuietly(type, map.get(key), defaultValue);
    }

    public static <T> T get(Map<?, ?> map, Object key, TypeReference<T> type) {
        return MapUtil.get(map, key, type, null);
    }

    public static <T> T get(Map<?, ?> map, Object key, TypeReference<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convert(type, map.get(key), defaultValue);
    }

    public static <T> T getQuietly(Map<?, ?> map, Object key, TypeReference<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convertQuietly(type, map.get(key), defaultValue);
    }

    public static <K, V> Map<K, V> renameKey(Map<K, V> map, K oldKey, K newKey) {
        if (MapUtil.isNotEmpty(map) && map.containsKey(oldKey)) {
            if (map.containsKey(newKey)) {
                throw new IllegalArgumentException(StrUtil.format("The key '{}' exist !", newKey));
            }
            map.put(newKey, map.remove(oldKey));
        }
        return map;
    }

    public static <K, V> Map<K, V> removeNullValue(Map<K, V> map) {
        if (MapUtil.isEmpty(map)) {
            return map;
        }
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            if (null != entry.getValue()) continue;
            iter.remove();
        }
        return map;
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V, T extends Map<K, V>> T empty(Class<?> mapClass) {
        if (null == mapClass) {
            return (T)Collections.emptyMap();
        }
        if (NavigableMap.class == mapClass) {
            return (T)Collections.emptyNavigableMap();
        }
        if (SortedMap.class == mapClass) {
            return (T)Collections.emptySortedMap();
        }
        if (Map.class == mapClass) {
            return (T)Collections.emptyMap();
        }
        throw new IllegalArgumentException(StrUtil.format("[{}] is not support to get empty!", mapClass));
    }

    public static void clear(Map<?, ?> ... maps) {
        for (Map<?, ?> map : maps) {
            if (!MapUtil.isNotEmpty(map)) continue;
            map.clear();
        }
    }

    @CheckForNull
    public static <V> V safeGet(Map<?, V> map, @CheckForNull Object key) {
        Precondition.checkNotNull(map);
        try {
            return map.get(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return null;
        }
    }

    public static boolean safeContainsKey(Map<?, ?> map, @CheckForNull Object key) {
        Precondition.checkNotNull(map);
        try {
            return map.containsKey(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    @CheckForNull
    public static <V> V safeRemove(Map<?, V> map, @CheckForNull Object key) {
        Precondition.checkNotNull(map);
        try {
            return map.remove(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return null;
        }
    }

    public static boolean containsKeyImpl(Map<?, ?> map, @CheckForNull Object key) {
        return CollUtil.contains(map.keySet().iterator(), key);
    }

    public static boolean containsValueImpl(Map<?, ?> map, @CheckForNull Object value) {
        return IterUtil.contains(map.values().iterator(), value);
    }

    public static boolean equalsImpl(Map<?, ?> map, @CheckForNull Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map o = (Map)object;
            return map.entrySet().equals(o.entrySet());
        }
        return false;
    }

    public static <K, V1, V2> SortedMap<K, V2> transformValues(Map<K, V1> fromMap, Function<? super V1, V2> function) {
        Precondition.checkNotNull(fromMap);
        Precondition.checkNotNull(function);
        TreeMap<K, V2> sortedMap = new TreeMap<K, V2>();
        for (Map.Entry<K, V1> entry : fromMap.entrySet()) {
            sortedMap.put(entry.getKey(), function.apply(entry.getValue()));
        }
        return sortedMap;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        Map.Entry entry = new Map.Entry<K, V>(){
            private K key;
            private V value;

            public Map.Entry<K, V> setKeyValue(K key, V value) {
                this.key = key;
                this.value = value;
                return this;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                this.value = value;
                return value;
            }
        }.setKeyValue(key, value);
        return entry;
    }

    public static <K, V> Iterator<K> keyIterator(Map<K, V> map) {
        return map.keySet().iterator();
    }

    public static <K, V> Iterator<V> valueIterator(Map<K, V> map) {
        return map.values().iterator();
    }

    public static <K> Function<Map.Entry<K, ?>, K> keyFunction() {
        return EntryFunction.KEY;
    }

    public static <V> Function<Map.Entry<?, V>, V> valueFunction() {
        return EntryFunction.VALUE;
    }

    public static <K> Predicate keyPredicateOnEntries(Predicate keyPredicate) {
        return PredicateUtil.compose(keyPredicate, MapUtil.keyFunction());
    }

    public static <V> Predicate valuePredicateOnEntries(Predicate valuePredicate) {
        return PredicateUtil.compose(valuePredicate, MapUtil.valueFunction());
    }

    @CheckForNull
    public static <V> V valueOrNull(@CheckForNull Map.Entry<?, V> entry) {
        return entry == null ? null : (V)entry.getValue();
    }

    @CheckForNull
    public static <K> K keyOrNull(@CheckForNull Map.Entry<K, ?> entry) {
        return entry == null ? null : (K)entry.getKey();
    }

    public static String toString(Map<?, ?> map) {
        StringBuilder sb = StrUtil.builder(map.size()).append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return sb.append('}').toString();
    }
}

