/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.map.multi;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.IterUtil;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.map.multi.AbsCollValueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ListValueMap<K, V>
extends AbsCollValueMap<K, V, List<V>> {
    private static final long serialVersionUID = 6044017508487827899L;

    public ListValueMap() {
        this(16);
    }

    public ListValueMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ListValueMap(Map<? extends K, ? extends Collection<V>> m) {
        this(0.75f, (Map<? extends K, Collection<V>>)m);
    }

    public ListValueMap(float loadFactor, Map<? extends K, ? extends Collection<V>> m) {
        this(m.size(), loadFactor);
        this.putAllValues(m);
    }

    public ListValueMap(int initialCapacity, float loadFactor) {
        super(new HashMap(initialCapacity, loadFactor));
    }

    @Override
    protected List<V> createCollection() {
        return new ArrayList(3);
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        Collection collection = (Collection)this.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean putAll(K key, Iterable<V> values) {
        Precondition.checkNotNull(values);
        Collection valueCollection = (Collection)values;
        if (valueCollection == null) {
            try {
                this.put(key, CollUtil.newArrayList(values));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (values instanceof Collection) {
            return !valueCollection.isEmpty() && ((List)this.get(key)).addAll(valueCollection);
        }
        Iterator<V> valueItr = values.iterator();
        return valueItr.hasNext() && IterUtil.addAll((Collection)this.get(key), valueItr);
    }

    @Override
    public List<V> replaceValues(K key, Iterable<V> values) {
        Iterator<V> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return (List)this.remove(key);
        }
        List coll = (List)this.get(key);
        if (null != coll) {
            coll.clear();
            IterUtil.addAll(coll, values);
            return coll;
        }
        ArrayList<V> list = CollUtil.newArrayList(values);
        this.put(key, list);
        return list;
    }
}

