/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.mail;

import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.extra.mail.MailException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

public class InternalMailUtil {
    public static InternetAddress[] parseAddressFromStrs(String[] addrStrs, Charset charset) {
        ArrayList resultList = new ArrayList(addrStrs.length);
        for (String addrStr : addrStrs) {
            InternetAddress[] addrs = InternalMailUtil.parseAddress(addrStr, charset);
            if (!ArrayUtil.isNotEmpty(addrs)) continue;
            Collections.addAll(resultList, addrs);
        }
        return resultList.toArray(new InternetAddress[0]);
    }

    public static InternetAddress parseFirstAddress(String address, Charset charset) {
        InternetAddress[] internetAddresses = InternalMailUtil.parseAddress(address, charset);
        if (ArrayUtil.isEmpty(internetAddresses)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new MailException(e);
            }
        }
        return internetAddresses[0];
    }

    public static InternetAddress[] parseAddress(String address, Charset charset) {
        InternetAddress[] addresses;
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new MailException(e);
        }
        if (ArrayUtil.isNotEmpty(addresses)) {
            for (InternetAddress internetAddress : addresses) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new MailException(e);
                }
            }
        }
        return addresses;
    }

    public static String encodeText(String text, Charset charset) {
        try {
            return MimeUtility.encodeText((String)text, (String)charset.name(), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return text;
        }
    }
}

