/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.json;

import com.whaleal.icefrog.core.bean.BeanPath;
import com.whaleal.icefrog.core.bean.BeanUtil;
import com.whaleal.icefrog.core.bean.copier.BeanCopier;
import com.whaleal.icefrog.core.bean.copier.CopyOptions;
import com.whaleal.icefrog.core.collection.CollectionUtil;
import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.lang.Filter;
import com.whaleal.icefrog.core.lang.Pair;
import com.whaleal.icefrog.core.map.CaseInsensitiveLinkedMap;
import com.whaleal.icefrog.core.map.CaseInsensitiveMap;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.json.InternalJSONUtil;
import com.whaleal.icefrog.json.JSON;
import com.whaleal.icefrog.json.JSONArray;
import com.whaleal.icefrog.json.JSONConfig;
import com.whaleal.icefrog.json.JSONConverter;
import com.whaleal.icefrog.json.JSONException;
import com.whaleal.icefrog.json.JSONGetter;
import com.whaleal.icefrog.json.JSONTokener;
import com.whaleal.icefrog.json.JSONUtil;
import com.whaleal.icefrog.json.XML;
import com.whaleal.icefrog.json.serialize.GlobalSerializeMapping;
import com.whaleal.icefrog.json.serialize.JSONObjectSerializer;
import com.whaleal.icefrog.json.serialize.JSONSerializer;
import com.whaleal.icefrog.json.serialize.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class JSONObject
implements JSON,
JSONGetter<String>,
Map<String, Object> {
    private static final long serialVersionUID = -330220388580734346L;
    public static final int DEFAULT_CAPACITY = 16;
    private final Map<String, Object> rawHashMap;
    private final JSONConfig config;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(boolean isOrder) {
        this(16, isOrder);
    }

    public JSONObject(int capacity, boolean isOrder) {
        this(capacity, false, isOrder);
    }

    public JSONObject(int capacity, boolean isIgnoreCase, boolean isOrder) {
        this(capacity, JSONConfig.create().setIgnoreCase(isIgnoreCase).setOrder(isOrder));
    }

    public JSONObject(JSONConfig config) {
        this(16, config);
    }

    public JSONObject(int capacity, JSONConfig config) {
        if (null == config) {
            config = JSONConfig.create();
        }
        this.rawHashMap = config.isIgnoreCase() ? (config.isOrder() ? new CaseInsensitiveLinkedMap(capacity) : new CaseInsensitiveMap(capacity)) : MapUtil.newHashMap(config.isOrder());
        this.config = config;
    }

    public JSONObject(Object source) {
        this(source, InternalJSONUtil.defaultIgnoreNullValue(source));
    }

    public JSONObject(Object source, boolean ignoreNullValue) {
        this(source, ignoreNullValue, InternalJSONUtil.isOrder(source));
    }

    public JSONObject(Object source, boolean ignoreNullValue, boolean isOrder) {
        this(source, JSONConfig.create().setOrder(isOrder).setIgnoreCase(source instanceof CaseInsensitiveMap).setIgnoreNullValue(ignoreNullValue));
    }

    public JSONObject(Object source, JSONConfig config) {
        this(16, config);
        this.init(source);
    }

    public JSONObject(Object obj, String ... names) {
        this();
        if (ArrayUtil.isEmpty(names)) {
            this.init(obj);
            return;
        }
        if (obj instanceof Map) {
            for (String name : names) {
                Object value = ((Map)obj).get(name);
                this.putOnce(name, value);
            }
        } else {
            for (String name : names) {
                try {
                    this.putOpt(name, ReflectUtil.getFieldValue(obj, name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public JSONObject(CharSequence source, boolean isOrder) throws JSONException {
        this((Object)source, JSONConfig.create().setOrder(isOrder));
    }

    @Override
    public JSONConfig getConfig() {
        return this.config;
    }

    public JSONObject setDateFormat(String format) {
        this.config.setDateFormat(format);
        return this;
    }

    public JSONArray toJSONArray(Collection<String> names) throws JSONException {
        if (CollectionUtil.isEmpty(names)) {
            return null;
        }
        JSONArray ja = new JSONArray(this.config);
        for (String name : names) {
            Object value = this.get(name);
            if (null == value) continue;
            ja.set(value);
        }
        return ja;
    }

    @Override
    public int size() {
        return this.rawHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rawHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rawHashMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.rawHashMap.get(key);
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        Object obj = this.rawHashMap.get(key);
        return null == obj ? defaultValue : obj;
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create(expression).get(this);
    }

    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        return JSONConverter.jsonConvert(resultType, this.getByPath(expression), true);
    }

    @Override
    public void putByPath(String expression, Object value) {
        BeanPath.create(expression).set(this, value);
    }

    @Override
    @Deprecated
    public JSONObject put(String key, Object value) throws JSONException {
        return this.set(key, value);
    }

    public JSONObject set(String key, Object value) throws JSONException {
        if (null == key) {
            return this;
        }
        boolean ignoreNullValue = this.config.isIgnoreNullValue();
        if (ObjectUtil.isNull(value) && ignoreNullValue) {
            this.remove(key);
        } else {
            InternalJSONUtil.testValidity(value);
            this.rawHashMap.put(key, JSONUtil.wrap(value, this.config));
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null) {
            if (this.rawHashMap.containsKey(key)) {
                throw new JSONException("Duplicate key \"{}\"", key);
            }
            this.set(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.set(key, value);
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).set(value);
        } else {
            this.set(key, JSONUtil.createArray(this.config).set(object).set(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, new JSONArray(this.config).set(value));
        } else if (object instanceof JSONArray) {
            this.set(key, ((JSONArray)object).set(value));
        } else {
            throw new JSONException("JSONObject [" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.getObj(key);
        if (value == null) {
            this.set(key, 1);
        } else if (value instanceof BigInteger) {
            this.set(key, ((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.set(key, ((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.set(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.set(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.set(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            this.set(key, Float.valueOf(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JSONException("Unable to increment [" + JSONUtil.quote(key) + "].");
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.rawHashMap.remove(key);
    }

    @Override
    public void clear() {
        this.rawHashMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.rawHashMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.rawHashMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.rawHashMap.entrySet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawHashMap == null ? 0 : this.rawHashMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        if (this.rawHashMap == null) {
            return other.rawHashMap == null;
        }
        return this.rawHashMap.equals(other.rawHashMap);
    }

    public String toString() {
        return this.toJSONString(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSONString(int indentFactor, Filter<Pair<String, Object>> filter) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            return this.write(sw, indentFactor, 0, filter).toString();
        }
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        return this.write(writer, indentFactor, indent, null);
    }

    public Writer write(Writer writer, int indentFactor, int indent, Filter<Pair<String, Object>> filter) throws JSONException {
        JSONWriter jsonWriter = JSONWriter.of(writer, indentFactor, indent, this.config).beginObj();
        this.forEach((key, value) -> {
            if (null == filter || filter.accept(new Pair<String, Object>((String)key, value))) {
                jsonWriter.writeField((String)key, value);
            }
        });
        jsonWriter.end();
        return writer;
    }

    private void populateMap(Object bean) {
        BeanCopier.create(bean, this, CopyOptions.create().setIgnoreCase(this.config.isIgnoreCase()).setIgnoreError(true).setIgnoreNullValue(this.config.isIgnoreNullValue())).copy();
    }

    private void init(Object source) {
        if (null == source) {
            return;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(source.getClass());
        if (serializer instanceof JSONObjectSerializer) {
            serializer.serialize(this, source);
            return;
        }
        if (ArrayUtil.isArray(source) || source instanceof JSONArray) {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
        if (source instanceof Map) {
            for (Map.Entry e : ((Map)source).entrySet()) {
                this.set(Convert.toStr(e.getKey()), e.getValue());
            }
        } else if (source instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)source;
            this.set(Convert.toStr(entry.getKey()), entry.getValue());
        } else if (source instanceof CharSequence) {
            this.init((CharSequence)source);
        } else if (source instanceof JSONTokener) {
            this.init((JSONTokener)source);
        } else if (source instanceof ResourceBundle) {
            this.init((ResourceBundle)source);
        } else if (BeanUtil.isReadableBean(source.getClass())) {
            this.populateMap(source);
        } else {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
    }

    private void init(ResourceBundle bundle) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJSONUtil.propertyPut(this, key, bundle.getString(key));
        }
    }

    private void init(CharSequence source) {
        String jsonStr = StrUtil.trim(source);
        if (StrUtil.startWith((CharSequence)jsonStr, '<')) {
            XML.toJSONObject(this, jsonStr, false);
        }
        this.init(new JSONTokener(StrUtil.trim(source), this.config));
    }

    private void init(JSONTokener x) {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }
}

