/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.poi.excel.sax.handler;

import com.whaleal.icefrog.core.bean.BeanUtil;
import com.whaleal.icefrog.core.collection.IterUtil;
import com.whaleal.icefrog.core.collection.ListUtil;
import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.poi.excel.sax.handler.AbstractRowHandler;
import java.util.List;

public abstract class BeanRowHandler<T>
extends AbstractRowHandler<T> {
    private final int headerRowIndex;
    List<String> headerList;

    public BeanRowHandler(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> clazz) {
        super(startRowIndex, endRowIndex);
        Precondition.isTrue(headerRowIndex <= startRowIndex, "Header row must before the start row!");
        this.headerRowIndex = headerRowIndex;
        this.convertFunc = rowList -> BeanUtil.toBean(IterUtil.toMap(this.headerList, rowList), clazz);
    }

    @Override
    public void handle(int sheetIndex, long rowIndex, List<Object> rowList) {
        if (rowIndex == (long)this.headerRowIndex) {
            this.headerList = ListUtil.unmodifiable(Convert.toList(String.class, rowList));
            return;
        }
        super.handle(sheetIndex, rowIndex, rowList);
    }
}

