/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.core;

import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import com.wordnik.swagger.core.ApiPropertiesReader$;
import com.wordnik.swagger.core.ApiSpecParserTrait;
import com.wordnik.swagger.core.ApiSpecParserTrait$;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationParameter;
import com.wordnik.swagger.core.SwaggerContext$;
import com.wordnik.swagger.core.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public abstract class ApiSpecParserTrait$class {
    public static Documentation parse(ApiSpecParserTrait $this) {
        if ($this.apiEndpoint() != null) {
            Predef$.MODULE$.refArrayOps((Object[])$this.hostClass().getMethods()).foreach((Function1)new ApiSpecParserTrait$.anonfun.parse.1($this));
        }
        $this.documentation().apiVersion_$eq($this.apiVersion());
        $this.documentation().swaggerVersion_$eq($this.swaggerVersion());
        $this.documentation().basePath_$eq($this.basePath());
        $this.documentation().resourcePath_$eq($this.resourcePath());
        return $this.documentation();
    }

    public static void parseApiParam(ApiSpecParserTrait $this, DocumentationParameter docParam, ApiParam apiParam, Method method) {
        docParam.name_$eq($this.readString(apiParam.name(), docParam.name(), $this.readString$default$3()));
        docParam.description_$eq($this.readString(apiParam.value(), $this.readString$default$2(), $this.readString$default$3()));
        docParam.defaultValue_$eq($this.readString(apiParam.defaultValue(), $this.readString$default$2(), $this.readString$default$3()));
        try {
            docParam.allowableValues_$eq($this.convertToAllowableValues(apiParam.allowableValues(), $this.convertToAllowableValues$default$2()));
        }
        catch (RuntimeException runtimeException) {
            $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().error(new StringBuilder().append((Object)"Allowable values annotation is wrong in method  ").append((Object)method).append((Object)"for parameter ").append((Object)docParam.name()).toString());
            runtimeException.printStackTrace();
        }
        docParam.required_$eq(apiParam.required());
        docParam.allowMultiple_$eq(apiParam.allowMultiple());
        docParam.paramAccess_$eq($this.readString(apiParam.access(), $this.readString$default$2(), $this.readString$default$3()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object parseMethod(ApiSpecParserTrait $this, Method method$1) {
        BoxedUnit boxedUnit;
        Deprecated isDeprecated;
        ApiErrors apiErrors;
        ApiOperation apiOperation;
        block8: {
            block7: {
                apiOperation = method$1.getAnnotation(ApiOperation.class);
                apiErrors = method$1.getAnnotation(ApiErrors.class);
                isDeprecated = method$1.getAnnotation(Deprecated.class);
                $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"parsing method ").append((Object)method$1.getName()).toString());
                if (apiOperation == null) break block7;
                String string = method$1.getName();
                String string2 = "getHelp";
                if (string != null ? !string.equals(string2) : string2 != null) break block8;
            }
            $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"skipping method ").append((Object)method$1.getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }
        DocumentationOperation docOperation$1 = new DocumentationOperation();
        if (isDeprecated != null) {
            docOperation$1.deprecated_$eq(Predef$.MODULE$.boolean2Boolean(true));
        }
        if (apiOperation != null) {
            docOperation$1.httpMethod_$eq($this.parseHttpMethod(method$1, apiOperation));
            docOperation$1.summary_$eq($this.readString(apiOperation.value(), $this.readString$default$2(), $this.readString$default$3()));
            docOperation$1.notes_$eq($this.readString(apiOperation.notes(), $this.readString$default$2(), $this.readString$default$3()));
            docOperation$1.setTags(JavaConversions$.MODULE$.asJavaList($this.toObjectList(apiOperation.tags(), $this.toObjectList$default$2())));
            docOperation$1.nickname_$eq(method$1.getName());
            String apiResponseValue = $this.readString(apiOperation.responseClass(), $this.readString$default$2(), $this.readString$default$3());
            boolean isResponseMultiValue = apiOperation.multiValueResponse();
            docOperation$1.setResponseTypeInternal(apiResponseValue);
            try {
                Class<?> cls = SwaggerContext$.MODULE$.loadClass(apiResponseValue);
                String annotatedName = ApiPropertiesReader$.MODULE$.readName(cls);
                docOperation$1.responseClass_$eq(isResponseMultiValue ? new StringBuilder().append((Object)"List[").append((Object)annotatedName).append((Object)"]").toString() : annotatedName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                docOperation$1.responseClass_$eq(apiResponseValue);
            }
        }
        Annotation[] methodAnnotations = method$1.getAnnotations();
        Predef$.MODULE$.refArrayOps((Object[])methodAnnotations).foreach((Function1)new ApiSpecParserTrait$.anonfun.parseMethod.1($this, method$1, docOperation$1));
        Annotation[][] paramAnnotationDoubleArray = method$1.getParameterAnnotations();
        Class[] paramTypes$1 = method$1.getParameterTypes();
        Type[] genericParamTypes$1 = method$1.getGenericParameterTypes();
        IntRef counter$1 = new IntRef(0);
        BooleanRef ignoreParam$1 = new BooleanRef(false);
        Predef$.MODULE$.refArrayOps((Object[])paramAnnotationDoubleArray).foreach((Function1)new ApiSpecParserTrait$.anonfun.parseMethod.2($this, method$1, docOperation$1, paramTypes$1, genericParamTypes$1, counter$1, ignoreParam$1));
        DocumentationEndPoint docEndpoint = ApiSpecParserTrait$class.getEndPoint($this, $this.documentation(), $this.getPath(method$1));
        docEndpoint.addOperation($this.processOperation(method$1, docOperation$1));
        $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"added operation ").append((Object)docOperation$1).append((Object)" from method ").append((Object)method$1.getName()).toString());
        if (apiErrors == null) {
            boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        } else {
            Predef$.MODULE$.refArrayOps((Object[])apiErrors.value()).foreach((Function1)new ApiSpecParserTrait$.anonfun.parseMethod.3($this, docOperation$1));
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static DocumentationOperation processOperation(ApiSpecParserTrait $this, Method method, DocumentationOperation o) {
        return o;
    }

    private static DocumentationEndPoint getEndPoint(ApiSpecParserTrait $this, Documentation documentation, String path$1) {
        DocumentationEndPoint documentationEndPoint;
        ObjectRef ep$1 = new ObjectRef(null);
        if (documentation.getApis() != null) {
            JavaConversions$.MODULE$.asScalaBuffer(documentation.getApis()).foreach((Function1)new ApiSpecParserTrait$.anonfun.getEndPoint.1($this, path$1, ep$1));
        }
        if ((DocumentationEndPoint)ep$1.elem == null) {
            DocumentationEndPoint o = new DocumentationEndPoint(path$1, $this.apiEndpoint().description());
            documentation.addApi(o);
            documentationEndPoint = o;
        } else {
            documentationEndPoint = (DocumentationEndPoint)ep$1.elem;
        }
        return documentationEndPoint;
    }

    /*
     * WARNING - void declaration
     */
    private static String getCategory(ApiSpecParserTrait $this, Method method) {
        void var3_3;
        String simpleName;
        Class<?> declaringInterface = ReflectionUtil.getDeclaringInterface(method);
        Object object = declaringInterface == null ? null : ((simpleName = declaringInterface.getSimpleName()).toLowerCase().endsWith($this.TRAIT()) && simpleName.length() > $this.TRAIT().length() ? simpleName.substring(0, simpleName.length() - $this.TRAIT().length()) : var3_3);
        return object;
    }

    public static void $init$(ApiSpecParserTrait $this) {
        $this.com$wordnik$swagger$core$ApiSpecParserTrait$_setter_$com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER_$eq(LoggerFactory.getLogger(ApiSpecParserTrait.class));
        $this.com$wordnik$swagger$core$ApiSpecParserTrait$_setter_$TRAIT_$eq("trait");
    }
}

