/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.core;

import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiParamImplicit;
import com.wordnik.swagger.annotations.ApiParamsImplicit;
import com.wordnik.swagger.core.ApiPropertiesReader$;
import com.wordnik.swagger.core.ApiSpecParserTrait;
import com.wordnik.swagger.core.ApiSpecParserTrait$;
import com.wordnik.swagger.core.ApiValues;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationError;
import com.wordnik.swagger.core.DocumentationObject;
import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationParameter;
import com.wordnik.swagger.core.SwaggerContext$;
import com.wordnik.swagger.core.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.JavaConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public abstract class ApiSpecParserTrait$class {
    public static Documentation parse(ApiSpecParserTrait $this) {
        if ($this.apiEndpoint() != null) {
            Predef$.MODULE$.refArrayOps((Object[])$this.hostClass().getMethods()).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID;
                private final ApiSpecParserTrait $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(Method method) {
                    return this.$outer.parseMethod(this.$outer.documentation(), method);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        $this.documentation().apiVersion_$eq($this.apiVersion());
        $this.documentation().swaggerVersion_$eq($this.swaggerVersion());
        $this.documentation().basePath_$eq($this.basePath());
        $this.documentation().resourcePath_$eq($this.resourcePath());
        return $this.documentation();
    }

    public static void parseApiParam(ApiSpecParserTrait $this, DocumentationParameter docParam, ApiParam apiParam, Method method) {
        docParam.name_$eq($this.readString(apiParam.name(), docParam.name(), $this.readString$default$3()));
        docParam.description_$eq($this.readString(apiParam.value(), $this.readString$default$2(), $this.readString$default$3()));
        docParam.defaultValue_$eq($this.readString(apiParam.defaultValue(), $this.readString$default$2(), $this.readString$default$3()));
        try {
            docParam.allowableValues_$eq($this.convertToAllowableValues(apiParam.allowableValues(), $this.convertToAllowableValues$default$2()));
        }
        catch (RuntimeException runtimeException) {
            $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().error(new StringBuilder().append((Object)"Allowable values annotation problem in method  ").append((Object)method).append((Object)"for parameter ").append((Object)docParam.name()).toString());
            runtimeException.printStackTrace();
        }
        docParam.required_$eq(apiParam.required());
        docParam.allowMultiple_$eq(apiParam.allowMultiple());
        docParam.paramAccess_$eq($this.readString(apiParam.access(), $this.readString$default$2(), $this.readString$default$3()));
    }

    private static Tuple2 handleGenerics(ApiSpecParserTrait $this, String apiResponseValue) {
        int idx1 = apiResponseValue.indexOf(60);
        int idx2 = apiResponseValue.indexOf(62);
        String baseClass = apiResponseValue.substring(0, idx1);
        String name = ApiSpecParserTrait$class.com$wordnik$swagger$core$ApiSpecParserTrait$$addClassToModels($this, $this.documentation(), baseClass);
        String genericClasses = apiResponseValue.substring(idx1 + 1, idx2);
        ObjectRef genericName$1 = new ObjectRef((Object)new String());
        if (genericClasses.contains(",")) {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(genericClasses).split(',')).foreach((Function1)new Serializable($this, genericName$1){
                public static final long serialVersionUID;
                private final ApiSpecParserTrait $outer;
                private final ObjectRef genericName$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(String gc) {
                    this.genericName$1.elem = new StringBuilder().append((Object)((String)this.genericName$1.elem)).append((Object)new StringBuilder().append((Object)ApiSpecParserTrait$class.com$wordnik$swagger$core$ApiSpecParserTrait$$addClassToModels(this.$outer, this.$outer.documentation(), gc)).append((Object)",").toString()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.genericName$1 = objectRef;
                }
            });
            genericName$1.elem = ((String)genericName$1.elem).substring(0, ((String)genericName$1.elem).length() - 1);
        } else {
            genericName$1.elem = ApiSpecParserTrait$class.com$wordnik$swagger$core$ApiSpecParserTrait$$addClassToModels($this, $this.documentation(), genericClasses);
        }
        return new Tuple2((Object)name, (Object)((String)genericName$1.elem));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object parseMethod(ApiSpecParserTrait $this, Documentation documentation, Method method$1) {
        BoxedUnit boxedUnit;
        Deprecated isDeprecated;
        ApiErrors apiErrors;
        ApiOperation apiOperation;
        block13: {
            block12: {
                apiOperation = method$1.getAnnotation(ApiOperation.class);
                apiErrors = method$1.getAnnotation(ApiErrors.class);
                isDeprecated = method$1.getAnnotation(Deprecated.class);
                $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"parsing method ").append((Object)method$1.getName()).toString());
                if (apiOperation == null) break block12;
                String string = method$1.getName();
                String string2 = "getHelp";
                if (string != null ? !string.equals(string2) : string2 != null) break block13;
            }
            $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"skipping method ").append((Object)method$1.getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }
        DocumentationOperation docOperation$1 = new DocumentationOperation();
        if (isDeprecated != null) {
            docOperation$1.deprecated_$eq(Predef$.MODULE$.boolean2Boolean(true));
        }
        if (apiOperation != null) {
            docOperation$1.httpMethod_$eq($this.parseHttpMethod(method$1, apiOperation));
            docOperation$1.summary_$eq($this.readString(apiOperation.value(), $this.readString$default$2(), $this.readString$default$3()));
            docOperation$1.notes_$eq($this.readString(apiOperation.notes(), $this.readString$default$2(), $this.readString$default$3()));
            docOperation$1.setTags(JavaConversions$.MODULE$.seqAsJavaList($this.toObjectList(apiOperation.tags(), $this.toObjectList$default$2())));
            docOperation$1.nickname_$eq(method$1.getName());
            Tuple2 tuple2 = (Tuple2)new Serializable($this){
                public static final long serialVersionUID;
                private final ApiSpecParserTrait $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<String, Object> apply(String responseClass, boolean isMulti) {
                    List list;
                    String string = responseClass;
                    Option option = this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$ListRegex().unapplySeq((Object)string);
                    return !option.isEmpty() && ((list = (List)option.get()) == null ? false : list.lengthCompare(1) == 0) ? new Tuple2(list.apply(0), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)responseClass, (Object)BoxesRunTime.boxToBoolean((boolean)isMulti));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }.apply((Object)$this.readString(apiOperation.responseClass(), $this.readString$default$2(), $this.readString$default$3()), (Object)BoxesRunTime.boxToBoolean((boolean)apiOperation.multiValueResponse()));
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String string = (String)tuple2._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            if (string == null || !(BoxesRunTime.boxToBoolean((boolean)bl) instanceof Boolean)) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = new Tuple2((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
            String apiResponseValue = (String)tuple22._1();
            boolean isResponseMultiValue = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"apiOperation apiResponseValue: ").append((Object)apiResponseValue).toString());
            String p = "^([a-zA-Z_][a-zA-Z0-9_]*)(\\.[a-zA-Z0-9_]+)*(<([a-zA-Z_][a-zA-Z0-9_]*)(\\.[a-zA-Z0-9_]+)*(,([a-zA-Z_][a-zA-Z0-9_]*)(\\.[a-zA-Z0-9_]+)*)*>)+$";
            if (apiResponseValue.matches(p)) {
                Tuple2 className = ApiSpecParserTrait$class.handleGenerics($this, apiResponseValue);
                docOperation$1.responseClass_$eq(isResponseMultiValue ? new StringBuilder().append((Object)"List[").append(className._1()).append((Object)"<").append(className._2()).append((Object)">]").toString() : new StringBuilder().append((Object)((String)className._1())).append((Object)"<").append(className._2()).append((Object)">").toString());
            } else {
                docOperation$1.setResponseTypeInternal(apiResponseValue);
                try {
                    String string3;
                    if (ApiPropertiesReader$.MODULE$.manualModelMapping().contains((Object)apiResponseValue)) {
                        string3 = (String)((Tuple2)ApiPropertiesReader$.MODULE$.manualModelMapping().apply((Object)apiResponseValue))._1();
                    } else {
                        Class<?> cls = SwaggerContext$.MODULE$.loadClass(apiResponseValue);
                        $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"loaded class ").append(cls).toString());
                        string3 = ApiPropertiesReader$.MODULE$.readName(cls, ApiPropertiesReader$.MODULE$.readName$default$2());
                    }
                    String name = string3;
                    docOperation$1.responseClass_$eq(isResponseMultiValue ? new StringBuilder().append((Object)"List[").append((Object)name).append((Object)"]").toString() : name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    docOperation$1.responseClass_$eq(isResponseMultiValue ? new StringBuilder().append((Object)"List[").append((Object)apiResponseValue).append((Object)"]").toString() : apiResponseValue);
                }
            }
        }
        Annotation[] methodAnnotations = method$1.getAnnotations();
        Predef$.MODULE$.refArrayOps((Object[])methodAnnotations).foreach((Function1)new Serializable($this, method$1, docOperation$1){
            public static final long serialVersionUID;
            private final ApiSpecParserTrait $outer;
            public final Method method$1;
            public final DocumentationOperation docOperation$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(Annotation ma) {
                Unit$ unit$;
                Annotation annotation = ma;
                if (annotation instanceof ApiParamsImplicit) {
                    Predef$.MODULE$.refArrayOps((Object[])((ApiParamsImplicit)annotation).value()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final ApiSpecParserTrait$.anonfun.parseMethod.1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final ListBuffer<DocumentationParameter> apply(ApiParamImplicit p) {
                            DocumentationParameter docParam = new DocumentationParameter();
                            docParam.paramType_$eq(ApiValues.TYPE_QUERY);
                            docParam.name_$eq(this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString(p.name(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$2(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$3()));
                            docParam.description_$eq(this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString(p.value(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$2(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$3()));
                            docParam.defaultValue_$eq(this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString(p.defaultValue(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$2(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$3()));
                            try {
                                docParam.allowableValues_$eq(this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().convertToAllowableValues(p.allowableValues(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().convertToAllowableValues$default$2()));
                            }
                            catch (RuntimeException runtimeException) {
                                this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().error(new StringBuilder().append((Object)"Allowable values annotation problem in method  ").append((Object)this.$outer.method$1).append((Object)"for parameter ").append((Object)docParam.name()).toString());
                                runtimeException.printStackTrace();
                            }
                            docParam.required_$eq(p.required());
                            docParam.allowMultiple_$eq(p.allowMultiple());
                            docParam.paramAccess_$eq(this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString(p.access(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$2(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$3()));
                            docParam.internalDescription_$eq(this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString(p.internalDescription(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$2(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$3()));
                            docParam.paramType_$eq(this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString(p.paramType(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$2(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$3()));
                            docParam.paramType_$eq(docParam.paramType() == null ? ApiValues.TYPE_QUERY : docParam.paramType());
                            String dataType = this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString(p.dataType(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$2(), this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer().readString$default$3());
                            docParam.setValueTypeInternal(dataType);
                            try {
                                Class<?> cls = SwaggerContext$.MODULE$.loadClass(dataType);
                                docParam.dataType_$eq(ApiPropertiesReader$.MODULE$.readName(cls, ApiPropertiesReader$.MODULE$.readName$default$2()));
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                docParam.dataType_$eq(dataType);
                            }
                            return this.$outer.docOperation$1.addParameter(docParam);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    unit$ = BoxedUnit.UNIT;
                } else {
                    unit$ = Unit$.MODULE$;
                }
                return unit$;
            }

            public ApiSpecParserTrait com$wordnik$swagger$core$ApiSpecParserTrait$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.method$1 = method;
                this.docOperation$1 = documentationOperation;
            }
        });
        Annotation[][] paramAnnotationDoubleArray = method$1.getParameterAnnotations();
        Class[] paramTypes$1 = method$1.getParameterTypes();
        Type[] genericParamTypes$1 = method$1.getGenericParameterTypes();
        IntRef counter$1 = new IntRef(0);
        BooleanRef ignoreParam$1 = new BooleanRef(false);
        Predef$.MODULE$.refArrayOps((Object[])paramAnnotationDoubleArray).foreach((Function1)new Serializable($this, method$1, docOperation$1, paramTypes$1, genericParamTypes$1, counter$1, ignoreParam$1){
            public static final long serialVersionUID;
            private final ApiSpecParserTrait $outer;
            private final Method method$1;
            private final DocumentationOperation docOperation$1;
            private final Class[] paramTypes$1;
            private final Type[] genericParamTypes$1;
            private final IntRef counter$1;
            private final BooleanRef ignoreParam$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(Annotation[] paramAnnotations) {
                DocumentationParameter docParam = new DocumentationParameter();
                docParam.required_$eq(true);
                try {
                    Class paramTypeClass = this.paramTypes$1[this.counter$1.elem];
                    String paramTypeName = ApiPropertiesReader$.MODULE$.getDataType(this.genericParamTypes$1[this.counter$1.elem], paramTypeClass);
                    docParam.dataType_$eq(ApiPropertiesReader$.MODULE$.manualModelMapping().contains((Object)paramTypeName) ? (String)((Tuple2)ApiPropertiesReader$.MODULE$.manualModelMapping().apply((Object)paramTypeName))._1() : paramTypeName);
                    if (!paramTypeClass.isPrimitive() && !paramTypeClass.getName().contains("java.lang")) {
                        docParam.setValueTypeInternal(ApiPropertiesReader$.MODULE$.getGenericTypeParam(this.genericParamTypes$1[this.counter$1.elem], paramTypeClass));
                    }
                }
                catch (Exception exception) {
                    this.$outer.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"Unable to determine datatype for param ").append((Object)BoxesRunTime.boxToInteger((int)this.counter$1.elem)).append((Object)" in method ").append((Object)this.method$1).toString(), (Throwable)exception);
                }
                this.ignoreParam$1.elem = this.$outer.processParamAnnotations(docParam, paramAnnotations, this.method$1);
                if (paramAnnotations.length == 0) {
                    this.ignoreParam$1.elem = true;
                }
                ++this.counter$1.elem;
                docParam.paramType_$eq(this.$outer.readString(ApiValues.TYPE_BODY, docParam.paramType(), this.$outer.readString$default$3()));
                return this.ignoreParam$1.elem ? BoxedUnit.UNIT : this.docOperation$1.addParameter(docParam);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.method$1 = method;
                this.docOperation$1 = documentationOperation;
                this.paramTypes$1 = classArray;
                this.genericParamTypes$1 = typeArray;
                this.counter$1 = intRef;
                this.ignoreParam$1 = booleanRef;
            }
        });
        DocumentationEndPoint docEndpoint = ApiSpecParserTrait$class.getEndPoint($this, documentation, $this.getPath(method$1));
        docEndpoint.addOperation($this.processOperation(method$1, docOperation$1));
        $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().debug(new StringBuilder().append((Object)"added operation ").append((Object)docOperation$1).append((Object)" from method ").append((Object)method$1.getName()).toString());
        if (apiErrors == null) {
            boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        } else {
            Predef$.MODULE$.refArrayOps((Object[])apiErrors.value()).foreach((Function1)new Serializable($this, docOperation$1){
                public static final long serialVersionUID;
                private final ApiSpecParserTrait $outer;
                private final DocumentationOperation docOperation$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(ApiError apiError) {
                    DocumentationError docError = new DocumentationError();
                    docError.code_$eq(apiError.code());
                    docError.reason_$eq(this.$outer.readString(apiError.reason(), this.$outer.readString$default$2(), this.$outer.readString$default$3()));
                    return this.docOperation$1.addErrorResponse(docError);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.docOperation$1 = documentationOperation;
                }
            });
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    /*
     * WARNING - void declaration
     */
    public static final String com$wordnik$swagger$core$ApiSpecParserTrait$$addClassToModels(ApiSpecParserTrait $this, Documentation d, String t) {
        void var3_3;
        String exceptionResult1 = null;
        try {
            Object object;
            DocumentationObject n = ApiPropertiesReader$.MODULE$.read(t);
            if (n != null && n.getFields() != null && JavaConversions$.MODULE$.asScalaBuffer(n.getFields()).length() > 0) {
                object = d.addModel(n.getName(), n.toDocumentationSchema());
            } else {
                if (n == null) {
                    $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().error(new StringBuilder().append((Object)"Skipping model ").append((Object)t).append((Object)". Could not load the model.").toString());
                } else if (n.getFields() == null || JavaConversions$.MODULE$.asScalaBuffer(n.getFields()).length() == 0) {
                    $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().error(new StringBuilder().append((Object)"Skipping model ").append((Object)t).append((Object)". Did not find any public fields or bean-properties in this model. If its a scala class its fields might not have @BeanProperty annotation added to its fields.").toString());
                }
                object = BoxedUnit.UNIT;
            }
            exceptionResult1 = n.getName();
        }
        catch (Exception exception) {
            $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().error(new StringBuilder().append((Object)"Unable to load model documentation for ").append((Object)t).toString(), (Throwable)exception);
            exceptionResult1 = t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            $this.com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER().error(new StringBuilder().append((Object)"Unable to resolve class ").append((Object)t).toString());
            exceptionResult1 = t;
        }
        return var3_3;
    }

    public static DocumentationOperation processOperation(ApiSpecParserTrait $this, Method method, DocumentationOperation o) {
        return o;
    }

    private static DocumentationEndPoint getEndPoint(ApiSpecParserTrait $this, Documentation documentation, String path$1) {
        DocumentationEndPoint documentationEndPoint;
        ObjectRef ep$1 = new ObjectRef(null);
        if (documentation.getApis() != null) {
            JavaConversions$.MODULE$.asScalaBuffer(documentation.getApis()).foreach((Function1)new Serializable($this, path$1, ep$1){
                public static final long serialVersionUID;
                private final String path$1;
                private final ObjectRef ep$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(DocumentationEndPoint endpoint) {
                    String string = endpoint.path();
                    String string2 = this.path$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.ep$1.elem = endpoint;
                    }
                }
                {
                    this.path$1 = string;
                    this.ep$1 = objectRef;
                }
            });
        }
        if ((DocumentationEndPoint)ep$1.elem == null) {
            DocumentationEndPoint o = new DocumentationEndPoint(path$1, $this.apiEndpoint().description());
            documentation.addApi(o);
            documentationEndPoint = o;
        } else {
            documentationEndPoint = (DocumentationEndPoint)ep$1.elem;
        }
        return documentationEndPoint;
    }

    /*
     * WARNING - void declaration
     */
    private static String getCategory(ApiSpecParserTrait $this, Method method) {
        void var3_3;
        String simpleName;
        Class<?> declaringInterface = ReflectionUtil.getDeclaringInterface(method);
        Object object = declaringInterface == null ? null : ((simpleName = declaringInterface.getSimpleName()).toLowerCase().endsWith($this.TRAIT()) && simpleName.length() > $this.TRAIT().length() ? simpleName.substring(0, simpleName.length() - $this.TRAIT().length()) : var3_3);
        return object;
    }

    public static void $init$(ApiSpecParserTrait $this) {
        $this.com$wordnik$swagger$core$ApiSpecParserTrait$_setter_$com$wordnik$swagger$core$ApiSpecParserTrait$$LOGGER_$eq(LoggerFactory.getLogger(ApiSpecParserTrait.class));
        $this.com$wordnik$swagger$core$ApiSpecParserTrait$_setter_$TRAIT_$eq("trait");
        $this.com$wordnik$swagger$core$ApiSpecParserTrait$_setter_$com$wordnik$swagger$core$ApiSpecParserTrait$$ListRegex_$eq(Predef$.MODULE$.augmentString("List\\[(.*?)\\]").r());
    }
}

