package com.xmlcalabash.drivers;

import com.saxonica.config.ProfessionalConfiguration;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class SaxonTest {
    private static Processor processor = new Processor(true);

    public static void main(String[] args) throws SaxonApiException, IOException, URISyntaxException {
        SaxonTest main = new SaxonTest();
        main.run(args);
    }

    public void run(String[] args) throws SaxonApiException, IOException, URISyntaxException {
        importFunctions();
        Vector<XdmItem> x = evaluateXPath("f:count((1,2,3))");
    }

    protected Vector<XdmItem> evaluateXPath(String xpath) throws SaxonApiException {
        XdmNode doc = null;
        Vector<XdmItem> results = new Vector<XdmItem> ();

        XPathCompiler xcomp = processor.newXPathCompiler();
        xcomp.declareNamespace("f", "http://xmlcalabash.com/ns/functions");

        XPathExecutable xexec = xcomp.compile(xpath);
        XPathSelector selector = xexec.load();

        if (doc != null) {
            selector.setContextItem(doc);
        }

        try {
            Iterator<XdmItem> values = selector.iterator();
            while (values.hasNext()) {
                results.add(values.next());
            }
        } catch (SaxonApiUncheckedException saue) {
            throw saue;
        }

        return results;
    }

    private void importFunctions() {
        String ns = "http://xmlcalabash.com/ns/functions";

        try {
            XQueryCompiler xqcomp = processor.newXQueryCompiler();

            StaticQueryContext sqc = xqcomp.getUnderlyingStaticContext();
            //sqc.compileLibrary(new StringReader(query));
            XQueryExpression xqe = sqc.compileQuery("import module namespace f='" + ns + "' at 'f.xqy'; .");
            QueryModule qm = xqe.getStaticContext();
            XQueryFunctionLibrary xfl = qm.getGlobalFunctionLibrary();
            ((ProfessionalConfiguration)processor.getUnderlyingConfiguration()).setExtensionBinder("calabash", xfl);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}
