/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;
import org.xml.sax.InputSource;

public class XProcConfiguration {
    public static final QName _prefix = new QName("", "prefix");
    public static final QName _uri = new QName("", "uri");
    public static final QName _class_name = new QName("", "class-name");
    public static final QName _type = new QName("", "type");
    public static final QName _port = new QName("", "port");
    public static final QName _href = new QName("", "href");
    public static final QName _data = new QName("", "data");
    public static final QName _name = new QName("", "name");
    public static final QName _key = new QName("", "key");
    public static final QName _value = new QName("", "value");
    public static final QName _loader = new QName("", "loader");
    public static final QName _exclude_inline_prefixes = new QName("", "exclude-inline-prefixes");
    public String saxonProcessor = "he";
    public boolean schemaAware = false;
    public Input saxonConfig = null;
    public Hashtable<String, String> nsBindings = new Hashtable();
    public boolean debug = false;
    public Output profile = null;
    public Hashtable<String, Vector<ReadablePipe>> inputs = new Hashtable();
    public ReadablePipe pipeline = null;
    public Hashtable<String, String> outputs = new Hashtable();
    public Hashtable<String, Hashtable<QName, String>> params = new Hashtable();
    public Hashtable<QName, String> options = new Hashtable();
    public boolean safeMode = false;
    public String stepName = null;
    public String entityResolver = null;
    public String uriResolver = null;
    public String errorListener = null;
    public Hashtable<QName, String> implementations = new Hashtable();
    public Hashtable<String, String> serializationOptions = new Hashtable();
    public LogOptions logOpt = LogOptions.WRAPPED;
    public Vector<String> extensionFunctions = new Vector();
    public String foProcessor = null;
    public String cssProcessor = null;
    public String xprocConfigurer = null;
    public String htmlParser = "validator.nu";
    public String mailHost = null;
    public String mailPort = "25";
    public String mailUser = null;
    public String mailPass = null;
    public Hashtable<String, String> loaders = new Hashtable();
    public boolean extensionValues = false;
    public boolean xpointerOnText = false;
    public boolean transparentJSON = false;
    public String jsonFlavor = "marklogic";
    public boolean useXslt10 = false;
    private Processor cfgProcessor = null;
    private boolean firstInput = false;
    private boolean firstOutput = false;

    public XProcConfiguration() {
        this.init("he", false, null);
    }

    public XProcConfiguration(boolean bl) {
        this.init("he", bl, null);
    }

    public XProcConfiguration(Input input) {
        this.init(null, false, input);
    }

    public XProcConfiguration(String string, boolean bl) {
        this.init(string, bl, null);
    }

    public XProcConfiguration(Processor processor) {
        this.cfgProcessor = processor;
        this.loadConfiguration();
        if (this.schemaAware != processor.isSchemaAware()) {
            throw new XProcException("Schema awareness in configuration conflicts with specified processor.");
        }
    }

    public Processor getProcessor() {
        return this.cfgProcessor;
    }

    private void init(String string, boolean bl, Input input) {
        if (bl) {
            string = "ee";
        }
        this.createSaxonProcessor(string, bl, input);
        this.loadConfiguration();
        this.schemaAware = this.cfgProcessor.isSchemaAware();
        this.saxonProcessor = Configuration.softwareEdition.toLowerCase();
        if (string != null && !this.saxonProcessor.equals(string) || bl != this.schemaAware || input == null && this.saxonConfig != null) {
            this.nsBindings.clear();
            this.inputs.clear();
            this.outputs.clear();
            this.params.clear();
            this.options.clear();
            this.implementations.clear();
            this.extensionFunctions.clear();
            this.createSaxonProcessor(this.saxonProcessor, this.schemaAware, this.saxonConfig);
            this.loadConfiguration();
            this.schemaAware = this.cfgProcessor.isSchemaAware();
            this.saxonProcessor = Configuration.softwareEdition.toLowerCase();
        }
    }

    private void createSaxonProcessor(String string, boolean bl, Input input) {
        Object object;
        boolean bl2;
        boolean bl3 = bl2 = bl || !"he".equals(string);
        if (input != null) {
            try {
                Object object2;
                object = null;
                switch (input.getKind()) {
                    case URI: {
                        object2 = URI.create(input.getUri());
                        object = new FileInputStream(new File((URI)object2));
                        break;
                    }
                    case INPUT_STREAM: {
                        object = input.getInputStream();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported saxonConfig kind '%s'", new Object[]{input.getKind()}));
                    }
                }
                object2 = new SAXSource(new InputSource((InputStream)object));
                this.cfgProcessor = new Processor((Source)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XProcException(fileNotFoundException);
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        } else {
            this.cfgProcessor = new Processor(bl2);
        }
        object = Configuration.softwareEdition;
        if (string != null && !"he".equals(string) && !((String)object).toLowerCase().equals(string)) {
            System.err.println("Failed to obtain " + string.toUpperCase() + " processor; using " + (String)object + " instead.");
        }
    }

    private String fixUpURI(String string) {
        File file = new File(string);
        String string2 = URIUtils.encode(file.getAbsolutePath());
        if ("\\".equals(System.getProperty("file.separator"))) {
            string2 = "/" + string2;
        }
        return string2;
    }

    private void loadConfiguration() {
        String string;
        String[] stringArray;
        Object object;
        Object object2;
        block18: {
            String string2;
            URI uRI;
            block17: {
                URI uRI2 = URIUtils.homeAsURI();
                uRI = URIUtils.cwdAsURI();
                URI uRI3 = uRI2;
                this.cfgProcessor.getUnderlyingConfiguration().setStripsAllWhiteSpace(false);
                this.cfgProcessor.getUnderlyingConfiguration().setStripsWhiteSpace(0);
                string2 = System.getProperty("com.xmlcalabash.config.global");
                try {
                    object2 = null;
                    if (string2 == null) {
                        object2 = this.getClass().getResourceAsStream("/etc/configuration.xml");
                        if (object2 == null) {
                            throw new UnsupportedOperationException("Failed to load configuration from JAR file");
                        }
                        object = new SAXSource(new InputSource((InputStream)object2));
                        stringArray = this.cfgProcessor.newDocumentBuilder();
                        stringArray.setLineNumbering(true);
                        stringArray.setBaseURI(uRI3);
                        this.parse(stringArray.build((Source)object));
                    } else {
                        this.parse(this.readXML(string2, uRI.toASCIIString()));
                    }
                }
                catch (SaxonApiException saxonApiException) {
                    throw new XProcException(saxonApiException);
                }
                string2 = System.getProperty("com.xmlcalabash.config.user", ".calabash");
                if (!"".equals(string2)) {
                    try {
                        object2 = this.readXML(string2, uRI2.toASCIIString());
                        this.parse((XdmNode)object2);
                    }
                    catch (XProcException xProcException) {
                        if (XProcConstants.dynamicError(11).equals((Object)xProcException.getErrorCode())) break block17;
                        throw xProcException;
                    }
                }
            }
            string2 = System.getProperty("com.xmlcalabash.config.local", ".calabash");
            if (!"".equals(string2)) {
                try {
                    object2 = this.readXML(string2, uRI.toASCIIString());
                    this.parse((XdmNode)object2);
                }
                catch (XProcException xProcException) {
                    if (XProcConstants.dynamicError(11).equals((Object)xProcException.getErrorCode())) break block18;
                    throw xProcException;
                }
            }
        }
        this.saxonProcessor = System.getProperty("com.xmlcalabash.saxon-processor", this.saxonProcessor);
        if (!("he".equals(this.saxonProcessor) || "pe".equals(this.saxonProcessor) || "ee".equals(this.saxonProcessor))) {
            throw new XProcException("Invalid Saxon processor specified in com.xmlcalabash.saxon-processor property.");
        }
        object2 = System.getProperty("com.xmlcalabash.saxon-configuration");
        if (object2 != null) {
            this.saxonConfig = new Input("file://" + this.fixUpURI((String)object2));
        }
        this.schemaAware = "true".equals(System.getProperty("com.xmlcalabash.schema-aware", "" + this.schemaAware));
        this.debug = "true".equals(System.getProperty("com.xmlcalabash.debug", "" + this.debug));
        object = System.getProperty("com.xmlcalabash.profile");
        if (object != null) {
            this.profile = new Output("file://" + this.fixUpURI((String)object));
        }
        this.extensionValues = "true".equals(System.getProperty("com.xmlcalabash.general-values", "" + this.extensionValues));
        this.xpointerOnText = "true".equals(System.getProperty("com.xmlcalabash.xpointer-on-text", "" + this.xpointerOnText));
        this.transparentJSON = "true".equals(System.getProperty("com.xmlcalabash.transparent-json", "" + this.transparentJSON));
        this.jsonFlavor = System.getProperty("com.xmlcalabash.json-flavor", this.jsonFlavor);
        this.useXslt10 = "true".equals(System.getProperty("com.xmlcalabash.use-xslt-10", "" + this.useXslt10));
        this.entityResolver = System.getProperty("com.xmlcalabash.entity-resolver", this.entityResolver);
        this.uriResolver = System.getProperty("com.xmlcalabash.uri-resolver", this.uriResolver);
        this.errorListener = System.getProperty("com.xmlcalabash.error-listener", this.errorListener);
        this.foProcessor = System.getProperty("com.xmlcalabash.fo-processor", this.foProcessor);
        this.cssProcessor = System.getProperty("com.xmlcalabash.css-processor", this.cssProcessor);
        this.xprocConfigurer = System.getProperty("com.xmlcalabash.xproc-configurer", this.xprocConfigurer);
        this.htmlParser = System.getProperty("com.xmlcalabash.html-parser", this.htmlParser);
        this.mailHost = System.getProperty("com.xmlcalabash.mail-host", this.mailHost);
        this.mailPort = System.getProperty("com.xmlcalabash.mail-port", this.mailPort);
        this.mailUser = System.getProperty("com.xmlcalabash.mail-username", this.mailUser);
        this.mailPass = System.getProperty("com.xmlcalabash.mail-password", this.mailPass);
        stringArray = new String[]{"byte-order-mark", "escape-uri-attributes", "include-content-type", "indent", "omit-xml-declaration", "undeclare-prefixes"};
        String[] stringArray2 = new String[]{"doctype-public", "doctype-system", "encoding", "media-type", "normalization-form", "version", "standalone"};
        for (String string2 : stringArray) {
            string = System.getProperty("com.xmlcalabash.serial." + string2);
            if (!"true".equals(string) && !"false".equals(string)) continue;
            this.serializationOptions.put(string2, string);
        }
        for (String string2 : stringArray2) {
            string = System.getProperty("com.xmlcalabash.serial." + string2);
            if (string == null) continue;
            this.serializationOptions.put(string2, string);
        }
        String string3 = System.getProperty("com.xmlcalabash.serial.method");
        if ("html".equals(string3) || "xhtml".equals(string3) || "text".equals(string3) || "xml".equals(string3)) {
            this.serializationOptions.put(string3, string3);
        }
    }

    public XdmNode readXML(String string, String string2) {
        URI uRI;
        SAXSource sAXSource = null;
        string = URIUtils.encode(string);
        try {
            uRI = new URI(string2);
            sAXSource = new SAXSource(new InputSource(uRI.resolve(string).toASCIIString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XProcException(uRISyntaxException);
        }
        uRI = this.cfgProcessor.newDocumentBuilder();
        uRI.setLineNumbering(true);
        try {
            return uRI.build(sAXSource);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(XProcConstants.dynamicError(11), (Throwable)saxonApiException);
        }
    }

    public void parse(XdmNode xdmNode) {
        if (xdmNode.getNodeKind() == XdmNodeKind.DOCUMENT) {
            xdmNode = S9apiUtils.getDocumentElement(xdmNode);
        }
        for (XdmNode xdmNode2 : new RelevantNodes(null, xdmNode, Axis.CHILD)) {
            String string = xdmNode2.getNodeName().getNamespaceURI();
            String string2 = xdmNode2.getNodeName().getLocalName();
            if (!"http://xmlcalabash.com/ns/configuration".equals(string) && !"http://exproc.org/ns/configuration".equals(string)) continue;
            if ("implementation".equals(string2)) {
                this.parseImplementation(xdmNode2);
                continue;
            }
            if ("saxon-processor".equals(string2)) {
                this.parseSaxonProcessor(xdmNode2);
                continue;
            }
            if ("saxon-configuration".equals(string2)) {
                this.parseSaxonConfiguration(xdmNode2);
                continue;
            }
            if ("schema-aware".equals(string2)) {
                this.parseSchemaAware(xdmNode2);
                continue;
            }
            if ("namespace-binding".equals(string2)) {
                this.parseNamespaceBinding(xdmNode2);
                continue;
            }
            if ("debug".equals(string2)) {
                this.parseDebug(xdmNode2);
                continue;
            }
            if ("profile".equals(string2)) {
                this.parseProfile(xdmNode2);
                continue;
            }
            if ("entity-resolver".equals(string2)) {
                this.parseEntityResolver(xdmNode2);
                continue;
            }
            if ("input".equals(string2)) {
                this.parseInput(xdmNode2);
                continue;
            }
            if ("output".equals(string2)) {
                this.parseOutput(xdmNode2);
                continue;
            }
            if ("with-option".equals(string2)) {
                this.parseWithOption(xdmNode2);
                continue;
            }
            if ("with-param".equals(string2)) {
                this.parseWithParam(xdmNode2);
                continue;
            }
            if ("safe-mode".equals(string2)) {
                this.parseSafeMode(xdmNode2);
                continue;
            }
            if ("step-name".equals(string2)) {
                this.parseStepName(xdmNode2);
                continue;
            }
            if ("uri-resolver".equals(string2)) {
                this.parseURIResolver(xdmNode2);
                continue;
            }
            if ("step-error-listener".equals(string2)) {
                this.parseErrorListener(xdmNode2);
                continue;
            }
            if ("pipeline".equals(string2)) {
                this.parsePipeline(xdmNode2);
                continue;
            }
            if ("serialization".equals(string2)) {
                this.parseSerialization(xdmNode2);
                continue;
            }
            if ("extension-function".equals(string2)) {
                this.parseExtensionFunction(xdmNode2);
                continue;
            }
            if ("fo-processor".equals(string2)) {
                this.parseFoProcessor(xdmNode2);
                continue;
            }
            if ("css-processor".equals(string2)) {
                this.parseCssProcessor(xdmNode2);
                continue;
            }
            if ("xproc-configurer".equals(string2)) {
                this.parseXProcConfigurer(xdmNode2);
                continue;
            }
            if ("default-system-property".equals(string2)) {
                this.parseSystemProperty(xdmNode2);
                continue;
            }
            if ("extension".equals(string2)) {
                this.parseExtension(xdmNode2);
                continue;
            }
            if ("html-parser".equals(string2)) {
                this.parseHtmlParser(xdmNode2);
                continue;
            }
            if ("sendmail".equals(string2)) {
                this.parseSendMail(xdmNode2);
                continue;
            }
            if ("saxon-configuration-property".equals(string2)) {
                this.saxonConfigurationProperty(xdmNode2);
                continue;
            }
            if ("pipeline-loader".equals(string2)) {
                this.pipelineLoader(xdmNode2);
                continue;
            }
            throw new XProcException(xdmNode, "Unexpected configuration option: " + string2);
        }
        this.firstInput = true;
        this.firstOutput = true;
    }

    public boolean isStepAvailable(QName qName) {
        return this.implementations.containsKey(qName);
    }

    public XProcStep newStep(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        String string = this.implementations.get(xAtomicStep.getType());
        if (string == null) {
            throw new UnsupportedOperationException("Misconfigured. No 'class' in configuration for " + xAtomicStep.getType());
        }
        if (xProcRuntime.getSafeMode() && !string.startsWith("com.xmlcalabash.")) {
            throw XProcException.dynamicError(21);
        }
        try {
            Constructor<?> constructor = Class.forName(string).getConstructor(XProcRuntime.class, XAtomicStep.class);
            return (XProcStep)constructor.newInstance(xProcRuntime, xAtomicStep);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnsupportedOperationException("No such method: " + string, noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("Class not found: " + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException("Instantiation error", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Illegal access error", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Invocation target exception", invocationTargetException);
        }
    }

    private void parseSaxonProcessor(XdmNode xdmNode) {
        String string = xdmNode.getStringValue().trim();
        if (!("he".equals(string) || "pe".equals(string) || "ee".equals(string))) {
            throw new XProcException(xdmNode, "Invalid Saxon processor: " + string + ". Must be 'he', 'pe', or 'ee'.");
        }
        this.saxonProcessor = string;
    }

    private void parseSaxonConfiguration(XdmNode xdmNode) {
        String string = xdmNode.getStringValue().trim();
        this.saxonConfig = new Input("file://" + this.fixUpURI(string));
    }

    private void parseSchemaAware(XdmNode xdmNode) {
        String string = xdmNode.getStringValue().trim();
        if (!"true".equals(string) && !"false".equals(string)) {
            throw new XProcException(xdmNode, "Invalid configuration value for schema-aware: " + string);
        }
        this.schemaAware = "true".equals(string);
    }

    private void parseNamespaceBinding(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_prefix);
        String string2 = xdmNode.getAttributeValue(_uri);
        this.nsBindings.put(string, string2);
    }

    private void parseDebug(XdmNode xdmNode) {
        String string = xdmNode.getStringValue().trim();
        this.debug = "true".equals(string);
        if (!"true".equals(string) && !"false".equals(string)) {
            throw new XProcException(xdmNode, "Invalid configuration value for debug: " + string);
        }
    }

    private void parseProfile(XdmNode xdmNode) {
        this.profile = new Output("file://" + this.fixUpURI(xdmNode.getStringValue().trim()));
    }

    private void parseEntityResolver(XdmNode xdmNode) {
        String string;
        this.entityResolver = string = xdmNode.getAttributeValue(_class_name);
    }

    private void parseExtensionFunction(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_class_name);
        this.extensionFunctions.add(string);
    }

    private void parseFoProcessor(XdmNode xdmNode) {
        String string;
        this.foProcessor = string = xdmNode.getAttributeValue(_class_name);
    }

    private void parseCssProcessor(XdmNode xdmNode) {
        String string;
        this.cssProcessor = string = xdmNode.getAttributeValue(_class_name);
    }

    private void parseXProcConfigurer(XdmNode xdmNode) {
        String string;
        this.xprocConfigurer = string = xdmNode.getAttributeValue(_class_name);
    }

    private void parseSystemProperty(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_name);
        String string2 = xdmNode.getAttributeValue(_value);
        if (string == null || string2 == null) {
            throw new XProcException("Configuration option 'default-system-property' cannot have null name or value");
        }
        if (System.getProperty(string) == null) {
            System.setProperty(string, string2);
        }
    }

    private void parseExtension(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_name);
        String string2 = xdmNode.getAttributeValue(_value);
        if (string == null || string2 == null) {
            throw new XProcException("Configuration option 'extension' cannot have null name or value");
        }
        if ("general-values".equals(string)) {
            this.extensionValues = "true".equals(string2);
        } else if ("xpointer-on-text".equals(string)) {
            this.xpointerOnText = "true".equals(string2);
        } else if ("transparent-json".equals(string)) {
            this.transparentJSON = "true".equals(string2);
        } else if ("json-flavor".equals(string)) {
            this.jsonFlavor = string2;
            if (!JSONtoXML.knownFlavor(this.jsonFlavor)) {
                throw new XProcException("Unrecognized JSON flavor: " + this.jsonFlavor);
            }
        } else if ("use-xslt-1.0".equals(string) || "use-xslt-10".equals(string)) {
            this.useXslt10 = "true".equals(string2);
        } else {
            throw new XProcException("Unrecognized extension in configuration: " + string);
        }
    }

    private void parseHtmlParser(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_value);
        if (string == null) {
            throw new XProcException("Configuration option 'html-parser' cannot have null value");
        }
        if (!"validator.nu".equals(string) && !"tagsoup".equals(string)) {
            throw new XProcException("Unrecognized value in html-parser: " + string);
        }
        this.htmlParser = string;
    }

    private void parseSendMail(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(new QName("", "host"));
        String string2 = xdmNode.getAttributeValue(_port);
        String string3 = xdmNode.getAttributeValue(new QName("", "username"));
        String string4 = xdmNode.getAttributeValue(new QName("", "password"));
        if (string != null) {
            this.mailHost = string;
        }
        if (string2 != null) {
            this.mailPort = string2;
        }
        if (string3 != null) {
            this.mailUser = string3;
            if (string4 == null) {
                throw new XProcException("Misconfigured sendmail: user specified without password");
            }
            this.mailPass = string4;
        }
    }

    private void saxonConfigurationProperty(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_value);
        String string2 = xdmNode.getAttributeValue(_key);
        String string3 = xdmNode.getAttributeValue(_type);
        Object object = null;
        if (string2 == null || string == null) {
            throw new XProcException("Configuration option 'saxon-configuration-property' cannot have a null key or value");
        }
        object = "boolean".equals(string3) ? Boolean.valueOf("true".equals(string)) : ("integer".equals(string3) ? Integer.valueOf(Integer.parseInt(string)) : string);
        try {
            this.cfgProcessor.setConfigurationProperty(string2, object);
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
    }

    private void pipelineLoader(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_data);
        String string2 = xdmNode.getAttributeValue(_href);
        String string3 = xdmNode.getAttributeValue(_loader);
        if (string == null && string2 == null || string != null && string2 != null) {
            throw new XProcException("Configuration option 'pipeline-loader' must have one of 'href' or 'data'");
        }
        if (string3 == null) {
            throw new XProcException("Configuration option 'pipeline-loader' must specify a 'loader'");
        }
        if (string == null) {
            this.loaders.put("href:" + string2, string3);
        } else {
            this.loaders.put("data:" + string, string3);
        }
    }

    private void parseInput(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_port);
        String string2 = xdmNode.getAttributeValue(_href);
        Vector<XdmValue> vector = new Vector<XdmValue>();
        boolean bl = false;
        for (Object object : new RelevantNodes(null, xdmNode, Axis.CHILD)) {
            if (object.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (bl) {
                    throw new XProcException(xdmNode, "Invalid configuration value for input '" + string + "': content is not a valid XML document.");
                }
                bl = true;
            }
            vector.add((XdmValue)object);
        }
        if (this.firstInput) {
            this.inputs.clear();
            this.firstInput = false;
        }
        if (!this.inputs.containsKey(string)) {
            this.inputs.put(string, new Vector());
        }
        Vector<ReadablePipe> vector2 = this.inputs.get(string);
        if (string2 != null) {
            if (vector.size() > 0) {
                throw new XProcException(xdmNode, "Invalid configuration value for input '" + string + "': href and content on input.");
            }
            vector2.add(new ConfigDocument(string2, xdmNode.getBaseURI().toASCIIString()));
        } else {
            Object object;
            object = S9apiUtils.excludeInlinePrefixes(xdmNode, xdmNode.getAttributeValue(_exclude_inline_prefixes));
            vector2.add(new ConfigDocument(vector, (HashSet<String>)object));
        }
    }

    private void parsePipeline(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_href);
        Vector<XdmValue> vector = new Vector<XdmValue>();
        boolean bl = false;
        for (XdmNode xdmNode2 : new RelevantNodes(null, xdmNode, Axis.CHILD)) {
            if (xdmNode2.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (bl) {
                    throw new XProcException(xdmNode, "Content of pipeline is not a valid XML document.");
                }
                bl = true;
            }
            vector.add((XdmValue)xdmNode2);
        }
        if (string != null) {
            if (vector.size() > 0) {
                throw new XProcException(xdmNode, "XProcConfiguration error: href and content on pipeline");
            }
            this.pipeline = new ConfigDocument(string, xdmNode.getBaseURI().toASCIIString());
        } else {
            HashSet<String> hashSet = S9apiUtils.excludeInlinePrefixes(xdmNode, xdmNode.getAttributeValue(_exclude_inline_prefixes));
            this.pipeline = new ConfigDocument(vector, hashSet);
        }
    }

    private void parseOutput(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_port);
        String string2 = xdmNode.getAttributeValue(_href);
        for (Object object : new RelevantNodes(null, xdmNode, Axis.CHILD)) {
            if (object.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            throw new XProcException(xdmNode, "Output must be empty.");
        }
        if (this.firstOutput) {
            this.outputs.clear();
            this.firstOutput = false;
        }
        if ("-".equals(string2 = xdmNode.getBaseURI().resolve(string2).toASCIIString()) || string2.startsWith("http:") || string2.startsWith("https:") || string2.startsWith("file:")) {
            this.outputs.put(string, string2);
        } else {
            Object object;
            File file = new File(string2);
            object = URIUtils.encode(file.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                object = "/" + (String)object;
            }
            this.outputs.put(string, "file://" + (String)object);
        }
    }

    private void parseWithOption(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_name);
        String string2 = xdmNode.getAttributeValue(_value);
        QName qName = new QName(string, xdmNode);
        this.options.put(qName, string2);
    }

    private void parseWithParam(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_port);
        String string2 = xdmNode.getAttributeValue(_name);
        String string3 = xdmNode.getAttributeValue(_value);
        QName qName = new QName(string2, xdmNode);
        if (string == null) {
            string = "*";
        }
        Hashtable<QName, String> hashtable = this.params.containsKey(string) ? this.params.get(string) : new Hashtable<QName, String>();
        hashtable.put(qName, string3);
        this.params.put(string, hashtable);
    }

    private void parseSafeMode(XdmNode xdmNode) {
        String string = xdmNode.getStringValue().trim();
        this.safeMode = "true".equals(string);
        if (!"true".equals(string) && !"false".equals(string)) {
            throw new XProcException(xdmNode, "Unexpected configuration value for safe-mode: " + string);
        }
    }

    private void parseStepName(XdmNode xdmNode) {
        String string;
        this.stepName = string = xdmNode.getStringValue().trim();
    }

    private void parseURIResolver(XdmNode xdmNode) {
        String string;
        this.uriResolver = string = xdmNode.getAttributeValue(_class_name);
    }

    private void parseErrorListener(XdmNode xdmNode) {
        String string;
        this.errorListener = string = xdmNode.getAttributeValue(_class_name);
    }

    private void parseImplementation(XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_type);
        String string2 = xdmNode.getAttributeValue(_class_name);
        if (string == null || string2 == null) {
            throw new XProcException(xdmNode, "Unexpected implementation in configuration; must have both type and class-name attributes");
        }
        for (String string3 : string.split("\\s+")) {
            QName qName = new QName(string3, xdmNode);
            this.implementations.put(qName, string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSerialization(XdmNode xdmNode) {
        String[] stringArray = new String[]{"byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "include-content-type", "indent", "media-type", "method", "normalization-form", "omit-xml-declaration", "standalone", "undeclare-prefixes", "version"};
        this.checkAttributes(xdmNode, stringArray, false);
        for (String string : stringArray) {
            QName qName;
            String string2 = xdmNode.getAttributeValue(new QName(string));
            if (string2 == null) continue;
            if ("byte-order-mark".equals(string) || "escape-uri-attributes".equals(string) || "include-content-type".equals(string) || "indent".equals(string) || "omit-xml-declaration".equals(string) || "undeclare-prefixes".equals(string)) {
                this.checkBoolean(xdmNode, string, string2);
                this.serializationOptions.put(string, string2);
            } else if ("method".equals(string)) {
                qName = new QName(string2, xdmNode);
                if (!"".equals(qName.getPrefix())) throw new XProcException(xdmNode, "Configuration error: only the xml, xhtml, html, and text serialization methods are supported.");
                String string3 = qName.getLocalName();
                if (!"html".equals(string3) && !"xhtml".equals(string3) && !"text".equals(string3) && !"xml".equals(string3)) throw new XProcException(xdmNode, "Configuration error: only the xml, xhtml, html, and text serialization methods are supported.");
                this.serializationOptions.put(string, string3);
            } else {
                this.serializationOptions.put(string, string2);
            }
            qName = new RelevantNodes(null, xdmNode, Axis.CHILD).iterator();
            if (!qName.hasNext()) continue;
            XdmNode xdmNode2 = qName.next();
            throw new XProcException(xdmNode, "Configuration error: serialization must be empty");
        }
    }

    /*
     * WARNING - void declaration
     */
    private HashSet<String> checkAttributes(XdmNode xdmNode, String[] stringArray, boolean bl) {
        void var5_7;
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>();
            for (String string : stringArray) {
                hashSet.add(string);
            }
        }
        Object var5_6 = null;
        for (XdmNode xdmNode2 : new RelevantNodes(null, xdmNode, Axis.ATTRIBUTE)) {
            String string;
            string = xdmNode2.getNodeName();
            if ("".equals(string.getNamespaceURI())) {
                if (hashSet.contains(string.getLocalName())) continue;
                if (bl) {
                    if (var5_7 == null) {
                        HashSet hashSet2 = new HashSet();
                    }
                    var5_7.add(string.getLocalName());
                    continue;
                }
                throw new XProcException(xdmNode, "Configuration error: attribute \"" + string + "\" not allowed on " + xdmNode.getNodeName());
            }
            if (!"http://www.w3.org/ns/xproc".equals(string.getNamespaceURI())) continue;
            throw new XProcException(xdmNode, "Configuration error: attribute \"" + string + "\" not allowed on " + xdmNode.getNodeName());
        }
        return var5_7;
    }

    private void checkBoolean(XdmNode xdmNode, String string, String string2) {
        if (string2 != null && !"true".equals(string2) && !"false".equals(string2)) {
            throw new XProcException(xdmNode, "Configuration error: " + string + " on serialization must be 'true' or 'false'");
        }
    }

    private class ConfigDocument
    implements ReadablePipe {
        private String href = null;
        private String base = null;
        private Vector<XdmValue> nodes = null;
        private boolean read = false;
        private XdmNode doc = null;
        private HashSet<String> excludeUris = null;

        public ConfigDocument(String string, String string2) {
            this.href = string;
            this.base = string2;
        }

        public ConfigDocument(Vector<XdmValue> vector, HashSet<String> hashSet) {
            this.nodes = vector;
            this.excludeUris = hashSet;
        }

        @Override
        public void canReadSequence(boolean bl) {
        }

        @Override
        public boolean readSequence() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public XdmNode read() throws SaxonApiException {
            this.read = true;
            if (this.doc != null) {
                return this.doc;
            }
            if (this.nodes != null) {
                XdmNode xdmNode = null;
                for (int i = 0; i < this.nodes.size() && xdmNode == null; ++i) {
                    if (((XdmNode)this.nodes.get(i)).getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    xdmNode = (XdmNode)this.nodes.get(i);
                }
                XdmDestination xdmDestination = new XdmDestination();
                try {
                    S9apiUtils.writeXdmValue(XProcConfiguration.this.cfgProcessor, this.nodes, (Destination)xdmDestination, xdmNode.getBaseURI());
                    this.doc = xdmDestination.getXdmNode();
                    if (this.excludeUris.size() == 0) return this.doc;
                    this.doc = S9apiUtils.removeNamespaces(XProcConfiguration.this.cfgProcessor, this.doc, this.excludeUris, true);
                    return this.doc;
                }
                catch (SaxonApiException saxonApiException) {
                    throw new XProcException(saxonApiException);
                }
            } else {
                this.doc = XProcConfiguration.this.readXML(this.href, this.base);
            }
            return this.doc;
        }

        @Override
        public void setReader(Step step) {
        }

        @Override
        public void resetReader() {
            this.read = false;
        }

        @Override
        public boolean moreDocuments() {
            return !this.read;
        }

        @Override
        public boolean closed() {
            return false;
        }

        @Override
        public int documentCount() {
            return 1;
        }

        @Override
        public DocumentSequence documents() {
            throw new XProcException("You can't get the document sequence of an input from the config file!");
        }
    }
}

