/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.config.XProcConfigurer;
import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.functions.BaseURI;
import com.xmlcalabash.functions.Cwd;
import com.xmlcalabash.functions.IterationPosition;
import com.xmlcalabash.functions.IterationSize;
import com.xmlcalabash.functions.ResolveURI;
import com.xmlcalabash.functions.StepAvailable;
import com.xmlcalabash.functions.SystemProperty;
import com.xmlcalabash.functions.ValueAvailable;
import com.xmlcalabash.functions.VersionAvailable;
import com.xmlcalabash.functions.XPathVersionAvailable;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Parser;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XRootStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.DefaultXProcConfigurer;
import com.xmlcalabash.util.DefaultXProcMessageListener;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.StepErrorListener;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XProcRuntime {
    protected Logger logger = Logger.getLogger("com.xmlcalabash");
    private Processor processor = null;
    private Parser parser = null;
    private XProcURIResolver uriResolver = null;
    private XProcConfiguration config = null;
    private QName errorCode = null;
    private XdmNode errorNode = null;
    private String errorMessage = null;
    private Hashtable<QName, DeclareStep> declaredSteps = new Hashtable();
    private DeclareStep pipeline = null;
    private XPipeline xpipeline = null;
    private static String episode = null;
    private Hashtable<String, Vector<XdmNode>> collections = null;
    private URI staticBaseURI = null;
    private boolean allowGeneralExpressions = true;
    private boolean allowXPointerOnText = true;
    private boolean transparentJSON = false;
    private String jsonFlavor = "marklogic";
    private boolean useXslt10 = false;
    private XProcData xprocData = null;
    private Logger log = null;
    private XProcMessageListener msgListener = null;
    private PipelineLibrary standardLibrary = null;
    private XLibrary xStandardLibrary = null;
    private HttpClient httpClient;
    private Map<String, CookieStore> cookieStores;
    private XProcConfigurer configurer = null;
    private String htmlParser = null;
    private Vector<XProcExtensionFunctionDefinition> exFuncs = new Vector();
    private Output profile = null;
    private Hashtable<XStep, Calendar> profileHash = null;
    private TreeWriter profileWriter = null;
    private QName profileProfile = new QName("http://xmlcalabash.com/ns/profile", "profile");
    private QName profileType = new QName("", "type");
    private QName profileName = new QName("", "name");
    private QName profileTime = new QName("http://xmlcalabash.com/ns/profile", "time");
    private Stack<XStep> runningSteps = new Stack();

    public XProcRuntime(XProcConfiguration xProcConfiguration) {
        Object object2;
        this.config = xProcConfiguration;
        this.processor = xProcConfiguration.getProcessor();
        if (xProcConfiguration.xprocConfigurer != null) {
            try {
                object2 = xProcConfiguration.xprocConfigurer;
                Constructor<?> object3 = Class.forName((String)object2).getConstructor(XProcRuntime.class);
                this.configurer = (XProcConfigurer)object3.newInstance(this);
            }
            catch (Exception exception) {
                throw new XProcException(exception);
            }
        } else {
            this.configurer = new DefaultXProcConfigurer(this);
        }
        this.xprocData = new XProcData(this);
        this.exFuncs.add(new Cwd(this));
        this.exFuncs.add(new BaseURI(this));
        this.exFuncs.add(new ResolveURI(this));
        this.exFuncs.add(new SystemProperty(this));
        this.exFuncs.add(new StepAvailable(this));
        this.exFuncs.add(new IterationSize(this));
        this.exFuncs.add(new IterationPosition(this));
        this.exFuncs.add(new ValueAvailable(this));
        this.exFuncs.add(new VersionAvailable(this));
        this.exFuncs.add(new XPathVersionAvailable(this));
        for (XProcExtensionFunctionDefinition xProcExtensionFunctionDefinition : this.exFuncs) {
            this.processor.registerExtensionFunction((ExtensionFunctionDefinition)xProcExtensionFunctionDefinition);
        }
        this.log = Logger.getLogger(this.getClass().getName());
        object2 = this.processor.getUnderlyingConfiguration();
        this.uriResolver = new XProcURIResolver(this);
        object2.setURIResolver((URIResolver)this.uriResolver);
        this.staticBaseURI = URIUtils.cwdAsURI();
        try {
            if (xProcConfiguration.uriResolver != null) {
                this.uriResolver.setUnderlyingURIResolver((URIResolver)Class.forName(xProcConfiguration.uriResolver).newInstance());
            }
            if (xProcConfiguration.entityResolver != null) {
                this.uriResolver.setUnderlyingEntityResolver((EntityResolver)Class.forName(xProcConfiguration.entityResolver).newInstance());
            }
            this.msgListener = xProcConfiguration.errorListener != null ? (XProcMessageListener)Class.forName(xProcConfiguration.errorListener).newInstance() : new DefaultXProcMessageListener();
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
        this.processor.getUnderlyingConfiguration().setURIResolver((URIResolver)this.uriResolver);
        StepErrorListener stepErrorListener = new StepErrorListener(this);
        object2.setErrorListener((ErrorListener)stepErrorListener);
        this.allowGeneralExpressions = xProcConfiguration.extensionValues;
        this.allowXPointerOnText = xProcConfiguration.xpointerOnText;
        this.transparentJSON = xProcConfiguration.transparentJSON;
        this.jsonFlavor = xProcConfiguration.jsonFlavor;
        this.useXslt10 = xProcConfiguration.useXslt10;
        if (xProcConfiguration.profile != null) {
            this.profile = xProcConfiguration.profile;
            this.profileHash = new Hashtable();
            this.profileWriter = new TreeWriter(this);
            try {
                this.profileWriter.startDocument(new URI("http://xmlcalabash.com/output/profile.xml"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        for (String string : xProcConfiguration.extensionFunctions) {
            try {
                Object obj = Class.forName(string).newInstance();
                this.finer(null, null, "Instantiated: " + string);
                if (obj instanceof ExtensionFunctionDefinition) {
                    this.processor.registerExtensionFunction((ExtensionFunctionDefinition)obj);
                    continue;
                }
                if (obj instanceof ExtensionFunction) {
                    this.processor.registerExtensionFunction((ExtensionFunction)obj);
                    continue;
                }
                this.finer(null, null, "Failed to instantiate extension function " + string + " because that class implements neither ExtensionFunction nor ExtensionFunctionDefinition.");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.finer(null, null, "Failed to instantiate extension function: " + string);
            }
            catch (Exception exception) {
                this.finer(null, null, "Failed to instantiate extension function: " + string);
            }
        }
        this.htmlParser = xProcConfiguration.htmlParser;
        this.reset();
    }

    public XProcRuntime(XProcRuntime xProcRuntime) {
        this.processor = xProcRuntime.processor;
        this.uriResolver = xProcRuntime.uriResolver;
        this.config = xProcRuntime.config;
        this.staticBaseURI = xProcRuntime.staticBaseURI;
        this.useXslt10 = xProcRuntime.useXslt10;
        this.log = xProcRuntime.log;
        this.msgListener = xProcRuntime.msgListener;
        this.standardLibrary = xProcRuntime.standardLibrary;
        this.xStandardLibrary = xProcRuntime.xStandardLibrary;
        this.httpClient = xProcRuntime.httpClient;
        this.cookieStores = xProcRuntime.cookieStores;
        this.configurer = xProcRuntime.configurer;
        this.allowGeneralExpressions = xProcRuntime.allowGeneralExpressions;
        this.allowXPointerOnText = xProcRuntime.allowXPointerOnText;
        this.transparentJSON = xProcRuntime.transparentJSON;
        this.jsonFlavor = xProcRuntime.jsonFlavor;
        this.profile = xProcRuntime.profile;
        this.exFuncs.add(new Cwd(this));
        this.exFuncs.add(new BaseURI(this));
        this.exFuncs.add(new ResolveURI(this));
        this.exFuncs.add(new SystemProperty(this));
        this.exFuncs.add(new StepAvailable(this));
        this.exFuncs.add(new IterationSize(this));
        this.exFuncs.add(new IterationPosition(this));
        this.exFuncs.add(new ValueAvailable(this));
        this.exFuncs.add(new VersionAvailable(this));
        this.exFuncs.add(new XPathVersionAvailable(this));
        this.reset();
    }

    public void resetExtensionFunctions() {
        for (XProcExtensionFunctionDefinition xProcExtensionFunctionDefinition : this.exFuncs) {
            this.processor.registerExtensionFunction((ExtensionFunctionDefinition)xProcExtensionFunctionDefinition);
        }
    }

    public void close() {
        for (XProcExtensionFunctionDefinition xProcExtensionFunctionDefinition : this.exFuncs) {
            xProcExtensionFunctionDefinition.close();
        }
        HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
        this.httpClient = null;
    }

    public XProcConfigurer getConfigurer() {
        return this.configurer;
    }

    public void setConfigurer(XProcConfigurer xProcConfigurer) {
        this.configurer = xProcConfigurer;
    }

    public XProcData getXProcData() {
        return this.xprocData;
    }

    public boolean getDebug() {
        return this.config.debug;
    }

    public Output getProfile() {
        return this.profile;
    }

    public void setProfile(Output output) {
        this.profile = output;
    }

    public URI getStaticBaseURI() {
        return this.staticBaseURI;
    }

    public String getSendmailHost() {
        return this.config.mailHost;
    }

    public String getSendmailPort() {
        return this.config.mailPort;
    }

    public String getSendmailUsername() {
        return this.config.mailUser;
    }

    public String getSendmailPassword() {
        return this.config.mailPass;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver.setUnderlyingURIResolver(uRIResolver);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.uriResolver.setUnderlyingEntityResolver(entityResolver);
    }

    public XProcURIResolver getResolver() {
        return this.uriResolver;
    }

    public XProcMessageListener getMessageListener() {
        return this.msgListener;
    }

    public void setMessageListener(XProcMessageListener xProcMessageListener) {
        this.msgListener = xProcMessageListener;
    }

    public void setCollection(URI uRI, Vector<XdmNode> vector) {
        if (this.collections == null) {
            this.collections = new Hashtable();
        }
        this.collections.put(uRI.toASCIIString(), vector);
    }

    public Vector<XdmNode> getCollection(URI uRI) {
        if (this.collections == null) {
            return null;
        }
        if (this.collections.containsKey(uRI.toASCIIString())) {
            return this.collections.get(uRI.toASCIIString());
        }
        return null;
    }

    public boolean getSafeMode() {
        return this.config.safeMode;
    }

    public boolean getAllowGeneralExpressions() {
        return this.allowGeneralExpressions;
    }

    public boolean getAllowXPointerOnText() {
        return this.allowXPointerOnText;
    }

    public boolean transparentJSON() {
        return this.transparentJSON;
    }

    public String jsonFlavor() {
        return this.jsonFlavor;
    }

    public String htmlParser() {
        return this.htmlParser;
    }

    public boolean getUseXslt10Processor() {
        return this.useXslt10;
    }

    public void cache(XdmNode xdmNode, URI uRI) {
        this.uriResolver.cache(xdmNode, uRI);
    }

    public XProcConfiguration getConfiguration() {
        return this.config;
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getEpisode() {
        if (episode == null) {
            MessageDigest messageDigest = null;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw XProcException.dynamicError(36);
            }
            byte[] byArray = messageDigest.digest(gregorianCalendar.toString().getBytes());
            episode = "CB";
            for (byte by : byArray) {
                episode = episode + Integer.toHexString(by & 0xFF);
            }
        }
        return episode;
    }

    public String getLanguage() {
        return Locale.getDefault().toString().replace('_', '-');
    }

    public String getProductName() {
        return "XML Calabash";
    }

    public String getProductVersion() {
        String string = this.processor.getSaxonProductVersion();
        String string2 = this.processor.getUnderlyingConfiguration().getEditionCode();
        return XProcConstants.XPROC_VERSION + " (for Saxon " + string + "/" + string2 + ")";
    }

    public String getVendor() {
        return "Norman Walsh";
    }

    public String getVendorURI() {
        return "http://xmlcalabash.com/";
    }

    public String getXProcVersion() {
        return "1.0";
    }

    public String getXPathVersion() {
        return "2.0";
    }

    public boolean getPSVISupported() {
        return this.config.schemaAware;
    }

    public XLibrary getStandardLibrary() {
        if (this.xStandardLibrary == null) {
            this.xStandardLibrary = new XLibrary(this, this.standardLibrary);
            if (this.errorCode != null) {
                throw new XProcException(this.errorCode, this.errorMessage);
            }
        }
        return this.xStandardLibrary;
    }

    private synchronized void reset() {
        this.errorCode = null;
        this.errorMessage = null;
        this.declaredSteps = new Hashtable();
        this.pipeline = null;
        this.xpipeline = null;
        episode = null;
        this.collections = null;
        this.cookieStores = new HashMap<String, CookieStore>();
        this.xprocData = new XProcData(this);
        this.parser = new Parser(this);
        try {
            this.standardLibrary = this.parser.loadStandardLibrary();
            if (this.errorCode != null) {
                throw new XProcException(this.errorCode, this.errorMessage);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)fileNotFoundException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)uRISyntaxException);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)saxonApiException);
        }
        if (this.profile != null) {
            this.profileHash = new Hashtable();
            this.profileWriter = new TreeWriter(this);
            try {
                this.profileWriter.startDocument(new URI("http://xmlcalabash.com/output/profile.xml"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public XPipeline load(Input input) throws SaxonApiException {
        String string;
        switch (input.getKind()) {
            case URI: {
                string = input.getUri();
                break;
            }
            case INPUT_STREAM: {
                string = input.getInputStreamUri();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported pipeline kind '%s'", new Object[]{input.getKind()}));
            }
        }
        for (String string2 : this.config.loaders.keySet()) {
            boolean bl = string2.startsWith("data:");
            String string3 = string2.substring(5);
            if (!string.matches(string3)) continue;
            return this.runPipelineLoader(input, this.config.loaders.get(string2), bl);
        }
        try {
            return this._load(input);
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw new XProcException(iOException);
        }
    }

    private XPipeline _load(Input input) throws SaxonApiException, IOException {
        this.reset();
        this.configurer.getXMLCalabashConfigurer().configRuntime(this);
        switch (input.getKind()) {
            case URI: {
                this.pipeline = this.parser.loadPipeline(input.getUri());
                break;
            }
            case INPUT_STREAM: {
                this.pipeline = this.parser.loadPipeline(input.getInputStream());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported pipeline kind '%s'", new Object[]{input.getKind()}));
            }
        }
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XRootStep xRootStep = new XRootStep(this);
        DeclareStep declareStep = this.pipeline.getDeclaration();
        declareStep.setup();
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorNode, this.errorMessage);
        }
        this.xpipeline = new XPipeline(this, this.pipeline, xRootStep);
        this.xpipeline.instantiate(declareStep);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return this.xpipeline;
    }

    public XPipeline use(XdmNode xdmNode) throws SaxonApiException {
        try {
            return this._use(xdmNode);
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
    }

    private XPipeline _use(XdmNode xdmNode) throws SaxonApiException {
        this.reset();
        this.configurer.getXMLCalabashConfigurer().configRuntime(this);
        this.pipeline = this.parser.usePipeline(xdmNode);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XRootStep xRootStep = new XRootStep(this);
        DeclareStep declareStep = this.pipeline.getDeclaration();
        declareStep.setup();
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        this.xpipeline = new XPipeline(this, this.pipeline, xRootStep);
        this.xpipeline.instantiate(declareStep);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return this.xpipeline;
    }

    public XLibrary loadLibrary(Input input) throws SaxonApiException {
        String string;
        switch (input.getKind()) {
            case URI: {
                string = input.getUri();
                break;
            }
            case INPUT_STREAM: {
                string = input.getInputStreamUri();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported library kind '%s'", new Object[]{input.getKind()}));
            }
        }
        for (String string2 : this.config.loaders.keySet()) {
            boolean bl = string2.startsWith("data:");
            String string3 = string2.substring(5);
            if (!string.matches(string3)) continue;
            return this.runLibraryLoader(input, this.config.loaders.get(string2), bl);
        }
        try {
            return this._loadLibrary(input);
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw new XProcException(iOException);
        }
    }

    private XLibrary _loadLibrary(Input input) throws SaxonApiException, IOException {
        PipelineLibrary pipelineLibrary;
        switch (input.getKind()) {
            case URI: {
                pipelineLibrary = this.parser.loadLibrary(input.getUri());
                break;
            }
            case INPUT_STREAM: {
                pipelineLibrary = this.parser.loadLibrary(input.getInputStream());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported library kind '%s'", new Object[]{input.getKind()}));
            }
        }
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XLibrary xLibrary = new XLibrary(this, pipelineLibrary);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return xLibrary;
    }

    public XLibrary useLibrary(XdmNode xdmNode) throws SaxonApiException {
        try {
            return this._useLibrary(xdmNode);
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
    }

    private XLibrary _useLibrary(XdmNode xdmNode) throws SaxonApiException {
        PipelineLibrary pipelineLibrary = this.parser.useLibrary(xdmNode);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XLibrary xLibrary = new XLibrary(this, pipelineLibrary);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return xLibrary;
    }

    private XPipeline runPipelineLoader(Input input, String string, boolean bl) throws SaxonApiException {
        XdmNode xdmNode = this.runLoader(input, string, bl);
        return this.use(xdmNode);
    }

    private XLibrary runLibraryLoader(Input input, String string, boolean bl) throws SaxonApiException {
        XdmNode xdmNode = this.runLoader(input, string, bl);
        return this.useLibrary(xdmNode);
    }

    private XdmNode runLoader(Input input, String string, boolean bl) throws SaxonApiException {
        ReadablePipe readablePipe;
        XPipeline xPipeline = null;
        try {
            xPipeline = this._load(new Input(string));
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
        catch (IOException iOException) {
            this.error(iOException);
            throw new XProcException(iOException);
        }
        XdmNode xdmNode = null;
        switch (input.getKind()) {
            case URI: {
                if (bl) {
                    readablePipe = new ReadableData(this, XProcConstants.c_result, this.getStaticBaseURI().resolve(input.getUri()).toASCIIString(), "text/plain");
                    xdmNode = ((ReadableData)readablePipe).read();
                    break;
                }
                xdmNode = this.parse(input.getUri(), this.getStaticBaseURI().toASCIIString());
                break;
            }
            case INPUT_STREAM: {
                if (bl) {
                    readablePipe = new ReadableData(this, XProcConstants.c_result, input.getInputStream(), "text/plain");
                    xdmNode = ((ReadableData)readablePipe).read();
                    break;
                }
                xdmNode = this.parse(new InputSource(input.getInputStream()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported pipeline kind '%s'", new Object[]{input.getKind()}));
            }
        }
        xPipeline.clearInputs("source");
        xPipeline.writeTo("source", xdmNode);
        xPipeline.run();
        readablePipe = xPipeline.readFrom("result");
        xdmNode = readablePipe.read();
        this.reset();
        return xdmNode;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public XdmNode parse(String string, String string2) {
        return this.parse(string, string2, false);
    }

    public XdmNode parse(String string, String string2, boolean bl) {
        return this.uriResolver.parse(string, string2, bl);
    }

    public XdmNode parse(InputSource inputSource) {
        return this.uriResolver.parse(inputSource);
    }

    public void declareStep(QName qName, DeclareStep declareStep) {
        if (this.declaredSteps.containsKey(qName)) {
            throw new XProcException((Step)declareStep, "Duplicate declaration for " + qName);
        }
        this.declaredSteps.put(qName, declareStep);
    }

    public DeclareStep getBuiltinDeclaration(QName qName) {
        if (this.declaredSteps.containsKey(qName)) {
            return this.declaredSteps.get(qName);
        }
        throw XProcException.staticError(44, null, "Unexpected step name: " + qName);
    }

    public synchronized CookieStore getCookieStore(String string) {
        if (this.cookieStores.containsKey(string)) {
            return this.cookieStores.get(string);
        }
        BasicCookieStore basicCookieStore = new BasicCookieStore();
        this.cookieStores.put(string, (CookieStore)basicCookieStore);
        return basicCookieStore;
    }

    public synchronized void setCookieStore(String string, CookieStore cookieStore) {
        if (cookieStore == null) {
            this.removeCookieStore(string);
        } else {
            this.cookieStores.put(string, cookieStore);
        }
    }

    public synchronized void removeCookieStore(String string) {
        this.cookieStores.remove(string);
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            SystemDefaultHttpClient systemDefaultHttpClient = new SystemDefaultHttpClient();
            systemDefaultHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, false));
            this.httpClient = systemDefaultHttpClient;
            return this.httpClient;
        }
        return this.httpClient;
    }

    public synchronized void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public QName getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void error(XProcRunnable xProcRunnable, XdmNode xdmNode, String string, QName qName) {
        if (this.errorCode == null) {
            this.errorCode = qName;
            this.errorNode = xdmNode;
            this.errorMessage = string;
        }
        this.msgListener.error(xProcRunnable, xdmNode, string, qName);
    }

    public void error(Throwable throwable) {
        this.msgListener.error(throwable);
    }

    public void warning(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.warning(xProcRunnable, xdmNode, string);
    }

    public void warning(Throwable throwable) {
        this.msgListener.warning(throwable);
    }

    public void info(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.info(xProcRunnable, xdmNode, string);
    }

    public void fine(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.fine(xProcRunnable, xdmNode, string);
    }

    public void finer(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.finer(xProcRunnable, xdmNode, string);
    }

    public void finest(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.finest(xProcRunnable, xdmNode, string);
    }

    public void start(XStep xStep) {
        Object object;
        this.runningSteps.push(xStep);
        if (this.profile == null) {
            return;
        }
        boolean bl = this.profileHash.isEmpty();
        Calendar calendar = GregorianCalendar.getInstance();
        this.profileHash.put(xStep, calendar);
        this.profileWriter.addStartElement(this.profileProfile);
        if (bl) {
            object = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.profileWriter.addAttribute(new QName("", "timestamp"), ((DateFormat)object).format(new Date()));
            this.profileWriter.addAttribute(new QName("", "episode"), this.getEpisode());
            this.profileWriter.addAttribute(new QName("", "language"), this.getLanguage());
            this.profileWriter.addAttribute(new QName("", "product-name"), this.getProductName());
            this.profileWriter.addAttribute(new QName("", "product-version"), this.getProductVersion());
            this.profileWriter.addAttribute(new QName("", "product-vendor"), this.getVendor());
            this.profileWriter.addAttribute(new QName("", "product-vendor-uri"), this.getVendorURI());
            this.profileWriter.addAttribute(new QName("", "xproc-version"), this.getXProcVersion());
            this.profileWriter.addAttribute(new QName("", "xpath-version"), this.getXPathVersion());
            this.profileWriter.addAttribute(new QName("", "psvi-supported"), "" + this.getPSVISupported());
        }
        object = xStep.getType().getClarkName();
        this.profileWriter.addAttribute(this.profileType, (String)object);
        this.profileWriter.addAttribute(this.profileName, xStep.getStep().getName());
        this.profileWriter.startContent();
    }

    public XStep runningStep() {
        return this.runningSteps.peek();
    }

    public void finish(XStep xStep) {
        this.runningSteps.pop();
        if (this.profile == null) {
            return;
        }
        Calendar calendar = this.profileHash.get(xStep);
        long l = GregorianCalendar.getInstance().getTimeInMillis() - calendar.getTimeInMillis();
        this.profileHash.remove(xStep);
        this.profileWriter.addStartElement(this.profileTime);
        this.profileWriter.startContent();
        this.profileWriter.addText("" + l);
        this.profileWriter.addEndElement();
        this.profileWriter.addEndElement();
        if (this.profileHash.isEmpty()) {
            this.profileWriter.endDocument();
            XdmNode xdmNode = this.profileWriter.getResult();
            InputStream inputStream = this.getClass().getResourceAsStream("/etc/patch-profile.xsl");
            if (inputStream == null) {
                throw new UnsupportedOperationException("Failed to load profile_patch.xsl from JAR file.");
            }
            try {
                XsltCompiler xsltCompiler = this.getProcessor().newXsltCompiler();
                xsltCompiler.setSchemaAware(false);
                XsltExecutable xsltExecutable = xsltCompiler.compile((Source)new SAXSource(new InputSource(inputStream)));
                XsltTransformer xsltTransformer = xsltExecutable.load();
                xsltTransformer.setInitialContextNode(xdmNode);
                XdmDestination xdmDestination = new XdmDestination();
                xsltTransformer.setDestination((Destination)xdmDestination);
                xsltTransformer.transform();
                Serializer serializer = new Serializer();
                serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                OutputStream outputStream = null;
                switch (this.profile.getKind()) {
                    case URI: {
                        URI uRI = URI.create(this.profile.getUri());
                        outputStream = new FileOutputStream(new File(uRI));
                        break;
                    }
                    case OUTPUT_STREAM: {
                        outputStream = this.profile.getOutputStream();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported profile kind '%s'", new Object[]{this.profile.getKind()}));
                    }
                }
                serializer.setOutputStream(outputStream);
                S9apiUtils.serialize(this, xdmDestination.getXdmNode(), serializer);
                if (!System.out.equals(outputStream) && !System.err.equals(outputStream)) {
                    outputStream.close();
                }
                this.profileWriter = new TreeWriter(this);
                this.profileWriter.startDocument(URI.create("http://xmlcalabash.com/output/profile.xml"));
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XProcException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new XProcException(iOException);
            }
        }
    }
}

