/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.drivers.Main;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.UserArgs;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;

public class CalabashTask
extends MatchingTask {
    private UserArgs userArgs = new UserArgs();
    private Map<String, List<TypedResource>> inputResources = new HashMap<String, List<TypedResource>>();
    private Map<String, TypedFileNameMapper> inputMappers = new HashMap<String, TypedFileNameMapper>();
    private File baseDir = null;
    private String inPort = null;
    private Resource inResource = null;
    private Input.Type inType = Input.Type.XML;
    private boolean failOnNoResources = true;
    private Resource pipelineResource = null;
    private File destDir = null;
    private String outPort = null;
    private Resource outResource = null;
    private HashMap<String, Union> outputResources = new HashMap();
    private Map<String, FileNameMapper> outputMappers = new HashMap<String, FileNameMapper>();
    private String targetExtension = "-out.xml";
    private boolean isTargetExtensionSet = false;
    private boolean failOnError = true;
    private Union resources = new Union();
    private boolean useImplicitFileset = true;
    private boolean performDirectoryScan = true;
    private FileNameMapper mapper = null;
    private boolean force = false;
    private CommandlineJava.SysProperties sysProperties = new CommandlineJava.SysProperties();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<Option> options = new ArrayList<Option>();
    private List<Step> steps = new ArrayList<Step>();

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setInPort(String string) {
        this.inPort = string;
    }

    public void setIn(Resource resource) {
        this.inResource = resource;
    }

    public void setInType(Input.Type type) {
        this.inType = type;
    }

    public void addConfiguredInput(Input input) {
        if (!input.shouldUse()) {
            this.log("Skipping input '" + input.getPort() + "' as it is configured to be unused.", 4);
            return;
        }
        String string = input.getPort();
        FileNameMapper fileNameMapper = input.getMapper();
        Union union = input.getResources();
        if (string == null) {
            string = this.inPort;
        }
        if (fileNameMapper != null) {
            if (union.size() != 0) {
                this.handleError("Both mapper and fileset on input port: " + string);
                return;
            }
            if (string.equals(this.inPort)) {
                this.handleError("Cannot use mapper on main input port: " + string);
                return;
            }
            if (this.inputResources.containsKey(string)) {
                this.handleError("Mapper used on input port that already has resources: " + string);
                return;
            }
            if (this.inputMappers.containsKey(string)) {
                this.handleError("Mapper used on input port that already has a mapper: " + string);
                return;
            }
            this.inputMappers.put(string, new TypedFileNameMapper(fileNameMapper, input.getType(), input.getContentType()));
        } else {
            if (this.inputMappers.containsKey(string)) {
                this.handleError("Resources used on input port that already has a mapper: " + string);
                return;
            }
            if (union.size() != 0 && !this.inputResources.containsKey(string)) {
                this.inputResources.put(string, new ArrayList());
            }
            for (Resource resource : union.listResources()) {
                this.inputResources.get(string).add(new TypedResource(resource, input.getType(), input.getContentType()));
            }
        }
    }

    public void setFailOnNoResources(boolean bl) {
        this.failOnNoResources = bl;
    }

    public void setPipeline(Resource resource) {
        try {
            this.userArgs.setPipeline(resource.getInputStream(), resource.toString());
            this.pipelineResource = resource;
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void addConfiguredPipeline(UseableResources useableResources) {
        if (!useableResources.shouldUse()) {
            this.log("Skipping pipeline as it is configured to be unused.", 4);
            return;
        }
        if (useableResources.size() == 0) {
            return;
        }
        if (useableResources.size() > 1) {
            this.handleError("The pipeline element must be specified with at most one nested resource.");
        }
        this.setPipeline((Resource)useableResources.iterator().next());
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setOutPort(String string) {
        this.outPort = string;
    }

    public void setOut(Resource resource) {
        this.outResource = resource;
    }

    public void addConfiguredOutput(Port port) {
        if (!port.shouldUse()) {
            this.log("Skipping output '" + port.getPort() + "' as it is configured to be unused.", 4);
            return;
        }
        String string = port.getPort();
        FileNameMapper fileNameMapper = port.getMapper();
        Union union = port.getResources();
        if (string == null) {
            string = this.outPort;
        }
        if (fileNameMapper != null && union.size() != 0) {
            this.handleError("Both mapper and fileset on output port: " + string);
            return;
        }
        if (fileNameMapper != null) {
            if (this.outputResources.containsKey(string)) {
                this.handleError("Mapper used on output port that already has resources: " + string);
                return;
            }
            if (this.outputMappers.containsKey(string)) {
                this.handleError("Mapper used on output port that already has a mapper: " + string);
                return;
            }
            this.outputMappers.put(string, fileNameMapper);
        } else {
            if (this.outputMappers.containsKey(string)) {
                this.handleError("Resources used on output port that already has a mapper: " + string);
                return;
            }
            if (!this.outputResources.containsKey(string)) {
                this.outputResources.put(string, new Union());
            }
            this.outputResources.get(string).add((ResourceCollection)union);
        }
    }

    public void setExtension(String string) {
        this.targetExtension = string;
        this.isTargetExtensionSet = true;
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    public void setUseImplicitFileset(boolean bl) {
        this.useImplicitFileset = bl;
    }

    public void setScanIncludedDirectories(boolean bl) {
        this.performDirectoryScan = bl;
    }

    public void addMapper(Mapper mapper) throws BuildException {
        this.add(mapper.getImplementation());
    }

    public void add(FileNameMapper fileNameMapper) throws BuildException {
        if (this.mapper != null) {
            this.handleError("Cannot define more than one mapper");
            return;
        }
        this.mapper = fileNameMapper;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void addSysproperty(Environment.Variable variable) {
        this.sysProperties.addVariable(variable);
    }

    public void addSyspropertyset(PropertySet propertySet) {
        this.sysProperties.addSyspropertyset(propertySet);
    }

    public void addConfiguredNamespace(Namespace namespace) {
        if (!namespace.shouldUse()) {
            this.log("Skipping namespace '" + namespace.getPrefix() + "=" + namespace.getURI() + "' as it is configured to be unused.", 4);
            return;
        }
        if (namespace.getPrefix() == null) {
            this.handleError("<namespace> prefix cannot be null");
            return;
        }
        if (namespace.getURI() == null) {
            this.handleError("<namespace> URI cannot be null");
            return;
        }
        try {
            this.userArgs.addBinding(namespace.getPrefix(), namespace.getURI());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void addConfiguredOption(Option option) {
        if (!option.shouldUse()) {
            this.log("Skipping option '" + option.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        this.options.add(option);
    }

    public void useOption(Option option) {
        if (!option.shouldUse()) {
            this.log("Skipping option '" + option.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        try {
            this.userArgs.addOption(option.getName(), option.getValue());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void addConfiguredParameter(Parameter parameter) {
        if (!parameter.shouldUse()) {
            this.log("Skipping parameter '" + parameter.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        this.parameters.add(parameter);
    }

    public void useParameter(Parameter parameter) {
        if (!parameter.shouldUse()) {
            this.log("Skipping parameter '" + parameter.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        try {
            this.userArgs.addParam(parameter.getPort(), parameter.getName(), parameter.getValue());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setDebug(boolean bl) {
        try {
            this.userArgs.setDebug(bl);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setGeneralValues(boolean bl) {
        try {
            this.userArgs.setExtensionValues(bl);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setXPointerOnText(boolean bl) {
        try {
            this.userArgs.setAllowXPointerOnText(bl);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setUseXslt10(boolean bl) {
        try {
            this.userArgs.setUseXslt10(bl);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setTransparentJSON(boolean bl) {
        try {
            this.userArgs.setTransparentJSON(bl);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setJSONFlavor(String string) {
        try {
            this.userArgs.setJsonFlavor(string);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setProfileFile(Resource resource) {
        try {
            this.userArgs.setProfile(resource.getOutputStream());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void addConfiguredProfile(UseableResources useableResources) {
        if (!useableResources.shouldUse()) {
            this.log("Skipping profile as it is configured to be unused.", 4);
            return;
        }
        if (useableResources.size() == 0) {
            return;
        }
        if (useableResources.size() > 1) {
            this.handleError("The profile element must be specified with at most one nested resource.");
        }
        this.setProfileFile((Resource)useableResources.iterator().next());
    }

    public void setSaxonProcessor(String string) {
        try {
            this.userArgs.setSaxonProcessor(string);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setSaxonConfigFile(Resource resource) {
        try {
            this.userArgs.setSaxonConfig(resource.getInputStream(), resource.toString());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void addConfiguredSaxonConfig(UseableResources useableResources) {
        if (!useableResources.shouldUse()) {
            this.log("Skipping saxonConfig as it is configured to be unused.", 4);
            return;
        }
        if (useableResources.size() == 0) {
            return;
        }
        if (useableResources.size() > 1) {
            this.handleError("The saxonConfig element must be specified with at most one nested resource.");
        }
        this.setSaxonConfigFile((Resource)useableResources.iterator().next());
    }

    public void setSchemaAware(boolean bl) {
        try {
            this.userArgs.setSchemaAware(bl);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setSafeMode(boolean bl) {
        try {
            this.userArgs.setSafeMode(bl);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setConfigFile(Resource resource) {
        try {
            this.userArgs.setConfig(resource.getInputStream(), resource.toString());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void addConfiguredConfig(UseableResources useableResources) {
        if (!useableResources.shouldUse()) {
            this.log("Skipping config as it is configured to be unused.", 4);
            return;
        }
        if (useableResources.size() == 0) {
            return;
        }
        if (useableResources.size() > 1) {
            this.handleError("The config element must be specified with at most one nested resource.");
        }
        this.setConfigFile((Resource)useableResources.iterator().next());
    }

    public void setLogStyle(String string) {
        try {
            this.userArgs.setLogStyle(string);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setEntityResolver(Class clazz) {
        try {
            this.userArgs.setEntityResolverClass(clazz.getName());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void setURIResolver(Class clazz) {
        try {
            this.userArgs.setUriResolverClass(clazz.getName());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void addConfiguredLibrary(UseableResources useableResources) {
        if (!useableResources.shouldUse()) {
            this.log("Skipping library as it is configured to be unused.", 4);
            return;
        }
        try {
            Iterator iterator = useableResources.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                this.userArgs.addLibrary(resource.getInputStream(), resource.toString());
            }
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void addConfiguredStep(Step step) {
        if (!step.shouldUse()) {
            this.log("Skipping step '" + step.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        if (step.getName() == null) {
            this.handleError("Steps must have their 'name' attribute set");
        }
        this.steps.add(step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public void execute() {
        if (!(this.inResource == null && this.resources.size() == 0 && this.inputResources.isEmpty() && this.inputMappers.isEmpty() || this.steps.isEmpty())) {
            this.handleError("if steps are given, only active inputs nested in these steps are supported");
        }
        if (!this.parameters.isEmpty() && !this.steps.isEmpty()) {
            this.handleError("if steps are given, only active parameters nested in these steps are supported");
        }
        if (!this.options.isEmpty() && !this.steps.isEmpty()) {
            this.handleError("if steps are given, only active options nested in these steps are supported");
        }
        if (this.pipelineResource != null && !this.pipelineResource.isExists()) {
            this.handleError("pipeline '" + this.pipelineResource.getName() + "' does not exist");
            return;
        }
        if (this.inResource != null && !this.inResource.isExists()) {
            this.handleError("input file '" + this.inResource.getName() + "' does not exist");
            return;
        }
        if (this.inResource != null && this.resources.size() != 0) {
            this.handleError("'in' and explicit filesets cannot be used together.");
            return;
        }
        if ((this.inResource != null || this.outResource != null) && this.useImplicitFileset) {
            this.log("'in' and/or 'out' cannot be used with implicit fileset: ignoring implicit fileset.", 3);
            this.useImplicitFileset = false;
        }
        if (!this.steps.isEmpty() && this.useImplicitFileset) {
            this.log("steps cannot be used with implicit fileset: ignoring implicit fileset.", 3);
            this.useImplicitFileset = false;
        }
        if (this.outResource != null && this.mapper != null) {
            this.handleError("Nested <mapper> for default output and 'out' cannot be used together.");
            return;
        }
        if ((this.outputMappers.containsKey(this.outPort) || this.outputResources.containsKey(this.outPort)) && this.mapper != null) {
            this.handleError("Nested <mapper> and port for default output cannot be used together.");
            return;
        }
        if (this.outResource != null && this.isTargetExtensionSet) {
            this.handleError("'extension' and 'out' cannot be used together.");
            return;
        }
        if (this.isTargetExtensionSet && this.mapper != null) {
            this.handleError("'extension' and nested <mapper> cannot be used together.");
            return;
        }
        try {
            Object object3;
            Object object2;
            if (this.baseDir == null) {
                this.baseDir = this.getProject().getBaseDir();
            }
            if (this.sysProperties.size() > 0) {
                this.sysProperties.setSystem();
            }
            this.checkDest();
            if (this.inResource != null) {
                object2 = new Input();
                ((Port)object2).setPort(this.inPort);
                ((Port)object2).add((ResourceCollection)this.inResource);
                ((Input)object2).setType(this.inType);
                this.addConfiguredInput((Input)object2);
            }
            if (this.outResource != null) {
                object2 = new Port();
                ((Port)object2).setPort(this.outPort);
                ((Port)object2).add((ResourceCollection)this.outResource);
                this.addConfiguredOutput((Port)object2);
            }
            if (this.outputResources.containsKey(this.outPort) && (this.isTargetExtensionSet || this.mapper != null)) {
                this.handleError("Either 'out' or <output> corresponding to default output port and either 'extension' or nested <mapper> for naming output cannot be used together.");
                return;
            }
            for (Object object3 : this.parameters) {
                this.useParameter((Parameter)object3);
            }
            for (Object object3 : this.options) {
                this.useOption((Option)object3);
            }
            if (!this.useImplicitFileset && this.resources.size() == 0) {
                String[] stringArray;
                FileNameMapper fileNameMapper;
                object2 = new HashMap();
                object2.putAll(this.inputResources);
                for (Object object4 : this.inputMappers.keySet()) {
                    Object object5 = this.inputMappers.get(object4);
                    for (Object object6 : this.inputResources.get(this.inPort)) {
                        fileNameMapper = ((TypedFileNameMapper)object5).mapFileName(((TypedResource)object6).getResource().getName());
                        if (fileNameMapper == null) continue;
                        stringArray = new ArrayList();
                        for (FileNameMapper fileNameMapper2 : fileNameMapper) {
                            Object object7 = new FileResource(this.baseDir, (String)fileNameMapper2);
                            if (object7.isExists()) {
                                stringArray.add(new TypedResource((Resource)object7, ((TypedFileNameMapper)object5).getType(), ((TypedFileNameMapper)object5).getContentType()));
                                continue;
                            }
                            this.log("Skipping non-exstent mapped resource: " + object7.toString(), 4);
                        }
                        object2.put(object4, stringArray);
                    }
                }
                object3 = new HashMap();
                ((HashMap)object3).putAll(this.outputResources);
                if (this.outputMappers.size() != 0) {
                    for (Object object5 : this.inputResources.get(this.inPort)) {
                        for (Object object6 : this.outputMappers.keySet()) {
                            fileNameMapper = this.outputMappers.get(object6);
                            stringArray = fileNameMapper.mapFileName(((TypedResource)object5).getResource().getName());
                            if (stringArray == null) continue;
                            FileNameMapper fileNameMapper3 = new Union();
                            for (Object object7 : stringArray) {
                                fileNameMapper3.add((ResourceCollection)new FileResource(this.destDir, (String)object7));
                            }
                            ((HashMap)object3).put(object6, fileNameMapper3);
                        }
                    }
                }
                this.process((Map<String, List<TypedResource>>)object2, (Map<String, Union>)object3);
            } else {
                if (this.useImplicitFileset) {
                    object2 = this.getDirectoryScanner(this.baseDir);
                    this.log("Pipelining into " + this.destDir, 2);
                    object3 = object2.getIncludedFiles();
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        this.resources.add((ResourceCollection)new FileResource(this.baseDir, (String)object3[i]));
                    }
                    if (this.performDirectoryScan) {
                        String[] stringArray = object2.getIncludedDirectories();
                        for (int i = 0; i < stringArray.length; ++i) {
                            object3 = new File(this.baseDir, stringArray[i]).list();
                            for (int j = 0; j < ((Object)object3).length; ++j) {
                                this.resources.add((ResourceCollection)new FileResource(this.baseDir, stringArray[i] + File.separator + (String)object3[j]));
                            }
                        }
                    }
                } else if (this.resources.size() == 0) {
                    if (this.failOnNoResources) {
                        this.handleError("no resources specified");
                    }
                    return;
                }
                object2 = null;
                if (!this.outputResources.containsKey(this.outPort)) {
                    object2 = this.mapper != null ? this.mapper : new ExtensionMapper();
                }
                for (Resource resource : this.resources.listResources()) {
                    String[] stringArray;
                    FileNameMapper fileNameMapper;
                    Object object8;
                    Object object92;
                    this.log("Resource: " + resource.getName(), 4);
                    HashMap<String, List<TypedResource>> hashMap = new HashMap<String, List<TypedResource>>();
                    hashMap.putAll(this.inputResources);
                    hashMap.put(this.inPort, Arrays.asList(new TypedResource(resource, this.inType)));
                    for (Object object92 : this.inputMappers.keySet()) {
                        object8 = this.inputMappers.get(object92);
                        fileNameMapper = ((TypedFileNameMapper)object8).mapFileName(resource.getName());
                        if (fileNameMapper == null) continue;
                        stringArray = new ArrayList();
                        for (FileNameMapper fileNameMapper4 : fileNameMapper) {
                            Object object10 = new FileResource(this.baseDir, (String)fileNameMapper4);
                            stringArray.add(new TypedResource((Resource)object10, ((TypedFileNameMapper)object8).getType(), ((TypedFileNameMapper)object8).getContentType()));
                        }
                        hashMap.put((String)object92, (List<TypedResource>)stringArray);
                    }
                    HashMap hashMap2 = new HashMap();
                    hashMap2.putAll(this.outputResources);
                    if (object2 != null) {
                        object92 = object2.mapFileName(resource.getName());
                        if (object92 == null || ((Object)object92).length == 0) {
                            this.log("Skipping '" + resource.getName() + "' as it cannot be mapped to output.", 3);
                            continue;
                        }
                        if (object92 == null || ((Object)object92).length > 1) {
                            this.log("Skipping " + resource.getName() + " as its mapping is ambiguous.", 3);
                            continue;
                        }
                        hashMap2.put(this.outPort, new Union((ResourceCollection)new FileResource(this.destDir, (String)object92[0])));
                    }
                    object92 = this.outputMappers.keySet().iterator();
                    while (object92.hasNext()) {
                        object8 = (String)object92.next();
                        fileNameMapper = this.outputMappers.get(object8);
                        stringArray = fileNameMapper.mapFileName(resource.getName());
                        if (stringArray == null) continue;
                        FileNameMapper fileNameMapper5 = new Union();
                        for (Object object10 : stringArray) {
                            fileNameMapper5.add((ResourceCollection)new FileResource(this.destDir, (String)object10));
                        }
                        hashMap2.put(object8, fileNameMapper5);
                    }
                    this.process(hashMap, hashMap2);
                }
            }
        }
        finally {
            this.userArgs = new UserArgs();
            this.inputResources.clear();
            this.inputMappers.clear();
            this.baseDir = null;
            this.inPort = null;
            this.inResource = null;
            this.inType = Input.Type.XML;
            this.failOnNoResources = true;
            this.pipelineResource = null;
            this.destDir = null;
            this.outPort = null;
            this.outResource = null;
            this.outputResources.clear();
            this.outputMappers.clear();
            this.targetExtension = "-out.xml";
            this.isTargetExtensionSet = false;
            this.failOnError = true;
            this.resources = new Union();
            this.useImplicitFileset = true;
            this.performDirectoryScan = true;
            this.mapper = null;
            this.force = false;
            if (this.sysProperties.size() > 0) {
                this.sysProperties.restoreSystem();
                this.sysProperties = new CommandlineJava.SysProperties();
            }
            this.parameters.clear();
            this.options.clear();
            this.steps.clear();
        }
    }

    private void process(Map<String, List<TypedResource>> map, Map<String, Union> map2) throws BuildException {
        Object object;
        if (!this.force && this.pipelineResource != null) {
            long l = this.pipelineResource.getLastModified();
            l = l == 0L ? Long.MAX_VALUE : l;
            object = new Vector();
            for (String string : map.keySet()) {
                for (TypedResource typedResource : map.get(string)) {
                    long l2 = typedResource.getResource().getLastModified();
                    object.add(l2 == 0L ? Long.MAX_VALUE : l2);
                }
            }
            long l3 = object.isEmpty() ? Long.MAX_VALUE : (Long)Collections.max(object);
            Vector vector = new Vector();
            for (String string : map2.keySet()) {
                for (Resource resource : map2.get(string).listResources()) {
                    vector.add(resource.getLastModified());
                }
            }
            long l4 = vector.isEmpty() ? 0L : (Long)Collections.min(vector);
            this.log("Newest input time: " + l3, 4);
            this.log("Oldest output time: " + l4, 4);
            this.log("Pipeline file " + this.pipelineResource + " time: " + l, 4);
            if (l3 <= l4 && l <= l4) {
                this.log("Skipping because all outputs are newer than inputs and newer than pipeline", 4);
                return;
            }
        }
        try {
            for (String string : map2.keySet()) {
                object = map2.get(string);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Resource resource = (Resource)iterator.next();
                    this.userArgs.addOutput(string, resource.getOutputStream());
                }
            }
            for (String string : map.keySet()) {
                for (TypedResource typedResource : map.get(string)) {
                    Resource resource = typedResource.getResource();
                    this.userArgs.addInput(string, resource.getInputStream(), resource.toString(), typedResource.getType(), typedResource.getContentType());
                }
            }
            for (Step step : this.steps) {
                for (Input useable : step.getInputs()) {
                    for (Resource resource : useable.getResources().listResources()) {
                        this.userArgs.addInput(useable.getPort(), resource.getInputStream(), resource.toString(), useable.getType(), useable.getContentType());
                    }
                }
                for (Parameter parameter : step.getParameters()) {
                    this.useParameter(parameter);
                }
                this.userArgs.setCurStepName(step.getName());
                for (Option option : step.getOptions()) {
                    this.useOption(option);
                }
            }
            new Main().run(this.userArgs, this.userArgs.createConfiguration());
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    private void checkDest() {
        if (this.destDir == null) {
            this.destDir = this.baseDir;
            this.log("destdir defaulting to basedir", 4);
        }
    }

    protected void handleError(String string) {
        if (this.failOnError) {
            throw new BuildException(string, this.getLocation());
        }
        this.log(string, 1);
    }

    protected void handleError(Throwable throwable) {
        if (this.failOnError) {
            throw new BuildException(throwable);
        }
        this.log("Caught an exception: " + throwable, 1);
        throwable.printStackTrace(new PrintStream((OutputStream)new LogOutputStream((Task)this, 3)));
    }

    private static class TypedFileNameMapper
    implements FileNameMapper {
        private FileNameMapper fileNameMapper;
        private Input.Type type;
        private String contentType;

        private TypedFileNameMapper(FileNameMapper fileNameMapper, Input.Type type) {
            this(fileNameMapper, type, null);
        }

        private TypedFileNameMapper(FileNameMapper fileNameMapper, Input.Type type, String string) {
            if (fileNameMapper == null) {
                throw new IllegalArgumentException("fileNameMapper must not be null");
            }
            this.fileNameMapper = fileNameMapper;
            if (type == null) {
                throw new IllegalArgumentException("type must not be null");
            }
            this.type = type;
            this.contentType = string;
        }

        public Input.Type getType() {
            return this.type;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setFrom(String string) {
            this.fileNameMapper.setFrom(string);
        }

        public void setTo(String string) {
            this.fileNameMapper.setTo(string);
        }

        public String[] mapFileName(String string) {
            return this.fileNameMapper.mapFileName(string);
        }
    }

    private static class TypedResource {
        private Resource resource = null;
        private Input.Type type = null;
        private String contentType = null;

        private TypedResource(Resource resource, Input.Type type) {
            this(resource, type, (String)null);
        }

        private TypedResource(Resource resource, Input.Type type, String string) {
            if (resource == null) {
                throw new IllegalArgumentException("resource must not be null");
            }
            this.resource = resource;
            if (type == null) {
                throw new IllegalArgumentException("type must not be null");
            }
            this.type = type;
            this.contentType = string;
        }

        public Resource getResource() {
            return this.resource;
        }

        public Input.Type getType() {
            return this.type;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    public static class UseableResources
    extends Resources {
        private Useable useable = new Useable();

        public void setIf(Object object) {
            this.useable.setIf(object);
        }

        public void setUnless(Object object) {
            this.useable.setUnless(object);
        }

        public boolean shouldUse() {
            return this.useable.shouldUse();
        }
    }

    public static class Step
    extends Useable {
        private String name = null;
        private List<Input> inputs = new ArrayList<Input>();
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private List<Option> options = new ArrayList<Option>();

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void addConfiguredInput(Input input) {
            if (!input.shouldUse()) {
                ((Useable)this).project.log("Skipping input '" + input.getPort() + "' as it is configured to be unused.", 4);
                return;
            }
            this.inputs.add(input);
            if (input.getMapper() != null) {
                throw new BuildException("Mappers are not supported for inputs that are nested in steps");
            }
        }

        public List<Input> getInputs() {
            return this.inputs;
        }

        public void addConfiguredParameter(Parameter parameter) {
            this.parameters.add(parameter);
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void addConfiguredOption(Option option) {
            this.options.add(option);
        }

        public List<Option> getOptions() {
            return this.options;
        }
    }

    public static class Parameter
    extends Option {
        private String port = "*";

        public void setPort(String string) {
            this.port = string;
        }

        public String getPort() {
            return this.port;
        }
    }

    public static class Option
    extends Useable {
        private String name = null;
        private String value = null;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Namespace
    extends Useable {
        private String prefix = null;
        private String uri = null;

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setURI(String string) {
            this.uri = string;
        }

        public String getURI() {
            return this.uri;
        }
    }

    public static class Input
    extends Port {
        private Input.Type type = Input.Type.XML;
        private String contentType;

        public Input.Type getType() {
            return this.type;
        }

        public void setType(Input.Type type) {
            this.type = type;
        }

        public String getContentType() {
            if (this.contentType != null && this.type != Input.Type.DATA) {
                throw new IllegalStateException("contentType of input can only be set if type is DATA");
            }
            return this.contentType;
        }

        public void setContentType(String string) {
            this.contentType = string;
        }
    }

    public static class Port
    extends Useable {
        private String port = null;
        private Union resources = new Union();
        private FileNameMapper mapper = null;

        public void setPort(String string) {
            this.port = string;
        }

        public void add(ResourceCollection resourceCollection) {
            this.resources.add(resourceCollection);
        }

        public void addConfiguredMapper(Mapper mapper) throws BuildException {
            this.add(mapper.getImplementation());
        }

        public void add(FileNameMapper fileNameMapper) throws BuildException {
            if (this.mapper != null) {
                throw new BuildException("Cannot define more than one mapper");
            }
            this.mapper = fileNameMapper;
        }

        public String getPort() {
            return this.port;
        }

        public Union getResources() {
            return this.resources;
        }

        public FileNameMapper getMapper() {
            return this.mapper;
        }
    }

    private static class Useable {
        private Project project;
        private Object ifCond;
        private Object unlessCond;

        private Useable() {
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public void setIf(Object object) {
            this.ifCond = object;
        }

        public void setUnless(Object object) {
            this.unlessCond = object;
        }

        public boolean shouldUse() {
            PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)this.project);
            return propertyHelper.testIfCondition(this.ifCond) && propertyHelper.testUnlessCondition(this.unlessCond);
        }
    }

    private class ExtensionMapper
    implements FileNameMapper {
        private ExtensionMapper() {
        }

        public void setFrom(String string) {
        }

        public void setTo(String string) {
        }

        public String[] mapFileName(String string) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            return new String[]{string + CalabashTask.this.targetExtension};
        }
    }
}

