/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritableDocument;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.ParseArgs;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.UserArgs;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.xml.sax.InputSource;

public class Main {
    private static QName _code = new QName("code");
    private static int exitStatus = 0;
    private XProcRuntime runtime = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean debug = false;

    public static void main(String[] stringArray) throws IOException {
        Main main = new Main();
        main.run(stringArray);
        System.exit(exitStatus);
    }

    public void run(String[] stringArray) throws IOException {
        block13: {
            UserArgs userArgs = null;
            try {
                userArgs = new ParseArgs().parse(stringArray);
            }
            catch (XProcException xProcException) {
                System.err.println(xProcException.getMessage());
                this.usage();
            }
            try {
                XProcConfiguration xProcConfiguration = userArgs.createConfiguration();
                if (this.run(userArgs, xProcConfiguration)) {
                    System.out.println();
                }
                this.runtime.close();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.usage();
            }
            catch (XProcException xProcException) {
                Throwable throwable;
                exitStatus = 1;
                if (xProcException.getErrorCode() != null) {
                    this.error(this.logger, null, this.errorMessage(xProcException.getErrorCode()), xProcException.getErrorCode());
                } else {
                    this.error(this.logger, null, xProcException.toString(), null);
                }
                for (throwable = xProcException.getCause(); throwable != null && throwable instanceof XProcException; throwable = throwable.getCause()) {
                }
                if (throwable != null) {
                    this.error(this.logger, null, "Underlying exception: " + throwable, null);
                }
                if (this.debug) {
                    xProcException.printStackTrace();
                }
            }
            catch (Exception exception) {
                exitStatus = 1;
                this.error(this.logger, null, "Pipeline failed: " + exception.toString(), null);
                if (exception.getCause() != null) {
                    Throwable throwable = exception.getCause();
                    this.error(this.logger, null, "Underlying exception: " + throwable, null);
                }
                if (!this.debug) break block13;
                exception.printStackTrace();
            }
        }
    }

    boolean run(UserArgs userArgs, XProcConfiguration xProcConfiguration) throws SaxonApiException, IOException, URISyntaxException {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        Object object7;
        this.runtime = new XProcRuntime(xProcConfiguration);
        this.debug = xProcConfiguration.debug;
        if (userArgs.isShowVersion()) {
            this.showVersion();
        }
        XPipeline xPipeline = null;
        if (userArgs.getPipeline() != null) {
            xPipeline = this.runtime.load(userArgs.getPipeline());
        } else if (userArgs.hasImplicitPipeline()) {
            object7 = userArgs.getImplicitPipeline(this.runtime);
            if (this.debug) {
                System.err.println("Implicit pipeline:");
                Serializer object62 = new Serializer();
                object62.setOutputProperty(Serializer.Property.INDENT, "yes");
                object62.setOutputProperty(Serializer.Property.METHOD, "xml");
                object62.setOutputStream((OutputStream)System.err);
                S9apiUtils.serialize(this.runtime, (XdmNode)object7, object62);
            }
            xPipeline = this.runtime.use((XdmNode)object7);
        } else if (xProcConfiguration.pipeline != null) {
            object7 = xProcConfiguration.pipeline.read();
            xPipeline = this.runtime.use((XdmNode)object7);
        } else {
            throw new UnsupportedOperationException("Either a pipeline or libraries and / or steps must be given");
        }
        for (String string : xProcConfiguration.params.keySet()) {
            object5 = (Map<QName, String>)xProcConfiguration.params.get(string);
            this.setParametersOnPipeline(xPipeline, string, (Map<QName, String>)object5);
        }
        for (String string : userArgs.getParameterPorts()) {
            object5 = userArgs.getParameters(string);
            this.setParametersOnPipeline(xPipeline, string, (Map<QName, String>)object5);
        }
        object7 = xPipeline.getInputs();
        Set<String> set = userArgs.getInputPorts();
        object5 = xProcConfiguration.inputs.keySet();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll((Collection<String>)object5);
        Iterator iterator = object7.iterator();
        while (iterator.hasNext()) {
            object42 = (String)iterator.next();
            if (hashSet.contains(object42) || !hashSet.contains(null) || !xPipeline.getDeclareStep().getInput((String)object42).getPrimary() || xPipeline.getDeclareStep().getInput((String)object42).getParameterInput()) continue;
            if (!set.contains(null)) break;
            userArgs.setDefaultInputPort((String)object42);
            hashSet.remove(null);
            hashSet.add((String)object42);
            break;
        }
        for (Object object42 : hashSet) {
            if (!object7.contains(object42)) {
                throw new XProcException("There is a binding for the port '" + object42 + "' but the pipeline declares no such port.");
            }
            xPipeline.clearInputs((String)object42);
            if (set.contains(object42)) {
                object3 = null;
                for (Input input : userArgs.getInputs((String)object42)) {
                    block0 : switch (input.getType()) {
                        case XML: {
                            switch (input.getKind()) {
                                case URI: {
                                    object2 = input.getUri();
                                    if ("-".equals(object2)) {
                                        object3 = this.runtime.parse(new InputSource(System.in));
                                        break block0;
                                    }
                                    object3 = this.runtime.parse(new InputSource((String)object2));
                                    break block0;
                                }
                                case INPUT_STREAM: {
                                    object = input.getInputStream();
                                    object3 = this.runtime.parse(new InputSource((InputStream)object));
                                    ((InputStream)object).close();
                                    break block0;
                                }
                            }
                            throw new UnsupportedOperationException(String.format("Unsupported input kind '%s'", new Object[]{input.getKind()}));
                        }
                        case DATA: {
                            switch (input.getKind()) {
                                case URI: {
                                    object2 = new ReadableData(this.runtime, XProcConstants.c_data, input.getUri(), input.getContentType());
                                    object3 = ((ReadableData)object2).read();
                                    break block0;
                                }
                                case INPUT_STREAM: {
                                    object = input.getInputStream();
                                    object2 = new ReadableData(this.runtime, XProcConstants.c_data, (InputStream)object, input.getContentType());
                                    object3 = ((ReadableData)object2).read();
                                    ((InputStream)object).close();
                                    break block0;
                                }
                            }
                            throw new UnsupportedOperationException(String.format("Unsupported input kind '%s'", new Object[]{input.getKind()}));
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("Unsupported input type '%s'", new Object[]{input.getType()}));
                        }
                    }
                    xPipeline.writeTo((String)object42, (XdmNode)object3);
                }
                continue;
            }
            for (ReadablePipe readablePipe : xProcConfiguration.inputs.get(object42)) {
                XdmNode xdmNode = readablePipe.read();
                xPipeline.writeTo((String)object42, xdmNode);
            }
        }
        iterator = null;
        object42 = object7.iterator();
        while (object42.hasNext()) {
            object3 = (String)object42.next();
            if (hashSet.contains(object3) || !xPipeline.getDeclareStep().getInput((String)object3).getPrimary() || xPipeline.getDeclareStep().getInput((String)object3).getParameterInput()) continue;
            iterator = object3;
        }
        if (iterator != null && !xPipeline.hasReadablePipes((String)((Object)iterator))) {
            object42 = this.runtime.parse(new InputSource(System.in));
            xPipeline.writeTo((String)((Object)iterator), (XdmNode)object42);
        }
        object42 = new HashMap();
        object3 = userArgs.getOutputs();
        for (String string : xPipeline.getOutputs()) {
            object2 = null;
            if (object3.containsKey(string)) {
                object2 = (Output)object3.get(string);
            } else if (xProcConfiguration.outputs.containsKey(string)) {
                object2 = new Output(xProcConfiguration.outputs.get(string));
            } else if (object3.containsKey(null) && xPipeline.getDeclareStep().getOutput(string).getPrimary()) {
                object2 = (Output)object3.get(null);
            }
            if (object2 != null && ((Output)object2).getKind() == Output.Kind.URI && "-".equals(((Output)object2).getUri())) {
                object2 = null;
            }
            object42.put(string, object2);
        }
        for (QName qName : xProcConfiguration.options.keySet()) {
            object2 = new RuntimeValue(xProcConfiguration.options.get(qName), null, null);
            xPipeline.passOption(qName, (RuntimeValue)object2);
        }
        for (QName qName : userArgs.getOptionNames()) {
            object2 = new RuntimeValue(userArgs.getOption(qName), null, null);
            xPipeline.passOption(qName, (RuntimeValue)object2);
        }
        xPipeline.run();
        for (String string : xPipeline.getOutputs()) {
            String string2;
            if (!object42.containsKey(string)) continue;
            object2 = (Output)object42.get(string);
            if (object2 == null || ((Output)object2).getKind() == Output.Kind.OUTPUT_STREAM && System.out.equals(((Output)object2).getOutputStream())) {
                this.finest(this.logger, null, "Copy output from " + string + " to stdout");
            } else {
                switch (((Output)object2).getKind()) {
                    case URI: {
                        this.finest(this.logger, null, "Copy output from " + string + " to " + ((Output)object2).getUri());
                        break;
                    }
                    case OUTPUT_STREAM: {
                        object = ((Output)object2).getOutputStream().getClass().getName();
                        this.finest(this.logger, null, "Copy output from " + string + " to " + (String)object + " stream");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported output kind '%s'", new Object[]{((Output)object2).getKind()}));
                    }
                }
            }
            object = xPipeline.getSerialization(string);
            if (object == null) {
                object = new Serialization(this.runtime, xPipeline.getNode());
                for (String string3 : xProcConfiguration.serializationOptions.keySet()) {
                    string2 = xProcConfiguration.serializationOptions.get(string3);
                    if ("byte-order-mark".equals(string3)) {
                        ((Serialization)object).setByteOrderMark("true".equals(string2));
                    }
                    if ("escape-uri-attributes".equals(string3)) {
                        ((Serialization)object).setEscapeURIAttributes("true".equals(string2));
                    }
                    if ("include-content-type".equals(string3)) {
                        ((Serialization)object).setIncludeContentType("true".equals(string2));
                    }
                    if ("indent".equals(string3)) {
                        ((Serialization)object).setIndent("true".equals(string2));
                    }
                    if ("omit-xml-declaration".equals(string3)) {
                        ((Serialization)object).setOmitXMLDeclaration("true".equals(string2));
                    }
                    if ("undeclare-prefixes".equals(string3)) {
                        ((Serialization)object).setUndeclarePrefixes("true".equals(string2));
                    }
                    if ("method".equals(string3)) {
                        ((Serialization)object).setMethod(new QName("", string2));
                    }
                    if ("doctype-public".equals(string3)) {
                        ((Serialization)object).setDoctypePublic(string2);
                    }
                    if ("doctype-system".equals(string3)) {
                        ((Serialization)object).setDoctypeSystem(string2);
                    }
                    if ("encoding".equals(string3)) {
                        ((Serialization)object).setEncoding(string2);
                    }
                    if ("media-type".equals(string3)) {
                        ((Serialization)object).setMediaType(string2);
                    }
                    if ("normalization-form".equals(string3)) {
                        ((Serialization)object).setNormalizationForm(string2);
                    }
                    if ("standalone".equals(string3)) {
                        ((Serialization)object).setStandalone(string2);
                    }
                    if (!"version".equals(string3)) continue;
                    ((Serialization)object).setVersion(string2);
                }
            }
            Object object6 = null;
            if (object2 == null) {
                object6 = new WritableDocument(this.runtime, null, (Serialization)object);
            } else {
                switch (((Output)object2).getKind()) {
                    case URI: {
                        URI uRI = new URI(((Output)object2).getUri());
                        string2 = uRI.getPath();
                        FileOutputStream fileOutputStream = new FileOutputStream(string2);
                        object6 = new WritableDocument(this.runtime, string2, (Serialization)object, fileOutputStream);
                        break;
                    }
                    case OUTPUT_STREAM: {
                        OutputStream outputStream = ((Output)object2).getOutputStream();
                        object6 = new WritableDocument(this.runtime, null, (Serialization)object, outputStream);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported output kind '%s'", new Object[]{((Output)object2).getKind()}));
                    }
                }
            }
            ReadablePipe readablePipe = xPipeline.readFrom(string);
            while (readablePipe.moreDocuments()) {
                ((WritableDocument)object6).write(readablePipe.read());
            }
            if (object2 == null) continue;
            ((WritableDocument)object6).close();
        }
        return object42.containsValue(null);
    }

    private void setParametersOnPipeline(XPipeline xPipeline, String string, Map<QName, String> map) {
        if ("*".equals(string)) {
            for (QName qName : map.keySet()) {
                xPipeline.setParameter(qName, new RuntimeValue(map.get(qName)));
            }
        } else {
            for (QName qName : map.keySet()) {
                xPipeline.setParameter(string, qName, new RuntimeValue(map.get(qName)));
            }
        }
    }

    private void showVersion() {
        System.out.println("XML Calabash version " + XProcConstants.XPROC_VERSION + ", an XProc processor.");
        if (this.runtime != null) {
            System.out.print("Running on Saxon version ");
            System.out.print(this.runtime.getConfiguration().getProcessor().getSaxonProductVersion());
            System.out.print(", ");
            System.out.print(this.runtime.getConfiguration().getProcessor().getUnderlyingConfiguration().getEditionCode());
            System.out.println(" edition.");
        }
        System.out.println("Copyright (c) 2007-2012 Norman Walsh");
        System.out.println("See docs/notices/NOTICES in the distribution for licensing");
        System.out.println("See also http://xmlcalabash.com/ for more information");
        System.out.println("");
    }

    private void usage() throws IOException {
        System.out.println();
        this.showVersion();
        InputStream inputStream = this.getClass().getResourceAsStream("/etc/usage.txt");
        if (inputStream == null) {
            throw new UnsupportedOperationException("Failed to load usage text from JAR file. This \"can't happen\".");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            System.err.println(string);
        }
        inputStream.close();
        bufferedReader.close();
        System.exit(1);
    }

    private String errorMessage(QName qName) {
        InputStream inputStream = this.getClass().getResourceAsStream("/etc/error-list.xml");
        if (inputStream != null) {
            XdmNode xdmNode = this.runtime.parse(new InputSource(inputStream));
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.DESCENDANT, new QName("http://www.w3.org/ns/xproc-error", "error"));
            while (xdmSequenceIterator.hasNext()) {
                XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                if (!qName.getLocalName().equals(xdmNode2.getAttributeValue(_code))) continue;
                return xdmNode2.getStringValue();
            }
        }
        return "Unknown error";
    }

    private String message(XdmNode xdmNode, String string) {
        String string2 = "(unknown URI)";
        int n = -1;
        if (xdmNode != null) {
            string2 = xdmNode.getBaseURI().toASCIIString();
            n = xdmNode.getLineNumber();
            return string2 + ":" + n + ": " + string;
        }
        return string;
    }

    public void error(Logger logger, XdmNode xdmNode, String string, QName qName) {
        logger.severe(this.message(xdmNode, string));
    }

    public void warning(Logger logger, XdmNode xdmNode, String string) {
        logger.warning(this.message(xdmNode, string));
    }

    public void info(Logger logger, XdmNode xdmNode, String string) {
        logger.info(this.message(xdmNode, string));
    }

    public void fine(Logger logger, XdmNode xdmNode, String string) {
        logger.fine(this.message(xdmNode, string));
    }

    public void finer(Logger logger, XdmNode xdmNode, String string) {
        logger.finer(this.message(xdmNode, string));
    }

    public void finest(Logger logger, XdmNode xdmNode, String string) {
        logger.finest(this.message(xdmNode, string));
    }
}

