/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RunTestReport {
    public static final QName _path = new QName("path");
    public static final QName _port = new QName("port");
    public static final QName _href = new QName("href");
    public static final QName _name = new QName("name");
    public static final QName _value = new QName("value");
    public static final String NS_TEST = "http://xproc.org/ns/testsuite";
    public static final QName t_test = new QName("http://xproc.org/ns/testsuite", "test");
    public static final QName t_title = new QName("http://xproc.org/ns/testsuite", "title");
    public static final QName t_description = new QName("http://xproc.org/ns/testsuite", "description");
    public static final QName t_input = new QName("http://xproc.org/ns/testsuite", "input");
    public static final QName t_output = new QName("http://xproc.org/ns/testsuite", "output");
    public static final QName t_parameter = new QName("http://xproc.org/ns/testsuite", "parameter");
    public static final QName t_option = new QName("http://xproc.org/ns/testsuite", "option");
    public static final QName t_pipeline = new QName("http://xproc.org/ns/testsuite", "pipeline");
    public static final QName t_compare_pipeline = new QName("http://xproc.org/ns/testsuite", "compare-pipeline");
    public static final QName t_document = new QName("http://xproc.org/ns/testsuite", "document");
    private static boolean debug = false;
    private static boolean schemaAware = false;
    private static XdmNode prettyPrint = null;
    private static String defaultLog = null;
    private XProcRuntime runtime = null;

    public static void main(String[] stringArray) throws SaxonApiException, IOException, URISyntaxException {
        String string = "RunTests [-D] [-d directory] [-a] test.xml";
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-D".equals(stringArray[i])) {
                debug = true;
                continue;
            }
            if ("-L".equals(stringArray[i])) {
                defaultLog = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-a".equals(stringArray[i])) {
                schemaAware = true;
                continue;
            }
            if ("-d".equals(stringArray[i])) {
                int n = 0;
                File file = new File(stringArray[++i]);
                String string2 = null;
                try {
                    file = file.getCanonicalFile();
                    string2 = file.getName();
                }
                catch (IOException iOException) {
                    throw new XProcException(iOException);
                }
                for (File file2 : file.listFiles()) {
                    if (file2.isDirectory() || !file2.getName().endsWith(".xml")) continue;
                    ++n;
                    System.err.println("Test: " + file2.getAbsolutePath());
                    vector.add(file2.getAbsolutePath());
                }
                if (n != 0) continue;
                System.err.println("No tests found in " + string2);
                continue;
            }
            System.err.println("Test: " + stringArray[i]);
            vector.add(stringArray[i]);
        }
        if (vector.size() == 0) {
            System.err.println(string);
            System.exit(1);
        }
        RunTestReport runTestReport = new RunTestReport();
        runTestReport.runTests(vector);
    }

    public void runTests(Vector<String> vector) {
        XProcConfiguration xProcConfiguration = new XProcConfiguration("ee", schemaAware);
        this.runtime = new XProcRuntime(xProcConfiguration);
        this.startReport();
        for (String string : vector) {
            this.run(string);
        }
        this.endReport();
    }

    public void run(String string) {
        XdmNode xdmNode;
        Object object;
        InputSource inputSource;
        XdmNode xdmNode2;
        Object object2;
        Vector<TestResult> vector = new Vector<TestResult>();
        XProcConfiguration xProcConfiguration = new XProcConfiguration("ee", schemaAware);
        this.runtime = new XProcRuntime(xProcConfiguration);
        this.runtime.getConfiguration().debug = debug;
        try {
            object2 = this.getClass().getResourceAsStream("/etc/prettyprint.xpl");
            if (object2 == null) {
                throw new UnsupportedOperationException("Failed to load prettyprint stylesheet from resources.");
            }
            xdmNode2 = this.runtime.parse(new InputSource((InputStream)object2));
            prettyPrint = S9apiUtils.getDocumentElement(xdmNode2);
            inputSource = new InputSource(string);
            object = XMLReaderFactory.createXMLReader();
            object.setEntityResolver(this.runtime.getResolver());
            SAXSource sAXSource = new SAXSource((XMLReader)object, inputSource);
            DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
            documentBuilder.setLineNumbering(true);
            documentBuilder.setDTDValidation(false);
            XdmNode xdmNode3 = documentBuilder.build((Source)sAXSource);
            xdmNode = S9apiUtils.getDocumentElement(xdmNode3);
        }
        catch (Exception exception) {
            TestResult testResult = new TestResult(string);
            testResult.catchException(exception);
            vector.add(testResult);
            this.makeReport(vector);
            return;
        }
        if (t_test.equals((Object)xdmNode.getNodeName())) {
            object2 = this.runTest(xdmNode);
            vector.add((TestResult)object2);
            this.makeReport(vector);
        } else {
            object2 = "";
            xdmNode2 = xdmNode.axisIterator(Axis.CHILD, t_title);
            while (xdmNode2.hasNext()) {
                inputSource = (XdmNode)xdmNode2.next();
                object2 = (String)object2 + inputSource.getStringValue();
            }
            xdmNode2 = xdmNode.axisIterator(Axis.CHILD, t_test);
            while (xdmNode2.hasNext()) {
                inputSource = (XdmNode)xdmNode2.next();
                object = this.runTest((XdmNode)inputSource);
                vector.add((TestResult)object);
            }
            System.out.println("<test-suite>");
            if (!"".equals(object2)) {
                System.out.println("<title>" + (String)object2 + "</title>");
            }
            this.makeReport(vector);
            System.out.println("</test-suite>");
        }
    }

    public TestResult runTest(XdmNode xdmNode) {
        Object object3;
        Iterator<Object> iterator;
        Hashtable<String, Vector<XdmNode>> hashtable;
        Object object2;
        if (xdmNode.getAttributeValue(_href) != null) {
            TestResult testResult;
            URI uRI = xdmNode.getBaseURI().resolve(xdmNode.getAttributeValue(_href));
            try {
                InputSource inputSource = new InputSource(uRI.toASCIIString());
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setEntityResolver(this.runtime.getResolver());
                SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
                DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
                documentBuilder.setLineNumbering(true);
                documentBuilder.setDTDValidation(false);
                XdmNode xdmNode2 = documentBuilder.build((Source)sAXSource);
                XdmNode xdmNode3 = S9apiUtils.getDocumentElement(xdmNode2);
                testResult = this.runTest(xdmNode3);
            }
            catch (Exception exception) {
                testResult = new TestResult(uRI.toASCIIString());
                testResult.catchException(exception);
            }
            return testResult;
        }
        TestResult testResult = new TestResult(xdmNode.getBaseURI().toASCIIString());
        System.err.println("Running test: " + xdmNode.getBaseURI());
        XProcTest xProcTest = new XProcTest(xdmNode);
        testResult.setTitle(xProcTest.title);
        testResult.setDescription(xProcTest.description);
        if (xProcTest.pipeline == null) {
            testResult.catchException(new UnsupportedOperationException("Pipeline must be provided."));
            return testResult;
        }
        Hashtable<Object, Object> hashtable2 = new Hashtable();
        try {
            hashtable2 = this.runPipe(xProcTest.pipeline.pipeline, xProcTest.inputs, xProcTest.outputs, xProcTest.parameters, xProcTest.options);
        }
        catch (XProcException xProcException) {
            if (xProcTest.error == null) {
                testResult.fail(xProcException);
                return testResult;
            }
            if (xProcException.getErrorCode() != null) {
                testResult.catchException(xProcException);
                testResult.success(xProcTest.error, xProcException.getErrorCode());
                return testResult;
            }
            testResult.success(xProcTest.error, null);
            return testResult;
        }
        catch (Exception exception) {
            testResult.catchException(exception);
            return testResult;
        }
        if (xProcTest.error != null) {
            testResult.fail(xProcTest.error);
            return testResult;
        }
        if (xProcTest.comparepipeline != null) {
            object2 = xProcTest.comparepipeline;
            hashtable = new Hashtable<String, Vector<XdmNode>>();
            for (String string2 : hashtable2.keySet()) {
                if (!((XProcPipeline)object2).inputPorts.contains(string2)) continue;
                iterator = (ReadablePipe)hashtable2.get(string2);
                while (iterator.moreDocuments()) {
                    try {
                        object3 = iterator.read();
                        if (!hashtable.containsKey(string2)) {
                            hashtable.put(string2, new Vector());
                        }
                        hashtable.get(string2).add((XdmNode)object3);
                    }
                    catch (SaxonApiException saxonApiException) {
                        testResult.catchException(saxonApiException);
                        return testResult;
                    }
                }
            }
            try {
                hashtable2 = this.runPipe(((XProcPipeline)object2).pipeline, hashtable, xProcTest.outputs, null, null);
            }
            catch (Exception exception) {
                testResult.fail(exception, "Compare pipelines failed: this shouldn't happen.");
            }
        }
        object2 = new Hashtable();
        hashtable = new Hashtable();
        try {
            ReadablePipe readablePipe;
            XPipeline xPipeline;
            XdmNode xdmNode4;
            Vector<XdmNode> vector;
            Vector vector2;
            for (String string : hashtable2.keySet()) {
                iterator = xProcTest.outputs.get(string);
                object3 = (ReadablePipe)hashtable2.get(string);
                if (!((Hashtable)object2).containsKey(string)) {
                    ((Hashtable)object2).put(string, new Vector());
                }
                if (!hashtable.containsKey(string)) {
                    hashtable.put(string, new Vector());
                }
                vector2 = (Vector)((Hashtable)object2).get(string);
                vector = hashtable.get(string);
                while (object3.moreDocuments()) {
                    XdmNode xdmNode5;
                    if (((Vector)((Object)iterator)).size() > 0) {
                        xdmNode5 = (XdmNode)((Vector)((Object)iterator)).remove(0);
                        xdmNode4 = object3.read();
                        if (xProcTest.ignoreWS) {
                            xPipeline = this.runtime.use(prettyPrint);
                            xPipeline.writeTo("source", xdmNode5);
                            xPipeline.run();
                            readablePipe = xPipeline.readFrom("result");
                            xdmNode5 = readablePipe.read();
                            xPipeline.reset();
                            xPipeline.writeTo("source", xdmNode4);
                            xPipeline.run();
                            readablePipe = xPipeline.readFrom("result");
                            xdmNode4 = readablePipe.read();
                        }
                        vector2.add(xdmNode4);
                        vector.add(xdmNode5);
                        continue;
                    }
                    xdmNode5 = object3.read();
                    vector2.add(xdmNode5);
                }
            }
            QName qName = new QName("", "doca");
            QName qName2 = new QName("", "docb");
            for (Object object3 : hashtable2.keySet()) {
                vector2 = (Vector)((Hashtable)object2).get(object3);
                vector = hashtable.get(object3);
                if (vector2.size() == 0 && vector.size() == 0) {
                    testResult.success();
                }
                for (int i = 0; i < vector2.size() || i < vector.size(); ++i) {
                    if (i >= vector2.size()) {
                        xdmNode4 = vector.get(i);
                        testResult.fail(xdmNode4, null);
                        continue;
                    }
                    if (i >= vector.size()) {
                        xdmNode4 = (XdmNode)vector2.get(i);
                        testResult.fail(null, xdmNode4);
                        continue;
                    }
                    xdmNode4 = vector.get(i);
                    xPipeline = (XdmNode)vector2.get(i);
                    readablePipe = this.runtime.getProcessor().newXPathCompiler();
                    readablePipe.declareVariable(qName);
                    readablePipe.declareVariable(qName2);
                    XPathExecutable xPathExecutable = readablePipe.compile("deep-equal($doca,$docb)");
                    XPathSelector xPathSelector = xPathExecutable.load();
                    xPathSelector.setVariable(qName, (XdmValue)xdmNode4);
                    xPathSelector.setVariable(qName2, (XdmValue)xPipeline);
                    Iterator iterator2 = xPathSelector.iterator();
                    XdmAtomicValue xdmAtomicValue = (XdmAtomicValue)iterator2.next();
                    boolean bl = xdmAtomicValue.getBooleanValue();
                    if (bl) {
                        testResult.success();
                        continue;
                    }
                    testResult.fail(xdmNode4, (XdmNode)xPipeline);
                }
            }
        }
        catch (SaxonApiException saxonApiException) {
            testResult.fail((Exception)((Object)saxonApiException), "Error comparing results: this shouldn't happen");
        }
        if (hashtable2.size() == 0 && hashtable.size() == 0) {
            testResult.success();
        }
        return testResult;
    }

    private Hashtable<String, ReadablePipe> runPipe(XdmNode xdmNode, Hashtable<String, Vector<XdmNode>> hashtable, Hashtable<String, Vector<XdmNode>> hashtable2, Hashtable<QName, String> hashtable3, Hashtable<QName, String> hashtable4) throws SaxonApiException {
        XPipeline xPipeline = this.runtime.use(xdmNode);
        if (hashtable != null) {
            for (String object22 : hashtable.keySet()) {
                if (!xPipeline.getInputs().contains(object22)) {
                    throw new UnsupportedOperationException("Error: Test sets input port that doesn't exist: " + object22);
                }
                xPipeline.clearInputs(object22);
                for (XdmNode xdmNode2 : hashtable.get(object22)) {
                    xPipeline.writeTo(object22, xdmNode2);
                }
            }
        }
        if (hashtable3 != null) {
            for (QName qName : hashtable3.keySet()) {
                xPipeline.setParameter(qName, new RuntimeValue(hashtable3.get(qName)));
            }
        }
        if (hashtable4 != null) {
            for (QName qName : hashtable4.keySet()) {
                RuntimeValue runtimeValue = _path.equals((Object)qName) ? new RuntimeValue("file:///home/ndw/tests.xproc.org/tests/required/" + hashtable4.get(qName)) : new RuntimeValue(hashtable4.get(qName));
                xPipeline.passOption(qName, runtimeValue);
            }
        }
        try {
            xPipeline.run();
        }
        catch (XProcException xProcException) {
            if (debug) {
                xProcException.printStackTrace();
            }
            throw xProcException;
        }
        catch (Throwable throwable) {
            if (debug) {
                throwable.printStackTrace();
            }
            throw new XProcException(throwable);
        }
        Hashtable hashtable5 = new Hashtable();
        Set<String> set = xPipeline.getOutputs();
        for (String string : set) {
            if (string.startsWith("!")) continue;
            ReadablePipe readablePipe = xPipeline.readFrom(string);
            readablePipe.canReadSequence(true);
            hashtable5.put(string, readablePipe);
        }
        return hashtable5;
    }

    private void makeReport(Vector<TestResult> vector) {
        for (TestResult testResult : vector) {
            testResult.report();
        }
    }

    private void startReport() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        System.out.println("<test-report xmlns='http://xproc.org/ns/testreport'>");
        System.out.println("<title>XProc Test Results for XML Calabash</title>");
        System.out.print("<date>");
        System.out.print(gregorianCalendar.get(1));
        System.out.print("-");
        if (gregorianCalendar.get(2) + 1 < 10) {
            System.out.print("0");
        }
        System.out.print(gregorianCalendar.get(2) + 1);
        System.out.print("-");
        if (gregorianCalendar.get(5) < 10) {
            System.out.print("0");
        }
        System.out.print(gregorianCalendar.get(5));
        System.out.print("T");
        if (gregorianCalendar.get(11) < 10) {
            System.out.print("0");
        }
        System.out.print(gregorianCalendar.get(11));
        System.out.print(":");
        if (gregorianCalendar.get(12) < 10) {
            System.out.print("0");
        }
        System.out.print(gregorianCalendar.get(12));
        System.out.print(":");
        if (gregorianCalendar.get(13) < 10) {
            System.out.print("0");
        }
        System.out.print(gregorianCalendar.get(13));
        System.out.println("</date>");
        System.out.println("<processor>");
        System.out.println("<name>" + this.runtime.getProductName() + "</name>");
        System.out.println("<vendor>" + this.runtime.getVendor() + "</vendor>");
        System.out.println("<vendor-uri>" + this.runtime.getVendorURI() + "</vendor-uri>");
        System.out.println("<version>" + this.runtime.getProductVersion() + "</version>");
        System.out.println("<language>" + this.runtime.getLanguage() + "</language>");
        System.out.println("<xproc-version>" + this.runtime.getXProcVersion() + "</xproc-version>");
        System.out.println("<xpath-version>" + this.runtime.getXPathVersion() + "</xpath-version>");
        System.out.println("<psvi-supported>" + this.runtime.getPSVISupported() + "</psvi-supported>");
        System.out.println("</processor>");
    }

    private void endReport() {
        System.out.println("</test-report>");
    }

    public String serializeAsXML(XdmNode xdmNode) {
        try {
            Serializer serializer = new Serializer();
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "no");
            serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
            serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            serializer.setOutputStream((OutputStream)byteArrayOutputStream);
            S9apiUtils.serialize(this.runtime, xdmNode, serializer);
            String string = byteArrayOutputStream.toString();
            return string;
        }
        catch (SaxonApiException saxonApiException) {
            saxonApiException.printStackTrace();
            return "";
        }
    }

    public String serialize(XdmNode xdmNode) {
        String string = this.serializeAsXML(xdmNode);
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }

    private class TestResult {
        public String testfile = null;
        public String title = "";
        public Vector<XdmNode> description = null;
        public boolean passed = false;
        public QName expectedError = null;
        public QName actualError = null;
        public Vector<String> errorMessages = new Vector();
        public XdmNode expected = null;
        public XdmNode actual = null;

        public TestResult(String string) {
            this.testfile = string;
        }

        public void setTitle(XdmNode xdmNode) {
            if (xdmNode != null) {
                this.title = xdmNode.getStringValue();
            }
        }

        public void setDescription(XdmNode xdmNode) {
            if (xdmNode != null) {
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                this.description = new Vector();
                while (xdmSequenceIterator.hasNext()) {
                    XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                    HashSet<String> hashSet = new HashSet<String>();
                    XdmSequenceIterator xdmSequenceIterator2 = xdmNode2.axisIterator(Axis.NAMESPACE);
                    while (xdmSequenceIterator2.hasNext()) {
                        XdmNode xdmNode3 = (XdmNode)xdmSequenceIterator2.next();
                        if (xdmNode3.getNodeName() == null) continue;
                        String string = xdmNode3.getNodeName().getLocalName();
                        String string2 = xdmNode3.getStringValue();
                        if ("http://www.w3.org/1999/xhtml".equals(string2) || "xml".equals(string)) continue;
                        hashSet.add(string2);
                    }
                    xdmNode2 = S9apiUtils.removeNamespaces(RunTestReport.this.runtime, xdmNode2, hashSet, true);
                    this.description.add(xdmNode2);
                }
            }
        }

        public void success() {
            this.passed = true;
        }

        public void success(QName qName, QName qName2) {
            this.expectedError = qName;
            this.actualError = qName2;
            this.passed = true;
        }

        public void fail(QName qName) {
            this.errorMessages.add("Test passed, but should have raised " + qName);
        }

        public void fail(Exception exception) {
            this.catchException(exception);
        }

        public void fail(Exception exception, String string) {
            this.catchException(exception);
            if (string != null) {
                this.errorMessages.add(string);
            }
        }

        public void fail(XdmNode xdmNode, XdmNode xdmNode2) {
            this.expected = xdmNode;
            this.actual = xdmNode2;
        }

        public void report() {
            String string = "pass";
            if (!this.passed) {
                string = "fail";
            }
            System.out.println("<" + string + " uri='" + this.testfile + "'>");
            if (this.title != null) {
                System.out.println("<title>" + this.title + "</title>");
            }
            if (this.actualError != null && this.expectedError == null || this.actualError == null && this.expectedError != null || this.actualError != null && this.expectedError != null && !this.actualError.equals((Object)this.expectedError)) {
                System.out.print("<error");
                if (this.expectedError != null) {
                    System.out.print(" expected='" + this.expectedError + "'");
                }
                System.out.println(">" + this.actualError + "</error>");
            }
            for (String string2 : this.errorMessages) {
                System.out.println("<message>" + this.xmlEscape(string2) + "</message>");
            }
            if (this.expected != null) {
                System.out.print("<expected>");
                System.out.print(RunTestReport.this.serialize(this.expected));
                System.out.println("</expected>");
            }
            if (this.actual != null) {
                System.out.print("<actual>");
                System.out.print(RunTestReport.this.serialize(this.actual));
                System.out.println("</actual>");
            }
            System.out.println("</" + string + ">");
        }

        public void catchException(Throwable throwable) {
            while (throwable != null) {
                if (throwable.getMessage() != null) {
                    this.errorMessages.add(throwable.getMessage());
                } else {
                    this.errorMessages.add(throwable.toString());
                }
                if (throwable instanceof XProcException) {
                    XProcException xProcException = (XProcException)throwable;
                    this.actualError = xProcException.getErrorCode();
                    return;
                }
                throwable = throwable.getCause();
            }
        }

        private String xmlEscape(String string) {
            string = string.replaceAll("&", "&amp;");
            string = string.replaceAll("<", "&lt;");
            string = string.replaceAll(">", "&gt;");
            return string;
        }
    }

    private class XProcPipeline {
        public HashSet<String> inputPorts = new HashSet();
        public HashSet<String> outputPorts = new HashSet();
        public XdmNode pipeline = null;

        public XProcPipeline(XdmNode xdmNode) {
            this.pipeline = xdmNode;
            for (XdmNode xdmNode2 : new RelevantNodes(RunTestReport.this.runtime, xdmNode, Axis.CHILD)) {
                if (XProcConstants.p_input.equals((Object)xdmNode2.getNodeName())) {
                    this.inputPorts.add(xdmNode2.getAttributeValue(_port));
                }
                if (!XProcConstants.p_output.equals((Object)xdmNode2.getNodeName())) continue;
                this.outputPorts.add(xdmNode2.getAttributeValue(_port));
            }
        }
    }

    private class XProcTest {
        private final QName _error = new QName("error");
        private final QName _ignoreWS = new QName("ignore-whitespace-differences");
        public Hashtable<String, Vector<XdmNode>> inputs = new Hashtable();
        public Hashtable<String, Vector<XdmNode>> outputs = new Hashtable();
        public Hashtable<QName, String> parameters = new Hashtable();
        public Hashtable<QName, String> options = new Hashtable();
        public XProcPipeline pipeline = null;
        public XProcPipeline comparepipeline = null;
        public XdmNode title = null;
        public XdmNode description = null;
        public QName error = null;
        public boolean ignoreWS = false;

        public XProcTest(XdmNode xdmNode) {
            String string;
            if (!t_test.equals((Object)xdmNode.getNodeName())) {
                throw new XProcException(xdmNode, "Test must have t:test as root element.");
            }
            if (xdmNode.getAttributeValue(this._error) != null) {
                string = xdmNode.getAttributeValue(this._error);
                this.error = new QName(string, xdmNode);
            }
            this.ignoreWS = true;
            if (xdmNode.getAttributeValue(this._ignoreWS) != null) {
                string = xdmNode.getAttributeValue(this._ignoreWS);
                this.ignoreWS = !"false".equals(string);
            }
            try {
                this.scan(xdmNode);
            }
            catch (Exception exception) {
                throw new XProcException(exception);
            }
        }

        private void scan(XdmNode xdmNode) throws SaxonApiException {
            for (XdmNode xdmNode2 : new RelevantNodes(RunTestReport.this.runtime, xdmNode, Axis.CHILD)) {
                if (t_title.equals((Object)xdmNode2.getNodeName())) {
                    this.title = xdmNode2;
                    continue;
                }
                if (t_description.equals((Object)xdmNode2.getNodeName())) {
                    this.description = xdmNode2;
                    continue;
                }
                if (t_input.equals((Object)xdmNode2.getNodeName()) || t_output.equals((Object)xdmNode2.getNodeName())) {
                    this.scanio(xdmNode2);
                    continue;
                }
                if (t_parameter.equals((Object)xdmNode2.getNodeName()) || t_option.equals((Object)xdmNode2.getNodeName())) {
                    this.scanop(xdmNode2);
                    continue;
                }
                if (t_pipeline.equals((Object)xdmNode2.getNodeName()) || t_compare_pipeline.equals((Object)xdmNode2.getNodeName())) {
                    this.scanpipe(xdmNode2);
                    continue;
                }
                throw new XProcException(xdmNode, "Not a valid test: " + xdmNode2.getNodeName());
            }
        }

        private void scanio(XdmNode xdmNode) throws SaxonApiException {
            String string = xdmNode.getAttributeValue(_port);
            if (string == null) {
                throw new IllegalArgumentException("Each input and output must specify a port");
            }
            if (t_output.equals((Object)xdmNode.getNodeName()) && this.outputs.containsKey(string)) {
                throw new IllegalArgumentException("Attempt to redefine output port: " + string);
            }
            String string2 = xdmNode.getAttributeValue(_href);
            if (string2 != null) {
                this.add(xdmNode, string, string2);
            } else {
                for (XdmNode xdmNode2 : new RelevantNodes(xdmNode, Axis.CHILD, false)) {
                    XdmSequenceIterator xdmSequenceIterator;
                    Object object;
                    if (xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    if (t_document.equals((Object)xdmNode2.getNodeName())) {
                        string2 = xdmNode2.getAttributeValue(_href);
                        if (string2 != null) {
                            this.add(xdmNode, string, string2);
                            continue;
                        }
                        object = new Vector();
                        xdmSequenceIterator = xdmNode2.axisIterator(Axis.CHILD);
                        while (xdmSequenceIterator.hasNext()) {
                            ((Vector)object).add(xdmSequenceIterator.next());
                        }
                        XdmDestination xdmDestination = new XdmDestination();
                        S9apiUtils.writeXdmValue(RunTestReport.this.runtime, (Vector<XdmValue>)object, (Destination)xdmDestination, xdmNode2.getBaseURI());
                        this.add(xdmNode, string, xdmDestination.getXdmNode());
                        continue;
                    }
                    object = new XdmDestination();
                    S9apiUtils.writeXdmValue(RunTestReport.this.runtime, (XdmItem)xdmNode2, (Destination)object, xdmNode2.getBaseURI());
                    xdmSequenceIterator = object.getXdmNode();
                    this.add(xdmNode, string, object.getXdmNode());
                }
            }
        }

        private void scanpipe(XdmNode xdmNode) throws SaxonApiException {
            URI uRI = xdmNode.getBaseURI();
            String string = xdmNode.getAttributeValue(_href);
            if (string != null) {
                this.add(xdmNode, null, uRI.resolve(string).toASCIIString());
            } else {
                XdmNode xdmNode2 = null;
                for (XdmNode xdmNode3 : new RelevantNodes(xdmNode, Axis.CHILD, true)) {
                    if (xdmNode3.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    xdmNode2 = xdmNode3;
                }
                if (t_document.equals((Object)xdmNode2.getNodeName())) {
                    string = xdmNode2.getAttributeValue(_href);
                    if (string != null) {
                        this.add(xdmNode, null, xdmNode2.getBaseURI().resolve(string).toASCIIString());
                    } else {
                        XdmNode xdmNode4 = S9apiUtils.getDocumentElement(xdmNode2);
                        this.add(xdmNode, null, xdmNode4);
                    }
                } else {
                    this.add(xdmNode, null, xdmNode2);
                }
            }
        }

        private void scanop(XdmNode xdmNode) {
            String string = xdmNode.getAttributeValue(_name);
            String string2 = xdmNode.getAttributeValue(_value);
            if (string == null || string2 == null) {
                throw new IllegalArgumentException("Each option and parameter must specify a name and a value");
            }
            QName qName = new QName(string, xdmNode);
            if (t_option.equals((Object)xdmNode.getNodeName())) {
                if (this.options.containsKey(qName)) {
                    throw new IllegalArgumentException("Attempt to redefine option: " + qName);
                }
                this.options.put(qName, string2);
            } else {
                if (this.parameters.containsKey(qName)) {
                    throw new IllegalArgumentException("Attempt to redefine parameter: " + qName);
                }
                this.parameters.put(qName, string2);
            }
            Iterator<XdmNode> iterator = new RelevantNodes(RunTestReport.this.runtime, xdmNode, Axis.CHILD).iterator();
            if (iterator.hasNext()) {
                XdmNode xdmNode2 = iterator.next();
                throw new IllegalArgumentException("Options and parameters must be empty.");
            }
        }

        private void add(XdmNode xdmNode, String string, String string2) throws SaxonApiException {
            String string3 = xdmNode.getBaseURI().resolve(string2).toASCIIString();
            this.add(xdmNode, string, RunTestReport.this.runtime.parse(new InputSource(string3)));
        }

        private void add(XdmNode xdmNode, String string, XdmNode xdmNode2) {
            String string2 = xdmNode.getNodeName().getLocalName();
            if ("input".equals(string2)) {
                if (!this.inputs.containsKey(string)) {
                    this.inputs.put(string, new Vector());
                }
                this.inputs.get(string).add(xdmNode2);
            } else if ("output".equals(string2)) {
                if (!this.outputs.containsKey(string)) {
                    this.outputs.put(string, new Vector());
                }
                this.outputs.get(string).add(xdmNode2);
            } else if ("pipeline".equals(string2)) {
                if (this.pipeline != null) {
                    throw new UnsupportedOperationException("Only one pipeline can be defined.");
                }
                this.pipeline = new XProcPipeline(xdmNode2);
            } else if ("compare-pipeline".equals(string2)) {
                if (this.comparepipeline != null) {
                    throw new UnsupportedOperationException("Only one compare pipeline can be defined.");
                }
                this.comparepipeline = new XProcPipeline(xdmNode2);
            } else {
                throw new UnsupportedOperationException("Unexpected type: " + string2);
            }
        }
    }
}

