/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.config.CssProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class CssFormatter
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName _content_type = new QName("", "content-type");
    private ReadablePipe source = null;
    private ReadablePipe css = null;
    private WritablePipe result = null;
    private Properties options = new Properties();

    public CssFormatter(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else {
            this.css = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        if (!"".equals(qName.getNamespaceURI())) {
            throw new XProcException(this.step.getNode(), "The cx:css-formatter parameters are in no namespace: " + qName + " (" + qName.getNamespaceURI() + ")");
        }
        this.options.setProperty(qName.getLocalName(), runtimeValue.getString());
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        Object object;
        CssProcessor cssProcessor;
        block17: {
            super.run();
            String string = this.runtime.getConfiguration().cssProcessor;
            if (string == null) {
                throw new XProcException("No CSS processor class defined");
            }
            cssProcessor = null;
            try {
                cssProcessor = (CssProcessor)Class.forName(string).newInstance();
                cssProcessor.initialize(this.runtime, this.step, this.options);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                cssProcessor = null;
                if (this.runtime.getDebug()) {
                    noClassDefFoundError.printStackTrace();
                }
            }
            catch (Exception exception) {
                cssProcessor = null;
                if (!this.runtime.getDebug()) break block17;
                exception.printStackTrace();
            }
        }
        if (cssProcessor == null) {
            throw new XProcException(this.step.getNode(), "Failed to instantiate CSS provider");
        }
        while (this.css.moreDocuments()) {
            object = this.css.read();
            cssProcessor.addStylesheet((XdmNode)object);
        }
        object = null;
        if (this.getOption(_content_type) != null) {
            object = this.getOption(_content_type).getString();
        }
        String string = this.getOption(_href).getBaseURI().resolve(this.getOption(_href).getString()).toASCIIString();
        String string2 = null;
        if (!string.startsWith("file:/")) {
            throw new XProcException(this.step.getNode(), "Don't know how to write cx:css-formatter output to " + string);
        }
        string2 = URIUtils.getFile(string).getPath();
        OutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(string2));
                cssProcessor.format(this.source.read(), outputStream, (String)object);
            }
            catch (XProcException xProcException) {
                throw xProcException;
            }
            catch (Exception exception) {
                throw new XProcException(this.step.getNode(), "Failed to style with CSS document", (Throwable)exception);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_result);
        treeWriter.startContent();
        treeWriter.addText(string);
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

