/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class MetadataExtractor
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName c_metadata = new QName("c", "http://www.w3.org/ns/xproc-step", "metadata");
    private static final QName c_tag = new QName("c", "http://www.w3.org/ns/xproc-step", "tag");
    private static final QName _dir = new QName("", "dir");
    private static final QName _type = new QName("", "type");
    private static final QName _name = new QName("", "name");
    private static final QName _error = new QName("", "error");
    private WritablePipe result = null;

    public MetadataExtractor(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        URI uRI = this.getOption(_href).getBaseURI().resolve(this.getOption(_href).getString());
        try {
            URL uRL = uRI.toURL();
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            Metadata metadata = JpegMetadataReader.readMetadata((InputStream)inputStream);
            TreeWriter treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(c_metadata);
            treeWriter.addAttribute(_href, uRI.toASCIIString());
            treeWriter.startContent();
            Iterator iterator = metadata.getDirectoryIterator();
            while (iterator.hasNext()) {
                Directory directory = (Directory)iterator.next();
                String string = directory.getName();
                Iterator iterator2 = directory.getTagIterator();
                while (iterator2.hasNext()) {
                    Tag tag = (Tag)iterator2.next();
                    treeWriter.addStartElement(c_tag);
                    treeWriter.addAttribute(_dir, string);
                    treeWriter.addAttribute(_type, tag.getTagTypeHex());
                    treeWriter.addAttribute(_name, tag.getTagName());
                    String string2 = "";
                    try {
                        string2 = tag.getDescription();
                    }
                    catch (MetadataException metadataException) {
                        treeWriter.addAttribute(_error, metadataException.toString());
                    }
                    if (string2.matches("^\\d\\d\\d\\d:\\d\\d:\\d\\d \\d\\d:\\d\\d:\\d\\d$")) {
                        String string3;
                        string2 = string3 = string2.substring(0, 4) + "-" + string2.substring(5, 7) + "-" + string2.substring(8, 10) + "T" + string2.substring(11, 19);
                    }
                    treeWriter.startContent();
                    treeWriter.addText(string2);
                    treeWriter.addEndElement();
                }
            }
            treeWriter.addEndElement();
            treeWriter.endDocument();
            this.result.write(treeWriter.getResult());
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        catch (JpegProcessingException jpegProcessingException) {
            if (this.runtime.getDebug()) {
                jpegProcessingException.printStackTrace();
            }
            this.runIntrinsics(uRI);
        }
    }

    private void runIntrinsics(URI uRI) throws SaxonApiException {
        ImageIntrinsics imageIntrinsics = new ImageIntrinsics();
        imageIntrinsics.run(uRI.toASCIIString());
    }

    private class ImageIntrinsics
    implements ImageObserver {
        boolean imageLoaded = false;
        boolean imageFailed = false;
        Image image = null;
        int width = -1;
        int depth = -1;

        private ImageIntrinsics() {
        }

        public void run(String string) {
            Object object;
            this.imageLoaded = false;
            this.imageFailed = false;
            this.image = null;
            this.width = -1;
            this.depth = -1;
            System.setProperty("java.awt.headless", "true");
            try {
                object = new URL(string);
                this.image = Toolkit.getDefaultToolkit().getImage((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                this.image = Toolkit.getDefaultToolkit().getImage(string);
            }
            this.width = this.image.getWidth(this);
            this.depth = this.image.getHeight(this);
            while (!(this.imageFailed || this.width != -1 && this.depth != -1)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.width = this.image.getWidth(this);
                this.depth = this.image.getHeight(this);
            }
            this.image.flush();
            if ((this.width == -1 || this.depth == -1) && this.imageFailed) {
                object = null;
                String string2 = null;
                int n = 100;
                try {
                    object = new BufferedReader(new FileReader(new File(string)));
                    string2 = ((BufferedReader)object).readLine();
                    if (string2 != null && string2.startsWith("%PDF-")) {
                        while (n > 0 && string2 != null) {
                            --n;
                            if (string2.startsWith("/CropBox [")) {
                                if ((string2 = string2.substring(10)).indexOf("]") >= 0) {
                                    string2 = string2.substring(0, string2.indexOf("]"));
                                }
                                this.parseBox(string2);
                                n = 0;
                            }
                            string2 = ((BufferedReader)object).readLine();
                        }
                    } else if (string2 != null && string2.startsWith("%!") && string2.indexOf(" EPSF-") > 0) {
                        while (n > 0 && string2 != null) {
                            --n;
                            if (string2.startsWith("%%BoundingBox: ")) {
                                string2 = string2.substring(15);
                                this.parseBox(string2);
                                n = 0;
                            }
                            string2 = ((BufferedReader)object).readLine();
                        }
                    } else {
                        System.err.println("Failed to interpret image: " + string);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Failed to load image: " + string);
                }
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.width < 0) {
                throw new XProcException("Failed to read image intrinsics");
            }
            object = new TreeWriter(MetadataExtractor.this.runtime);
            ((TreeWriter)object).startDocument(MetadataExtractor.this.step.getNode().getBaseURI());
            ((TreeWriter)object).addStartElement(c_metadata);
            ((TreeWriter)object).addAttribute(_href, string);
            ((TreeWriter)object).startContent();
            ((TreeWriter)object).addStartElement(c_tag);
            ((TreeWriter)object).addAttribute(_dir, "Exif");
            ((TreeWriter)object).addAttribute(_type, "0x9000");
            ((TreeWriter)object).addAttribute(_name, "Exif Version");
            ((TreeWriter)object).startContent();
            ((TreeWriter)object).addText("0");
            ((TreeWriter)object).addEndElement();
            ((TreeWriter)object).addStartElement(c_tag);
            ((TreeWriter)object).addAttribute(_dir, "Jpeg");
            ((TreeWriter)object).addAttribute(_type, "0x0001");
            ((TreeWriter)object).addAttribute(_name, "Image Height");
            ((TreeWriter)object).startContent();
            ((TreeWriter)object).addText("" + this.depth + " pixels");
            ((TreeWriter)object).addEndElement();
            ((TreeWriter)object).addStartElement(c_tag);
            ((TreeWriter)object).addAttribute(_dir, "Jpeg");
            ((TreeWriter)object).addAttribute(_type, "0x0003");
            ((TreeWriter)object).addAttribute(_name, "Image Width");
            ((TreeWriter)object).startContent();
            ((TreeWriter)object).addText("" + this.width + " pixels");
            ((TreeWriter)object).addEndElement();
            ((TreeWriter)object).endDocument();
            MetadataExtractor.this.result.write(((TreeWriter)object).getResult());
        }

        private void parseBox(String string) {
            int[] nArray = new int[4];
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (n < 4 && stringTokenizer.hasMoreTokens()) {
                try {
                    nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (Exception exception) {}
            }
            this.width = nArray[2] - nArray[0];
            this.depth = nArray[3] - nArray[1];
        }

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x40) == 64 || (n & 0x80) == 128) {
                this.imageFailed = true;
                return false;
            }
            return (n & 0x20) != 32;
        }
    }
}

