/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class ReportErrors
extends DefaultStep {
    private static final QName c_error = new QName("http://www.w3.org/ns/xproc-step", "error");
    private static final QName _code = new QName("code");
    private static final QName _code_prefix = new QName("code-prefix");
    private static final QName _code_namespace = new QName("code-namespace");
    private ReadablePipe source = null;
    private ReadablePipe report = null;
    private WritablePipe result = null;

    public ReportErrors(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else {
            this.report = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        XdmNode xdmNode;
        super.run();
        String string = null;
        String string2 = null;
        String string3 = null;
        RuntimeValue runtimeValue = this.getOption(_code);
        if (runtimeValue != null) {
            string = runtimeValue.getString();
            string2 = this.getOption(_code_prefix, (String)null);
            string3 = this.getOption(_code_namespace, (String)null);
        }
        if (string2 == null && string3 != null) {
            string2 = "ERR";
        }
        if (string2 != null && string3 == null) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (string3 != null && string.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the code name contains a colon");
        }
        QName qName = null;
        if (string != null) {
            qName = string.contains(":") ? new QName(string, runtimeValue.getNode()) : new QName(string2 == null ? "" : string2, string3, string);
        }
        while (this.report.moreDocuments()) {
            xdmNode = this.report.read();
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.DESCENDANT, c_error);
            if (xdmSequenceIterator.hasNext()) {
                while (xdmSequenceIterator.hasNext()) {
                    this.runtime.warning(this, xdmNode, xdmSequenceIterator.next().getStringValue());
                }
                continue;
            }
            this.runtime.warning(this, xdmNode, xdmNode.getStringValue());
        }
        if (qName != null) {
            throw new XProcException(qName, "error code?");
        }
        while (this.source.moreDocuments()) {
            xdmNode = this.source.read();
            this.runtime.finest(this, this.step.getNode(), "ReportErrors step " + this.step.getName() + " read " + xdmNode.getDocumentURI());
            this.result.write(xdmNode);
        }
    }
}

