/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class Uncompress
extends DefaultStep {
    protected static final String logger = "com.xmlcalabash.extensions.gunzip";
    private static final QName _compression_method = new QName("compression-method");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public Uncompress(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String string = this.getOption(_compression_method, "gzip");
        if (!"gzip".equals(string)) {
            throw XProcException.stepError(999, "The only compression method supported is 'gzip'.");
        }
        XdmNode xdmNode = S9apiUtils.getDocumentElement(this.source.read());
        byte[] byArray = null;
        if (!"base64".equals(xdmNode.getAttributeValue(_encoding))) {
            throw XProcException.stepError(999, "Input to cx:gunzip must be binary encoded data.");
        }
        byArray = Base64.decode(xdmNode.getStringValue());
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            XdmNode xdmNode2 = this.runtime.parse(inputSource);
            this.result.write(xdmNode2);
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
    }
}

