/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class Unzip
extends DefaultStep {
    protected static final QName _href = new QName("", "href");
    protected static final QName _content_type = new QName("", "content-type");
    protected static final QName c_zipfile = new QName("c", "http://www.w3.org/ns/xproc-step", "zipfile");
    protected static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    protected static final QName _file = new QName("", "file");
    protected static final QName _charset = new QName("", "charset");
    protected static final QName _name = new QName("", "name");
    protected static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    protected static final QName _compressed_size = new QName("", "compressed-size");
    protected static final QName _comment = new QName("", "comment");
    protected static final QName _size = new QName("", "size");
    protected static final QName _date = new QName("", "date");
    private WritablePipe result = null;
    private String zipFn = null;
    private URI zipURI = null;
    private String name = null;
    private String contentType = "application/xml";
    private String charset = null;

    public Unzip(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.zipFn = this.getOption(_href).getString();
        this.zipURI = this.getOption(_href).getBaseURI();
        if (this.getOption(_file) != null) {
            this.name = this.getOption(_file).getString();
        }
        if (this.getOption(_content_type) != null) {
            this.contentType = this.getOption(_content_type).getString();
        }
        if (this.getOption(_charset) != null) {
            this.charset = this.getOption(_charset).getString();
        }
        try {
            URL uRL = this.zipURI.resolve(this.zipFn).toURL();
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            TreeWriter treeWriter = new TreeWriter(this.runtime);
            if (this.name == null) {
                treeWriter.startDocument(this.step.getNode().getBaseURI());
                treeWriter.addStartElement(c_zipfile);
                treeWriter.addAttribute(_href, uRL.toString());
                treeWriter.startContent();
                DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    gregorianCalendar.setTimeInMillis(zipEntry.getTime());
                    XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
                    if (zipEntry.isDirectory()) {
                        treeWriter.addStartElement(c_directory);
                    } else {
                        treeWriter.addStartElement(c_file);
                        treeWriter.addAttribute(_compressed_size, "" + zipEntry.getCompressedSize());
                        treeWriter.addAttribute(_size, "" + zipEntry.getSize());
                    }
                    if (zipEntry.getComment() != null) {
                        treeWriter.addAttribute(_comment, zipEntry.getComment());
                    }
                    treeWriter.addAttribute(_name, "" + zipEntry.getName());
                    treeWriter.addAttribute(_date, xMLGregorianCalendar.toXMLFormat());
                    treeWriter.startContent();
                    treeWriter.addEndElement();
                    zipEntry = zipInputStream.getNextEntry();
                }
                zipInputStream.close();
                treeWriter.addEndElement();
                treeWriter.endDocument();
                this.result.write(treeWriter.getResult());
            } else {
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null && !this.name.equals(zipEntry.getName())) {
                    zipEntry = zipInputStream.getNextEntry();
                }
                if (zipEntry == null) {
                    throw new XProcException(this.step.getNode(), "ZIP file does not contain '" + this.name + "'");
                }
                if ("application/xml".equals(this.contentType) || "text/xml".equals(this.contentType) || this.contentType.endsWith("+xml")) {
                    InputSource inputSource = new InputSource(zipInputStream);
                    XdmNode xdmNode = this.runtime.parse(inputSource);
                    this.result.write(xdmNode);
                } else {
                    boolean bl = this.contentType != null && this.contentType.startsWith("text/") && this.charset != null;
                    treeWriter.startDocument(this.step.getNode().getBaseURI());
                    treeWriter.addStartElement(XProcConstants.c_data);
                    treeWriter.addAttribute(_name, this.name);
                    treeWriter.addAttribute(_content_type, this.contentType);
                    if (!bl) {
                        treeWriter.addAttribute(_encoding, "base64");
                    }
                    treeWriter.startContent();
                    if (bl) {
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)zipInputStream, this.charset);
                        int n = 4096;
                        char[] cArray = new char[n];
                        int n2 = inputStreamReader.read(cArray, 0, n);
                        while (n2 >= 0) {
                            if (n2 > 0) {
                                String string = new String(cArray);
                                treeWriter.addText(string);
                            }
                            n2 = inputStreamReader.read(cArray, 0, n);
                        }
                        inputStreamReader.close();
                    } else {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
                        int n = 12288;
                        byte[] byArray = new byte[n];
                        int n3 = bufferedInputStream.read(byArray, 0, n);
                        while (n3 >= 0) {
                            if (n3 > 0) {
                                String string = Base64.encodeBytes(byArray, 0, n3);
                                treeWriter.addText(string + "\n");
                            }
                            n3 = bufferedInputStream.read(byArray, 0, n);
                        }
                        bufferedInputStream.close();
                    }
                    treeWriter.addEndElement();
                    treeWriter.endDocument();
                    this.result.write(treeWriter.getResult());
                }
                zipInputStream.close();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new XProcException(XProcException.err_E0001, (Throwable)malformedURLException);
        }
        catch (IOException iOException) {
            throw new XProcException(XProcException.err_E0001, (Throwable)iOException);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new XProcException(XProcException.err_E0001, (Throwable)datatypeConfigurationException);
        }
    }
}

