/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class WaitForUpdate
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName _pause_before = new QName("", "pause-before");
    private static final QName _pause_after = new QName("", "pause-after");
    private static final long FILESYSTEM_WAIT = 100L;
    private static final long HTTP_WAIT = 1000L;
    private WritablePipe result = null;
    private URI uri = null;
    private long pauseBefore = 0L;
    private long pauseAfter = 0L;

    public WaitForUpdate(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String string = this.getOption(_href).getString();
        URI uRI = this.getOption(_href).getBaseURI();
        URI uRI2 = uRI.resolve(string);
        this.pauseBefore = this.getOption(_pause_before, 0L) * 1000L;
        this.pauseAfter = this.getOption(_pause_after, 0L) * 1000L;
        if (this.pauseBefore > 0L) {
            try {
                Thread.sleep(this.pauseBefore);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String string2 = "";
        if ("file".equals(uRI2.getScheme())) {
            string2 = this.waitForFile(uRI2);
        } else if ("http".equals(uRI2.getScheme()) || "https".equals(uRI2.getScheme())) {
            string2 = this.waitForHttp(uRI2);
        } else {
            throw new XProcException("Only http: and file: URIs are supported on cx:wait-for-update");
        }
        if (this.pauseAfter > 0L) {
            try {
                Thread.sleep(this.pauseAfter);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_result);
        treeWriter.startContent();
        treeWriter.addText(string2);
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }

    private String waitForFile(URI uRI) {
        long l;
        File file = new File(uRI.getPath());
        boolean bl = false;
        if (!file.exists()) {
            bl = true;
            this.runtime.fine(this, this.step.getNode(), "Exist wait: " + file.getAbsolutePath());
            if (this.runtime.getDebug()) {
                System.err.println("Exist wait: " + file.getAbsolutePath());
            }
            while (!file.exists()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        long l2 = l = file.lastModified();
        if (!bl) {
            this.runtime.fine(this, this.step.getNode(), "Update wait: " + file.getAbsolutePath());
            if (this.runtime.getDebug()) {
                System.err.println("Update wait: " + file.getAbsolutePath());
            }
            while (l2 == l) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = file.lastModified();
            }
        }
        Calendar calendar = GregorianCalendar.getInstance();
        TimeZone timeZone = TimeZone.getDefault();
        long l3 = l2 - (long)timeZone.getRawOffset();
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(calendar.getTime())) {
            l3 -= (long)timeZone.getDSTSavings();
        }
        calendar.setTimeInMillis(l3);
        return String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02dZ", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    private String waitForHttp(URI uRI) {
        long l;
        SystemDefaultHttpClient systemDefaultHttpClient = new SystemDefaultHttpClient();
        systemDefaultHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, false));
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        HttpHead httpHead = new HttpHead(uRI);
        HttpResponse httpResponse = null;
        httpResponse = this.head(systemDefaultHttpClient, (HttpUriRequest)httpHead, (HttpContext)basicHttpContext);
        int n = httpResponse.getStatusLine().getStatusCode();
        Object var7_7 = null;
        boolean bl = false;
        if (n == 404) {
            bl = true;
            this.runtime.fine(this, this.step.getNode(), "Exist wait: " + uRI.toASCIIString());
            if (this.runtime.getDebug()) {
                System.err.println("Exist wait: " + uRI.toASCIIString());
            }
            while (n == 404) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                httpResponse = this.head(systemDefaultHttpClient, (HttpUriRequest)httpHead, (HttpContext)basicHttpContext);
                n = httpResponse.getStatusLine().getStatusCode();
            }
        }
        long l2 = l = this.lastModified(httpResponse);
        if (n == 200 && !bl) {
            this.runtime.fine(this, this.step.getNode(), "Update wait: " + uRI.toASCIIString());
            if (this.runtime.getDebug()) {
                System.err.println("Update wait: " + uRI.toASCIIString());
            }
            while (n == 200 && l2 == l) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                httpResponse = this.head(systemDefaultHttpClient, (HttpUriRequest)httpHead, (HttpContext)basicHttpContext);
                n = httpResponse.getStatusLine().getStatusCode();
                l2 = this.lastModified(httpResponse);
            }
        }
        Calendar calendar = GregorianCalendar.getInstance();
        TimeZone timeZone = TimeZone.getDefault();
        long l3 = l2 - (long)timeZone.getRawOffset();
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(calendar.getTime())) {
            l3 -= (long)timeZone.getDSTSavings();
        }
        calendar.setTimeInMillis(l3);
        return String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02dZ", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    private long lastModified(HttpResponse httpResponse) {
        String string = this.getHeader(httpResponse, "Last-modified", null);
        if (string == null) {
            string = this.getHeader(httpResponse, "Date", null);
        }
        try {
            Date date = DateUtils.parseDate((String)string);
            return date.getTime();
        }
        catch (DateParseException dateParseException) {
            return GregorianCalendar.getInstance().getTimeInMillis();
        }
    }

    private HttpResponse head(SystemDefaultHttpClient systemDefaultHttpClient, HttpUriRequest httpUriRequest, HttpContext httpContext) {
        try {
            return systemDefaultHttpClient.execute(httpUriRequest, httpContext);
        }
        catch (ClientProtocolException clientProtocolException) {
            throw new XProcException(clientProtocolException);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }

    private String getHeader(HttpResponse httpResponse, String string, String string2) {
        Header[] headerArray = httpResponse.getHeaders(string);
        if (headerArray == null) {
            return string2;
        }
        if (headerArray == null || headerArray.length == 0) {
            return string2;
        }
        return headerArray[0].getValue();
    }
}

