/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.library.HttpRequest;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;

public class Zip
extends DefaultStep {
    protected static final QName _href = new QName("", "href");
    protected static final QName _name = new QName("", "name");
    protected static final QName _command = new QName("", "command");
    protected static final QName _compression_method = new QName("", "compression-method");
    protected static final QName _compression_level = new QName("", "compression-level");
    protected static final QName c_zip_manifest = new QName("c", "http://www.w3.org/ns/xproc-step", "zip-manifest");
    protected static final QName c_zipfile = new QName("c", "http://www.w3.org/ns/xproc-step", "zipfile");
    protected static final QName c_entry = new QName("c", "http://www.w3.org/ns/xproc-step", "entry");
    protected static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    protected static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    protected static final QName _compressed_size = new QName("", "compressed-size");
    protected static final QName _comment = new QName("", "comment");
    protected static final QName _size = new QName("", "size");
    protected static final QName _date = new QName("", "date");
    private static final QName _status_only = new QName("status-only");
    private static final QName _detailed = new QName("detailed");
    private static final QName _status = new QName("status");
    private static final QName _value = new QName("value");
    private static final int bufsize = 8192;
    private static final QName[] serializerAttrs = new QName[]{_byte_order_mark, _cdata_section_elements, _doctype_public, _doctype_system, _encoding, _escape_uri_attributes, _include_content_type, _indent, _media_type, _method, _normalization_form, _omit_xml_declaration, _standalone, _undeclare_prefixes, _version};
    private ReadablePipe source = null;
    private ReadablePipe manifest = null;
    private WritablePipe result = null;
    private Map<String, FileToZip> zipManifest = new LinkedHashMap<String, FileToZip>();
    private Map<String, XdmNode> srcManifest = new LinkedHashMap<String, XdmNode>();

    public Zip(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else {
            this.manifest = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.manifest.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        Object object;
        Object object2;
        super.run();
        String string = this.getOption(_href).getString();
        XdmNode xdmNode = S9apiUtils.getDocumentElement(this.manifest.read());
        if (!c_zip_manifest.equals((Object)xdmNode.getNodeName())) {
            throw new XProcException(this.step.getNode(), "The cx:zip manifest must be a c:zip-manifest.");
        }
        while (this.source.moreDocuments()) {
            object2 = this.source.read();
            object = S9apiUtils.getDocumentElement((XdmNode)object2);
            this.srcManifest.put(object.getBaseURI().toASCIIString(), (XdmNode)object2);
        }
        this.parseManifest(xdmNode);
        object2 = null;
        try {
            object2 = new File(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XProcException(uRISyntaxException);
        }
        object = ((File)object2).getParentFile();
        File file = null;
        ZipFile zipFile = null;
        ZipOutputStream zipOutputStream = null;
        try {
            file = File.createTempFile("calabashZip", ".zip", (File)object);
            file.deleteOnExit();
            if (((File)object2).exists()) {
                zipFile = new ZipFile((File)object2);
            }
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        String string2 = this.getOption(_command).getString();
        if ("create".equals(string2)) {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                throw new XProcException(iOException);
            }
            zipFile = null;
        }
        if ("update".equals(string2) || "create".equals(string2)) {
            this.update(zipFile, zipOutputStream, false);
        } else if ("freshen".equals(string2)) {
            this.update(zipFile, zipOutputStream, true);
        } else if ("delete".equals(string2)) {
            this.delete(zipFile, zipOutputStream);
        } else {
            throw new XProcException(this.step.getNode(), "Unexpected cx:zip command: " + string2);
        }
        if (((File)object2).exists()) {
            ((File)object2).delete();
        }
        file.renameTo((File)object2);
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(c_zipfile);
        treeWriter.addAttribute(_href, ((File)object2).toURI().toASCIIString());
        treeWriter.startContent();
        try {
            URL uRL = ((File)object2).toURI().toURL();
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                gregorianCalendar.setTimeInMillis(zipEntry.getTime());
                XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
                if (zipEntry.isDirectory()) {
                    treeWriter.addStartElement(c_directory);
                } else {
                    treeWriter.addStartElement(c_file);
                    treeWriter.addAttribute(_compressed_size, "" + zipEntry.getCompressedSize());
                    treeWriter.addAttribute(_size, "" + zipEntry.getSize());
                }
                if (zipEntry.getComment() != null) {
                    treeWriter.addAttribute(_comment, zipEntry.getComment());
                }
                treeWriter.addAttribute(_name, "" + zipEntry.getName());
                treeWriter.addAttribute(_date, xMLGregorianCalendar.toXMLFormat());
                treeWriter.startContent();
                treeWriter.addEndElement();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            throw new XProcException(XProcException.err_E0001, (Throwable)malformedURLException);
        }
        catch (IOException iOException) {
            throw new XProcException(XProcException.err_E0001, (Throwable)iOException);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new XProcException(XProcException.err_E0001, (Throwable)datatypeConfigurationException);
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }

    private void parseManifest(XdmNode xdmNode) {
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            if (XdmNodeKind.ELEMENT == xdmNode2.getNodeKind()) {
                if (c_entry.equals((Object)xdmNode2.getNodeName())) {
                    String string = xdmNode2.getAttributeValue(_name);
                    if (string == null || "".equals(string)) {
                        throw new XProcException(this.step.getNode(), "Missing or invalid name in cx:zip manifest.");
                    }
                    String string2 = xdmNode2.getAttributeValue(_href);
                    if (string2 == null || "".equals(string2)) {
                        throw new XProcException(this.step.getNode(), "Missing or invalid href in cx:zip manifest.");
                    }
                    String string3 = xdmNode2.getBaseURI().resolve(string2).toASCIIString();
                    String string4 = xdmNode2.getAttributeValue(_comment);
                    int n = 8;
                    int n2 = -1;
                    String string5 = xdmNode2.getAttributeValue(_compression_method);
                    if ("stored".equals(string5)) {
                        n = 0;
                    }
                    if ("smallest".equals(string5 = xdmNode2.getAttributeValue(_compression_level))) {
                        n2 = 9;
                    } else if ("fastest".equals(string5)) {
                        n2 = 1;
                    } else if ("huffman".equals(string5)) {
                        n2 = 2;
                    } else if ("none".equals(string5)) {
                        n2 = 0;
                        n = 0;
                    }
                    this.zipManifest.put(string, new FileToZip(string, string3, n, n2, string4, xdmNode2));
                    continue;
                }
                throw new XProcException(this.step.getNode(), "Unexpected element in cx:zip manifest: " + xdmNode2.getNodeName());
            }
            throw new XProcException(this.step.getNode(), "Unexpected content in cx:zip manifest.");
        }
    }

    public void update(ZipFile zipFile, ZipOutputStream zipOutputStream, boolean bl) {
        byte[] byArray = new byte[8192];
        try {
            Object object;
            Object object2;
            if (zipFile != null) {
                object2 = zipFile.entries();
                while (object2.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)object2.nextElement();
                    String string = zipEntry.getName();
                    boolean bl2 = this.srcManifest.containsKey(string);
                    if (!bl2) {
                        if (this.zipManifest.containsKey(string) && bl) {
                            object = this.zipManifest.get(string);
                            long l = zipEntry.getTime();
                            long l2 = ((FileToZip)object).getLastModified();
                            boolean bl3 = bl2 = l2 > l;
                            if (!bl2) {
                                this.zipManifest.remove(string);
                            }
                        } else if (this.zipManifest.containsKey(string)) {
                            bl2 = true;
                        }
                    }
                    if (bl2) continue;
                    zipOutputStream.putNextEntry(zipEntry);
                    object = zipFile.getInputStream(zipEntry);
                    int n = ((InputStream)object).read(byArray, 0, 8192);
                    while (n >= 0) {
                        zipOutputStream.write(byArray, 0, n);
                        n = ((InputStream)object).read(byArray, 0, 8192);
                    }
                    ((InputStream)object).close();
                    zipOutputStream.closeEntry();
                }
            }
            object2 = new CRC32();
            for (String string : this.zipManifest.keySet()) {
                int n;
                InputStream inputStream;
                Object object3;
                Object object4;
                FileToZip fileToZip = this.zipManifest.get(string);
                object = new ZipEntry(string);
                if (fileToZip.getComment() != null) {
                    ((ZipEntry)object).setComment(fileToZip.getComment());
                }
                ((ZipEntry)object).setMethod(fileToZip.getMethod());
                zipOutputStream.setLevel(fileToZip.getLevel());
                URI uRI = this.zipManifest.get(string).getHref();
                String string2 = uRI.toASCIIString();
                if (((ZipEntry)object).getMethod() == 0) {
                    object4 = new ByteArrayOutputStream();
                    if (this.srcManifest.containsKey(uRI.toString())) {
                        object3 = this.srcManifest.get(string2);
                        inputStream = this.makeSerializer(fileToZip.getOptions());
                        inputStream.setOutputStream((OutputStream)object4);
                        S9apiUtils.serialize(this.runtime, (XdmNode)object3, (Serializer)inputStream);
                    } else {
                        object3 = uRI.toURL().openConnection();
                        inputStream = ((URLConnection)object3).getInputStream();
                        n = inputStream.read(byArray, 0, 8192);
                        while (n > 0) {
                            ((ByteArrayOutputStream)object4).write(byArray, 0, n);
                            n = inputStream.read(byArray, 0, 8192);
                        }
                        inputStream.close();
                    }
                    object3 = ((ByteArrayOutputStream)object4).toByteArray();
                    ((ZipEntry)object).setSize(((Object)object3).length);
                    ((CRC32)object2).reset();
                    object2.update((byte[])object3);
                    ((ZipEntry)object).setCrc(((CRC32)object2).getValue());
                }
                zipOutputStream.putNextEntry((ZipEntry)object);
                if (this.srcManifest.containsKey(string2)) {
                    object4 = this.srcManifest.get(string2);
                    object3 = this.makeSerializer(fileToZip.getOptions());
                    object3.setOutputStream((OutputStream)zipOutputStream);
                    S9apiUtils.serialize(this.runtime, (XdmNode)object4, (Serializer)object3);
                } else {
                    object4 = uRI.toURL();
                    object3 = ((URL)object4).openConnection();
                    inputStream = ((URLConnection)object3).getInputStream();
                    n = inputStream.read(byArray, 0, 8192);
                    while (n >= 0) {
                        zipOutputStream.write(byArray, 0, n);
                        n = inputStream.read(byArray, 0, 8192);
                    }
                    inputStream.close();
                }
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
    }

    public void delete(ZipFile zipFile, ZipOutputStream zipOutputStream) {
        try {
            if (zipFile != null) {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string = zipEntry.getName();
                    boolean bl = false;
                    if (this.zipManifest.containsKey(string)) {
                        bl = true;
                    }
                    if (bl) continue;
                    zipOutputStream.putNextEntry(zipEntry);
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    byte[] byArray = new byte[8192];
                    int n = inputStream.read(byArray, 0, 8192);
                    while (n >= 0) {
                        zipOutputStream.write(byArray, 0, n);
                        n = inputStream.read(byArray, 0, 8192);
                    }
                    inputStream.close();
                    zipOutputStream.closeEntry();
                }
            }
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }

    public Serializer makeSerializer(Hashtable<QName, String> hashtable) {
        String string;
        Serializer serializer = new Serializer();
        if (hashtable == null) {
            return serializer;
        }
        if (hashtable.containsKey(_byte_order_mark)) {
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "false".equals(hashtable.get(_byte_order_mark)) ? "yes" : "no");
        }
        if (hashtable.containsKey(_cdata_section_elements) && !"".equals(string = hashtable.get(_cdata_section_elements))) {
            String[] stringArray = string.split("\\s+");
            string = "";
            for (String string2 : stringArray) {
                QName qName = new QName(string2, this.step.getNode());
                string = string + qName.getClarkName() + " ";
            }
            serializer.setOutputProperty(Serializer.Property.CDATA_SECTION_ELEMENTS, string);
        }
        if (hashtable.containsKey(_doctype_public)) {
            serializer.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, hashtable.get(_doctype_public));
        }
        if (hashtable.containsKey(_doctype_system)) {
            serializer.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, hashtable.get(_doctype_system));
        }
        if (hashtable.containsKey(_encoding)) {
            serializer.setOutputProperty(Serializer.Property.ENCODING, hashtable.get(_encoding));
        }
        if (hashtable.containsKey(_escape_uri_attributes)) {
            serializer.setOutputProperty(Serializer.Property.ESCAPE_URI_ATTRIBUTES, "true".equals(hashtable.get(_escape_uri_attributes)) ? "yes" : "no");
        }
        if (hashtable.containsKey(_include_content_type)) {
            serializer.setOutputProperty(Serializer.Property.INCLUDE_CONTENT_TYPE, "true".equals(hashtable.get(_include_content_type)) ? "yes" : "no");
        }
        if (hashtable.containsKey(_indent)) {
            serializer.setOutputProperty(Serializer.Property.INDENT, "true".equals(hashtable.get(_indent)) ? "yes" : "no");
        }
        if (hashtable.containsKey(_media_type)) {
            serializer.setOutputProperty(Serializer.Property.MEDIA_TYPE, hashtable.get(_media_type));
        }
        if (hashtable.containsKey(_method)) {
            serializer.setOutputProperty(Serializer.Property.METHOD, hashtable.get(_method));
        }
        if (hashtable.containsKey(_normalization_form)) {
            serializer.setOutputProperty(Serializer.Property.NORMALIZATION_FORM, hashtable.get(_normalization_form));
        }
        if (hashtable.containsKey(_omit_xml_declaration)) {
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "true".equals(hashtable.get(_omit_xml_declaration)) ? "yes" : "no");
        }
        if (hashtable.containsKey(_standalone)) {
            string = hashtable.get(_standalone);
            if ("true".equals(string)) {
                serializer.setOutputProperty(Serializer.Property.STANDALONE, "yes");
            } else if ("false".equals(string)) {
                serializer.setOutputProperty(Serializer.Property.STANDALONE, "no");
            }
        }
        if (hashtable.containsKey(_undeclare_prefixes)) {
            serializer.setOutputProperty(Serializer.Property.UNDECLARE_PREFIXES, "true".equals(hashtable.get(_undeclare_prefixes)) ? "yes" : "no");
        }
        if (hashtable.containsKey(_version)) {
            serializer.setOutputProperty(Serializer.Property.VERSION, hashtable.get(_version));
        }
        return serializer;
    }

    private class FileToZip {
        private String zipName = null;
        private URI href = null;
        private String origHref = null;
        private int method = -1;
        private int level = -1;
        private String comment = null;
        private long lastModified = -1L;
        private Hashtable<QName, String> options = null;

        public FileToZip(String string, String string2, int n, int n2, String string3, XdmNode xdmNode) {
            try {
                this.origHref = string2;
                this.zipName = string;
                this.href = new URI(string2);
                this.method = n;
                this.level = n2;
                this.comment = string3;
                this.lastModified = this.readLastModified(this.href);
                for (QName qName : serializerAttrs) {
                    String string4 = xdmNode.getAttributeValue(qName);
                    if (string4 == null) continue;
                    if (this.options == null) {
                        this.options = new Hashtable();
                    }
                    this.options.put(qName, string4);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XProcException(uRISyntaxException);
            }
        }

        public String getName() {
            return this.zipName;
        }

        public URI getHref() {
            return this.href;
        }

        public int getMethod() {
            return this.method;
        }

        public int getLevel() {
            return this.level;
        }

        public String getComment() {
            return this.comment;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public Hashtable<QName, String> getOptions() {
            return this.options;
        }

        private long readLastModified(URI uRI) {
            if (Zip.this.srcManifest.containsKey(this.origHref)) {
                Date date = new Date();
                return date.getTime();
            }
            if (uRI.getScheme().equals("file")) {
                String string = uRI.toASCIIString();
                if (string.startsWith("file:") && (string = string.substring(5)).startsWith("///")) {
                    string = string.substring(2);
                }
                File file = new File(string);
                return file.lastModified();
            }
            HttpRequest httpRequest = new HttpRequest(Zip.this.runtime, Zip.this.step);
            Pipe pipe = new Pipe(Zip.this.runtime);
            Pipe pipe2 = new Pipe(Zip.this.runtime);
            httpRequest.setInput("source", pipe);
            httpRequest.setOutput("result", pipe2);
            TreeWriter treeWriter = new TreeWriter(Zip.this.runtime);
            treeWriter.startDocument(Zip.this.step.getNode().getBaseURI());
            treeWriter.addStartElement(XProcConstants.c_request);
            treeWriter.addAttribute(DefaultStep._method, "HEAD");
            treeWriter.addAttribute(_href, uRI.toASCIIString());
            treeWriter.addAttribute(_status_only, "true");
            treeWriter.addAttribute(_detailed, "true");
            treeWriter.startContent();
            treeWriter.addEndElement();
            treeWriter.endDocument();
            pipe.write(treeWriter.getResult());
            try {
                httpRequest.run();
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
            XdmNode xdmNode = S9apiUtils.getDocumentElement(pipe2.read());
            int n = Integer.parseInt(xdmNode.getAttributeValue(_status));
            if (n == 200) {
                for (XdmNode xdmNode2 : new RelevantNodes(Zip.this.runtime, xdmNode, Axis.CHILD)) {
                    if (!"Last-Modified".equals(xdmNode2.getAttributeValue(_name))) continue;
                    String[] stringArray = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
                    String string = xdmNode2.getAttributeValue(_value);
                    int n2 = Integer.parseInt(string.substring(5, 7));
                    String string2 = string.substring(8, 11).toUpperCase();
                    int n3 = Integer.parseInt(string.substring(12, 16));
                    int n4 = Integer.parseInt(string.substring(17, 19));
                    int n5 = Integer.parseInt(string.substring(20, 22));
                    int n6 = Integer.parseInt(string.substring(23, 25));
                    String string3 = string.substring(26, 29);
                    int n7 = 0;
                    for (n7 = 0; n7 < 12 && !stringArray[n7].equals(string2); ++n7) {
                    }
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    gregorianCalendar.set(n3, n7, n2, n4, n5, n6);
                    return gregorianCalendar.getTimeInMillis();
                }
                return -1L;
            }
            return -1L;
        }
    }
}

