/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Delete
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _recursive = new QName("recursive");
    private static final QName _fail_on_error = new QName("fail-on-error");
    private WritablePipe result = null;

    public Delete(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        boolean bl = this.getOption(_recursive, false);
        boolean bl2 = this.getOption(_fail_on_error, true);
        RuntimeValue runtimeValue = this.getOption(_href);
        URI uRI = runtimeValue.getBaseURI().resolve(runtimeValue.getString());
        if (!"file".equals(uRI.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the delete step.");
        }
        File file = new File(uRI.getPath());
        if (!file.exists()) {
            if (bl2) {
                throw new XProcException(this.step.getNode(), "Cannot delete: file does not exist: " + file.getAbsolutePath());
            }
        } else {
            TreeWriter treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(XProcConstants.c_result);
            treeWriter.startContent();
            treeWriter.addText(file.toURI().toASCIIString());
            this.performDelete(file, bl, bl2);
            treeWriter.addEndElement();
            treeWriter.endDocument();
            this.result.write(treeWriter.getResult());
        }
    }

    private void performDelete(File file, boolean bl, boolean bl2) {
        if (bl && file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.performDelete(file2, bl, bl2);
            }
        }
        if (!file.delete() && bl2) {
            throw new XProcException(this.step.getNode(), "Delete failed for: " + file.getAbsolutePath());
        }
    }
}

