/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.marklogic;

import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Session;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class XCCInsertDocument
extends DefaultStep {
    private static final QName _user = new QName("", "user");
    private static final QName _password = new QName("", "password");
    private static final QName _host = new QName("", "host");
    private static final QName _port = new QName("", "port");
    private static final QName _contentBase = new QName("", "content-base");
    private static final QName _bufferSize = new QName("", "buffer-size");
    private static final QName _collections = new QName("", "collections");
    private static final QName _format = new QName("", "format");
    private static final QName _language = new QName("", "language");
    private static final QName _locale = new QName("", "locale");
    private static final QName _uri = new QName("", "uri");
    private static final QName _encoding = new QName("encoding");
    private static final QName _auth_method = new QName("auth-method");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public XCCInsertDocument(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        ContentSource contentSource;
        Locale locale;
        Object object;
        Serializer serializer;
        super.run();
        String string = this.getOption(_host, "");
        int n = this.getOption(_port, 0);
        String string2 = this.getOption(_user, "");
        String string3 = this.getOption(_password, "");
        String string4 = this.getOption(_contentBase, "");
        String string5 = "xml";
        if (this.getOption(_format) != null) {
            string5 = this.getOption(_format).getString();
        }
        if (!("xml".equals(string5) || "text".equals(string5) || "binary".equals(string5))) {
            throw new UnsupportedOperationException("Format must be 'xml', 'text', or 'binary'.");
        }
        XdmNode xdmNode = this.source.read();
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        String string6 = null;
        byte[] byArray = null;
        if ("xml".equals(string5)) {
            serializer = this.makeSerializer();
            object = new ByteArrayOutputStream();
            serializer.setOutputStream((OutputStream)object);
            S9apiUtils.serialize(this.runtime, xdmNode, serializer);
            try {
                string6 = object.toString("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XProcException(unsupportedEncodingException);
            }
        } else if ("text".equals(string5)) {
            string6 = xdmNode.getStringValue();
        } else if ("base64".equals(xdmNode2.getAttributeValue(_encoding))) {
            byArray = Base64.decode(xdmNode.getStringValue());
        } else if (xdmNode2.getAttributeValue(_encoding) == null) {
            string6 = xdmNode2.getStringValue();
        } else {
            throw new UnsupportedOperationException("Binary content must be base64 encoded.");
        }
        serializer = ContentCreateOptions.newXmlInstance();
        if ("xml".equals(string5)) {
            serializer.setFormatXml();
            serializer.setEncoding("UTF-8");
        }
        if ("text".equals(string5)) {
            serializer.setFormatText();
            serializer.setEncoding("UTF-8");
        }
        if ("binary".equals(string5)) {
            serializer.setFormatBinary();
        }
        if (this.getOption(_bufferSize) != null) {
            serializer.setBufferSize(this.getOption(_bufferSize).getInt());
        }
        if (this.getOption(_collections) != null) {
            object = this.getOption(_collections).getString().split("\\s+");
            serializer.setCollections(object);
        }
        if (this.getOption(_language) != null) {
            serializer.setLanguage(this.getOption(_language).getString());
        }
        if (this.getOption(_locale) != null) {
            object = this.getOption(_locale).getString();
            locale = new Locale((String)object);
            serializer.setLocale(locale);
        }
        object = this.getOption(_uri).getString();
        locale = null;
        locale = byArray == null ? ContentFactory.newContent((String)object, (String)string6, (ContentCreateOptions)serializer) : ContentFactory.newContent((String)object, (byte[])byArray, (ContentCreateOptions)serializer);
        try {
            contentSource = "".equals(string4) ? ContentSourceFactory.newContentSource((String)string, (int)n, (String)string2, (String)string3) : ContentSourceFactory.newContentSource((String)string, (int)n, (String)string2, (String)string3, (String)string4);
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
        if ("basic".equals(this.getOption(_auth_method, ""))) {
            contentSource.setAuthenticationPreemptive(true);
        }
        try {
            Session session = contentSource.newSession();
            session.insertContent((Content)locale);
            session.close();
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_result);
        treeWriter.startContent();
        treeWriter.addText((String)object);
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

