/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.SequenceType;

public class ResolveURI
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "resolve-uri");

    protected ResolveURI() {
    }

    public ResolveURI(XProcRuntime xProcRuntime) {
        this.tl_runtime.set(xProcRuntime);
    }

    public StructuredQName getFunctionQName() {
        return funcname;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_STRING};
    }

    public SequenceType getResultType(SequenceType[] sequenceTypeArray) {
        return SequenceType.SINGLE_ATOMIC;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ResolveURICall();
    }

    private class ResolveURICall
    extends ExtensionFunctionCall {
        private ResolveURICall() {
        }

        public Sequence call(XPathContext xPathContext, Sequence[] sequenceArray) throws XPathException {
            Object object;
            String string = sequenceArray[0].head().getStringValue();
            XProcRuntime xProcRuntime = (XProcRuntime)ResolveURI.this.tl_runtime.get();
            XStep xStep = xProcRuntime.getXProcData().getStep();
            if (xStep != null && !(xStep instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            String string2 = null;
            if (sequenceArray.length > 1) {
                string2 = sequenceArray[1].head().getStringValue();
            } else {
                string2 = xProcRuntime.getStaticBaseURI().toASCIIString();
                try {
                    object = xPathContext.getContextItem();
                    string2 = ((TinyDocumentImpl)object).getBaseURI();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                object = net.sf.saxon.functions.ResolveURI.makeAbsolute((String)string, (String)string2);
                String string3 = ((URI)object).toASCIIString();
                return new AnyURIValue((CharSequence)string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XProcException(uRISyntaxException);
            }
        }
    }
}

