/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "system-property");

    protected SystemProperty() {
    }

    public SystemProperty(XProcRuntime xProcRuntime) {
        this.tl_runtime.set(xProcRuntime);
    }

    public StructuredQName getFunctionQName() {
        return funcname;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] sequenceTypeArray) {
        return SequenceType.SINGLE_STRING;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new SystemPropertyCall();
    }

    private class SystemPropertyCall
    extends ExtensionFunctionCall {
        private StaticContext staticContext = null;

        private SystemPropertyCall() {
        }

        public void supplyStaticContext(StaticContext staticContext, int n, Expression[] expressionArray) throws XPathException {
            this.staticContext = staticContext;
        }

        public Sequence call(XPathContext xPathContext, Sequence[] sequenceArray) throws XPathException {
            String string;
            StructuredQName structuredQName = null;
            XProcRuntime xProcRuntime = (XProcRuntime)SystemProperty.this.tl_runtime.get();
            XStep xStep = xProcRuntime.getXProcData().getStep();
            if (xStep != null && !(xStep instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            try {
                string = sequenceArray[0].head().getStringValue();
                structuredQName = StructuredQName.fromLexicalQName((CharSequence)string, (boolean)false, (boolean)false, (NameChecker)xPathContext.getConfiguration().getNameChecker(), (NamespaceResolver)this.staticContext.getNamespaceResolver());
            }
            catch (XPathException xPathException) {
                if (xPathException.getErrorCodeLocalPart() == null || xPathException.getErrorCodeLocalPart().equals("FOCA0002") || xPathException.getErrorCodeLocalPart().equals("FONS0004")) {
                    xPathException.setErrorCode("XTDE1390");
                }
                throw xPathException;
            }
            string = structuredQName.getURI();
            String string2 = structuredQName.getLocalPart();
            String string3 = "";
            if (string.equals("http://www.w3.org/ns/xproc")) {
                if ("episode".equals(string2)) {
                    string3 = xProcRuntime.getEpisode();
                } else if ("language".equals(string2)) {
                    string3 = xProcRuntime.getLanguage();
                } else if ("product-name".equals(string2)) {
                    string3 = xProcRuntime.getProductName();
                } else if ("product-version".equals(string2)) {
                    string3 = xProcRuntime.getProductVersion();
                } else if ("vendor".equals(string2)) {
                    string3 = xProcRuntime.getVendor();
                } else if ("vendor-uri".equals(string2)) {
                    string3 = xProcRuntime.getVendorURI();
                } else if ("version".equals(string2)) {
                    string3 = xProcRuntime.getXProcVersion();
                } else if ("xpath-version".equals(string2)) {
                    string3 = xProcRuntime.getXPathVersion();
                } else if ("psvi-supported".equals(string2)) {
                    string3 = xProcRuntime.getPSVISupported() ? "true" : "false";
                }
            } else if (string.equals("http://xmlcalabash.com/ns/extensions")) {
                if ("transparent-json".equals(string2)) {
                    string3 = xProcRuntime.transparentJSON() ? "true" : "false";
                } else if ("json-flavor".equals(string2)) {
                    string3 = xProcRuntime.jsonFlavor();
                } else if ("general-values".equals(string2)) {
                    string3 = xProcRuntime.getAllowGeneralExpressions() ? "true" : "false";
                } else if ("xpointer-on-text".equals(string2)) {
                    string3 = xProcRuntime.getAllowXPointerOnText() ? "true" : "false";
                } else if ("use-xslt-1.0".equals(string2) || "use-xslt-10".equals(string2)) {
                    string3 = xProcRuntime.getUseXslt10Processor() ? "true" : "false";
                } else if ("saxon-version".equals(string2)) {
                    string3 = xProcRuntime.getConfiguration().getProcessor().getSaxonProductVersion();
                } else if ("saxon-edition".equals(string2)) {
                    string3 = xProcRuntime.getConfiguration().saxonProcessor;
                }
            }
            return new StringValue((CharSequence)string3);
        }
    }
}

