/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.PipeLogger;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Vector;
import net.sf.saxon.s9api.XdmNode;

public class DocumentSequence {
    protected static final String logger = "com.xmlcalabash.io.documentsequence";
    private XProcRuntime runtime = null;
    private Vector<XdmNode> documents = new Vector();
    private boolean closed = false;
    private static int idCounter = 0;
    private int id = 0;
    private PipeLogger outputlog = null;
    private int readerCount = 0;

    public DocumentSequence(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
        this.id = idCounter++;
    }

    public void addReader() {
        ++this.readerCount;
    }

    public int getReaderCount() {
        return this.readerCount;
    }

    public void setLogger(Log log) {
        if (log != null) {
            this.outputlog = new PipeLogger(this.runtime, log);
        }
    }

    public void add(XdmNode xdmNode) {
        if (this.closed) {
            throw new XProcException("You can't add a document to a closed DocumentSequence.");
        }
        S9apiUtils.assertDocument(xdmNode);
        this.documents.add(xdmNode);
        if (this.outputlog != null) {
            this.outputlog.log(xdmNode);
        }
    }

    public XdmNode get(int n) {
        if (n < this.documents.size()) {
            XdmNode xdmNode = this.documents.get(n);
            return xdmNode;
        }
        return null;
    }

    public void close() {
        --this.readerCount;
        this.closed = true;
        if (this.outputlog != null) {
            this.outputlog.stopLogging();
        }
    }

    public boolean closed() {
        return this.closed;
    }

    public int size() {
        return this.documents.size();
    }

    public void reset() {
        this.documents.clear();
        this.closed = false;
        if (this.outputlog != null) {
            this.outputlog.stopLogging();
        }
    }

    public String toString() {
        return "[document-sequence #" + this.id + " (" + this.documents.size() + " docs)]";
    }
}

