/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.S9apiUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class PipeLogger {
    private static final QName cx_basename = new QName("cx", "http://xmlcalabash.com/ns/extensions", "basename");
    private static final QName cx_logstyle = new QName("cx", "http://xmlcalabash.com/ns/extensions", "logstyle");
    private Log log = null;
    private Serializer serializer = null;
    private PrintStream stream = null;
    private XProcRuntime runtime = null;
    private boolean logging = false;
    private XProcConfiguration config = null;
    private LogOptions logstyle = null;
    private String basename = null;
    private File baseDir = null;
    private int outputCount = 1;

    public PipeLogger(XProcRuntime xProcRuntime, Log log) {
        this.runtime = xProcRuntime;
        this.log = log;
        this.config = xProcRuntime.getConfiguration();
        this.basename = this.runtime.getEpisode();
        this.logstyle = this.config.logOpt;
        String string = log.getExtensionAttribute(cx_basename);
        if (string != null) {
            this.basename = string;
        }
        string = log.getExtensionAttribute(cx_logstyle);
        if (this.logstyle != LogOptions.OFF && string != null) {
            if (string.equals("off")) {
                this.logstyle = LogOptions.OFF;
            } else if (string.equals("plain")) {
                this.logstyle = LogOptions.PLAIN;
            } else if (string.equals("wrapped")) {
                this.logstyle = LogOptions.WRAPPED;
            } else if (string.equals("directory")) {
                this.logstyle = LogOptions.DIRECTORY;
            } else {
                System.err.println("Invalid cx:logstyle ignored: " + string);
            }
        }
        if (this.logstyle == LogOptions.OFF) {
            return;
        }
        this.serializer = new Serializer();
        this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        this.serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
        this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        switch (this.logstyle) {
            case PLAIN: 
            case WRAPPED: {
                if (log.getHref() == null) {
                    this.stream = System.out;
                    break;
                }
                try {
                    String string2 = log.getHref().toASCIIString();
                    if (string2.startsWith("file:///")) {
                        string2 = string2.substring(7);
                    } else if (string2.startsWith("file:/")) {
                        string2 = string2.substring(5);
                    }
                    this.stream = new PrintStream(new File(string2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("Failed to create log: " + log.getHref());
                    this.stream = System.err;
                }
                break;
            }
            case DIRECTORY: {
                String string3 = null;
                if (log.getHref() != null) {
                    if (log.getHref().getScheme() != null && !log.getHref().getScheme().equals("file")) {
                        System.err.println("Only file: scheme URIs are supported for directory logging.");
                        this.logstyle = LogOptions.WRAPPED;
                        this.stream = System.err;
                        break;
                    }
                } else {
                    System.err.println("Directory logging requires a directory.");
                    this.logstyle = LogOptions.WRAPPED;
                    this.stream = System.out;
                    break;
                }
                string3 = log.getHref().getPath();
                this.baseDir = new File(string3);
                if (this.baseDir.isDirectory()) break;
                if (this.baseDir.exists()) {
                    System.err.println("Log location is not a directory: " + log.getHref());
                    this.logstyle = LogOptions.WRAPPED;
                    this.stream = System.err;
                    break;
                }
                try {
                    this.baseDir.mkdirs();
                }
                catch (Exception exception) {
                    System.err.println("Could not create log directory: " + log.getHref());
                    this.logstyle = LogOptions.WRAPPED;
                    this.stream = System.err;
                }
                break;
            }
        }
        this.serializer.setOutputStream((OutputStream)this.stream);
    }

    private String dateTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = String.format("%1$tz", gregorianCalendar);
        return String.format("%1$tFT%1$tT", gregorianCalendar) + string.substring(0, 3) + ":" + string.substring(3);
    }

    public void startLogging() {
        String string = this.dateTime();
        if (this.logstyle == LogOptions.OFF) {
            return;
        }
        if (this.logstyle != LogOptions.DIRECTORY) {
            if (this.logstyle == LogOptions.WRAPPED) {
                this.stream.println("<px:document-sequence xmlns:px='http://xmlcalabash.com/ns/document-sequence'");
                this.stream.println("                      port='" + this.log.getPort() + "'");
                this.stream.println("                      xpl-file='" + this.log.xplFile() + "'");
                this.stream.println("                      xpl-line='" + this.log.xplLine() + "'");
                this.stream.println("                      dateTime='" + string + "'>");
            } else {
                this.stream.println("<!-- Start of Calabash output " + this.log + " on " + string + " -->");
            }
        }
        this.logging = true;
    }

    public void stopLogging() {
        if (this.logging) {
            if (this.logstyle == LogOptions.WRAPPED) {
                this.stream.print("</px:document-sequence>");
            }
            if (this.logstyle == LogOptions.PLAIN) {
                this.stream.print("\n");
                this.stream.println("<!-- End of Calabash output log -->");
            }
        }
        this.logging = false;
    }

    public void log(XdmNode xdmNode) {
        if (this.logstyle == LogOptions.OFF) {
            return;
        }
        if (!this.logging) {
            this.startLogging();
        }
        switch (this.logstyle) {
            case WRAPPED: {
                this.stream.print("<px:document>");
                try {
                    S9apiUtils.serialize(this.runtime, xdmNode, this.serializer);
                }
                catch (SaxonApiException saxonApiException) {
                    System.err.println("Logging failed: " + (Object)((Object)saxonApiException));
                }
                this.stream.println("</px:document>");
                break;
            }
            case PLAIN: {
                try {
                    S9apiUtils.serialize(this.runtime, xdmNode, this.serializer);
                }
                catch (SaxonApiException saxonApiException) {
                    System.err.println("Logging failed: " + (Object)((Object)saxonApiException));
                }
                break;
            }
            case DIRECTORY: {
                String string = String.format("%1$s-%2$04d.xml", this.basename, this.outputCount++);
                File file = new File(this.baseDir, string);
                try {
                    this.stream = new PrintStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("Failed to create log: " + this.log.getHref());
                    this.stream = System.err;
                }
                this.serializer.setOutputStream((OutputStream)this.stream);
                this.stream.println("<!-- Start of Calabash output " + this.log + " on " + this.dateTime() + " -->");
                try {
                    S9apiUtils.serialize(this.runtime, xdmNode, this.serializer);
                }
                catch (SaxonApiException saxonApiException) {
                    System.err.println("Logging failed: " + (Object)((Object)saxonApiException));
                }
                this.stream.close();
                break;
            }
        }
    }
}

